/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.AMXStartupServiceMBean;
import org.glassfish.admin.mbeanserver.JMXStartupService;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.amx.BootAMXMBean;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;

final class BootAMX
implements BootAMXMBean {
    private static final Logger JMX_LOGGER = Util.JMX_LOGGER;
    private final MBeanServer mMBeanServer;
    private final ObjectName mObjectName;
    private final ServiceLocator mHabitat;
    private ObjectName mDomainRootObjectName;
    @LogMessageInfo(message="Error while shutting down AMX", level="WARNING")
    static final String errorDuringShutdown = "NCLS-JMX--00008";

    private static void debug(String s) {
        System.out.println(s);
    }

    private BootAMX(ServiceLocator habitat, MBeanServer mbeanServer) {
        this.mHabitat = habitat;
        this.mMBeanServer = mbeanServer;
        this.mObjectName = BootAMX.getBootAMXMBeanObjectName();
        this.mDomainRootObjectName = null;
        if (this.mMBeanServer.isRegistered(this.mObjectName)) {
            throw new IllegalStateException("AMX Booter MBean is already registered: " + String.valueOf(this.mObjectName));
        }
    }

    public static ObjectName getBootAMXMBeanObjectName() {
        return AMXGlassfish.DEFAULT.getBootAMXMBeanObjectName();
    }

    public static synchronized BootAMX create(ServiceLocator habitat, MBeanServer server) {
        BootAMX booter = new BootAMX(habitat, server);
        ObjectName objectName = BootAMX.getBootAMXMBeanObjectName();
        try {
            StandardMBean mbean = new StandardMBean(booter, BootAMXMBean.class);
            if (!server.registerMBean(mbean, objectName).getObjectName().equals(objectName)) {
                throw new IllegalStateException();
            }
        }
        catch (JMException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        return booter;
    }

    AMXStartupServiceMBean getLoader() {
        try {
            return (AMXStartupServiceMBean)this.mHabitat.getService(AMXStartupServiceMBean.class, new Annotation[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public synchronized ObjectName bootAMX() {
        if (this.mDomainRootObjectName == null) {
            this.getLoader();
            ObjectName startupON = AMXStartupServiceMBean.OBJECT_NAME;
            if (!this.mMBeanServer.isRegistered(startupON)) {
                throw new IllegalStateException("AMX MBean not yet available: " + String.valueOf(startupON));
            }
            try {
                this.mDomainRootObjectName = (ObjectName)this.mMBeanServer.invoke(startupON, "loadAMXMBeans", null, null);
            }
            catch (JMException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.mDomainRootObjectName;
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        return JMXStartupService.getJMXServiceURLs(this.mMBeanServer);
    }

    public void shutdown() {
        try {
            this.mMBeanServer.unregisterMBean(BootAMX.getBootAMXMBeanObjectName());
        }
        catch (Exception e) {
            Util.getLogger().log(Level.WARNING, errorDuringShutdown, e);
        }
    }
}

