/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.naming.SerialInitContextFactory;
import com.sun.enterprise.naming.util.LogFacade;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.glassfish.api.Startup;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class GlassFishNamingBuilder
implements InitialContextFactoryBuilder,
Startup,
PostConstruct,
PreDestroy {
    @Inject
    private ServerContext sc;
    private static Logger _logger = LogFacade.getLogger();
    private static final String ALLOW_JNDI_FROM_OSGI = "com.sun.enterprise.naming.allowJndiLookupFromOSGi";

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        String className;
        if (environment != null && (className = (String)environment.get("java.naming.factory.initial")) != null) {
            try {
                return (InitialContextFactory)this.loadClass(className).newInstance();
            }
            catch (Exception e) {
                NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
                ne.setRootCause(e);
                throw ne;
            }
        }
        return new SerialInitContextFactory();
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(className, true, tccl);
        }
        catch (ClassNotFoundException e) {
            _logger.logp(Level.FINE, "GlassFishNamingBuilder", "loadClass", "Failed to load {0} using thread context class loader {1}", new Object[]{className, tccl});
            ClassLoader ccl = this.sc.getCommonClassLoader();
            if (tccl != ccl) {
                try {
                    return Class.forName(className, true, ccl);
                }
                catch (ClassNotFoundException e2) {
                    _logger.logp(Level.WARNING, "GlassFishNamingBuilder", "loadClass", "Failed to load {0} using CommonClassLoader", new Object[]{className});
                    throw e2;
                }
            }
            throw e;
        }
    }

    public void postConstruct() {
        block6: {
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws NamingException {
                                if (GlassFishNamingBuilder.this.isUsingBuilder().booleanValue()) {
                                    NamingManager.setInitialContextFactoryBuilder(GlassFishNamingBuilder.this);
                                }
                                return null;
                            }
                        });
                        break block6;
                    }
                    catch (PrivilegedActionException e) {
                        throw (NamingException)e.getCause();
                    }
                }
                if (this.isUsingBuilder().booleanValue()) {
                    NamingManager.setInitialContextFactoryBuilder(this);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void preDestroy() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (GlassFishNamingBuilder.this.isUsingBuilder().booleanValue()) {
                        GlassFishNamingBuilder.this.resetInitialContextFactoryBuilder();
                    }
                    return null;
                }
            });
        } else if (this.isUsingBuilder().booleanValue()) {
            this.resetInitialContextFactoryBuilder();
        }
    }

    private void resetInitialContextFactoryBuilder() {
        try {
            String fieldName = this.ifIbmJava6() ? "icfb" : "initctx_factory_builder";
            Field f = NamingManager.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(null, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean ifIbmJava6() {
        return System.getProperty("java.vendor", "").equals("IBM Corporation") && System.getProperty("java.version").equals("1.6.0");
    }

    private Boolean isUsingBuilder() {
        return Boolean.valueOf(System.getProperty(ALLOW_JNDI_FROM_OSGI, "true"));
    }
}

