/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

public class NamedNamingObjectManager {
    private static final AtomicReference<Habitat> habitatRef = new AtomicReference();
    private static final Map<String, NamedNamingObjectProxy> proxies = new HashMap<String, NamedNamingObjectProxy>();
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final Logger logger = Logger.getLogger(NamedNamingObjectManager.class.getPackage().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndLoadProxies(Habitat habitat) throws NamingException {
        if (habitatRef.get() != habitat && habitat != null) {
            rwLock.writeLock().lock();
            try {
                if (habitatRef.get() != habitat) {
                    habitatRef.set(habitat);
                    proxies.clear();
                }
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    public static Object tryNamedProxies(String name) throws NamingException {
        NamedNamingObjectProxy proxy = NamedNamingObjectManager.getCachedProxy(name);
        if (proxy != null) {
            logger.logp(Level.INFO, "NamedNamingObjectManager", "tryNamedProxies", "found cached proxy [{0}] for [{1}]", new Object[]{proxy, name});
            return proxy.handle(name);
        }
        for (Inhabitant inhabitant : NamedNamingObjectManager.getHabitat().getInhabitants(NamespacePrefixes.class)) {
            for (String prefix : inhabitant.getDescriptor().getNames()) {
                if (!name.startsWith(prefix)) continue;
                proxy = (NamedNamingObjectProxy)inhabitant.get();
                logger.logp(Level.INFO, "NamedNamingObjectManager", "tryNamedProxies", "found a new proxy [{0}] for [{1}]", new Object[]{proxy, name});
                NamedNamingObjectManager.cacheProxy(prefix, proxy);
                return proxy.handle(name);
            }
        }
        return null;
    }

    private static Habitat getHabitat() {
        return habitatRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NamedNamingObjectProxy getCachedProxy(String name) {
        rwLock.readLock().lock();
        try {
            for (String proxyPrefix : proxies.keySet()) {
                if (!name.startsWith(proxyPrefix)) continue;
                NamedNamingObjectProxy namedNamingObjectProxy = proxies.get(proxyPrefix);
                return namedNamingObjectProxy;
            }
        }
        finally {
            rwLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheProxy(String prefix, NamedNamingObjectProxy proxy) {
        rwLock.writeLock().lock();
        try {
            proxies.put(prefix, proxy);
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }
}

