/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.WrappedSerialContext;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import org.glassfish.api.naming.NamingClusterInfo;
import org.glassfish.hk2.Services;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ORBLocator;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialInitContextFactory
implements InitialContextFactory {
    private static volatile boolean initialized = false;
    protected static final Logger _logger = LogDomains.getLogger(SerialInitContextFactory.class, (String)"javax.enterprise.system.core.naming");
    private static String defaultHost = null;
    private static String defaultPort = null;
    private static Services defaultServices = null;
    private final Services services;

    private static void doLog(Level level, String fmt, Object ... args) {
        if (_logger.isLoggable(level)) {
            _logger.log(level, fmt, args);
        }
    }

    private static void fineLog(String fmt, Object ... args) {
        SerialInitContextFactory.doLog(Level.FINE, fmt, args);
    }

    static void setDefaultHost(String host) {
        defaultHost = host;
    }

    static void setDefaultPort(String port) {
        defaultPort = port;
    }

    static void setDefaultServices(Services h) {
        defaultServices = h;
    }

    static Services getDefaultServices() {
        return defaultServices;
    }

    private boolean propertyIsSet(Hashtable env, String pname) {
        String value = this.getEnvSysProperty(env, pname);
        return value != null && !value.isEmpty();
    }

    private String getEnvSysProperty(Hashtable env, String pname) {
        String value = (String)env.get(pname);
        if (value == null) {
            value = System.getProperty(pname);
        }
        return value;
    }

    private String getCorbalocURL(List<String> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : list) {
            if (first) {
                first = false;
                sb.append("corbaloc:");
            } else {
                sb.append(',');
            }
            sb.append("iiop:1.2@");
            sb.append(str.trim());
        }
        return sb.toString();
    }

    public SerialInitContextFactory() {
        Services temp = defaultServices;
        if (temp == null) {
            temp = Globals.getDefaultServices();
        }
        if (temp == null) {
            temp = Globals.getStaticHabitat();
        }
        this.services = temp;
    }

    private ORB getORB() {
        ORBLocator orbLocator;
        if (this.services != null && (orbLocator = (ORBLocator)this.services.forContract(ORBLocator.class).get()) != null) {
            return orbLocator.getORB();
        }
        throw new RuntimeException("Could not get ORB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Context getInitialContext(Hashtable env) throws NamingException {
        Hashtable<String, String> myEnv = env == null ? new Hashtable<String, String>() : env;
        boolean membershipChangeForced = false;
        SerialInitContextFactory.fineLog("getInitialContext: env={0}", env);
        boolean useLB = this.propertyIsSet(myEnv, "com.sun.appserv.iiop.endpoints") || this.propertyIsSet(myEnv, "com.sun.appserv.iiop.loadbalancingpolicy");
        NamingClusterInfo namingClusterInfo = null;
        if (useLB && !initialized) {
            Class<SerialInitContextFactory> clazz = SerialInitContextFactory.class;
            // MONITORENTER : com.sun.enterprise.naming.impl.SerialInitContextFactory.class
            if (!initialized) {
                namingClusterInfo = (NamingClusterInfo)this.services.forContract(NamingClusterInfo.class).get();
                namingClusterInfo.initGroupInfoService(myEnv, defaultHost, defaultPort, this.getORB(), this.services);
                membershipChangeForced = true;
                initialized = true;
            }
            // MONITOREXIT : clazz
        }
        if (useLB || initialized) {
            if (!myEnv.containsKey("com.sun.appserv.ee.iiop.endpointslist")) {
                Context ctx = SerialContext.getStickyContext();
                if (ctx != null) {
                    return ctx;
                }
                if (namingClusterInfo == null) {
                    namingClusterInfo = (NamingClusterInfo)this.services.forContract(NamingClusterInfo.class).get();
                }
                if (myEnv.containsKey("com.sun.appserv.iiop.endpoints") || myEnv.containsKey("com.sun.appserv.iiop.loadbalancingpolicy")) {
                    Class<SerialInitContextFactory> clazz = SerialInitContextFactory.class;
                    // MONITORENTER : com.sun.enterprise.naming.impl.SerialInitContextFactory.class
                    namingClusterInfo.setClusterInstanceInfo(myEnv, defaultHost, defaultPort, membershipChangeForced);
                    // MONITOREXIT : clazz
                }
                List rrList = namingClusterInfo.getNextRotation();
                SerialInitContextFactory.fineLog("getInitialContext: RoundRobinPolicy list = {0}", rrList);
                myEnv.put("com.sun.appserv.ee.iiop.endpointslist", this.getCorbalocURL(rrList));
            }
            myEnv.put("java.naming.corba.orb", (String)this.getORB());
            return this.createInitialContext(myEnv);
        }
        if (defaultHost != null) {
            myEnv.put("org.omg.CORBA.ORBInitialHost", defaultHost);
        }
        if (defaultPort == null) return this.createInitialContext(myEnv);
        myEnv.put("org.omg.CORBA.ORBInitialPort", defaultPort);
        return this.createInitialContext(myEnv);
    }

    private Context createInitialContext(Hashtable env) throws NamingException {
        SerialContext serialContext = new SerialContext(env, this.services);
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return new WrappedSerialContext(env, serialContext);
        }
        return serialContext;
    }
}

