/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.SerialNameParser;
import com.sun.enterprise.naming.util.LogFacade;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class TransientContext
implements Context,
Serializable {
    Hashtable myEnv;
    private Map<String, Object> bindings = new HashMap<String, Object>();
    static NameParser myParser = new SerialNameParser();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.drillDownAndCreateSubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.drillDownAndDestroySubcontext(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context drillDownAndCreateSubcontext(String name) throws NamingException {
        lock.writeLock().lock();
        try {
            TransientContext ctx;
            CompositeName n = new CompositeName(name);
            if (n.size() <= 1) {
                if (this.bindings.containsKey(name)) {
                    throw new NameAlreadyBoundException("Subcontext " + name + "already present");
                }
                TransientContext ctx2 = null;
                ctx2 = new TransientContext();
                this.bindings.put(name, ctx2);
                TransientContext transientContext = ctx2;
                return transientContext;
            }
            String suffix = n.getSuffix(1).toString();
            try {
                ctx = this.resolveContext(n.get(0));
            }
            catch (NameNotFoundException e) {
                ctx = new TransientContext();
            }
            Context retCtx = ctx.createSubcontext(suffix);
            this.bindings.put(n.get(0), ctx);
            Context context = retCtx;
            return context;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drillDownAndDestroySubcontext(String name) throws NamingException {
        lock.writeLock().lock();
        try {
            CompositeName n = new CompositeName(name);
            if (n.size() < 1) {
                throw new InvalidNameException("Cannot destoy empty subcontext");
            }
            if (n.size() == 1) {
                if (!this.bindings.containsKey(name)) throw new NameNotFoundException("Subcontext: " + name + " not found");
                this.bindings.remove(name);
                return;
            } else {
                String suffix = n.getSuffix(1).toString();
                TransientContext ctx = this.resolveContext(n.get(0));
                ctx.destroySubcontext(suffix);
            }
            return;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String name) throws NamingException {
        lock.readLock().lock();
        try {
            CompositeName n = new CompositeName(name);
            if (n.size() < 1) {
                throw new InvalidNameException("Cannot bind empty name");
            }
            if (n.size() == 1) {
                Object object = this.doLookup(((Object)n).toString());
                return object;
            }
            String suffix = n.getSuffix(1).toString();
            TransientContext ctx = this.resolveContext(n.get(0));
            Object object = ctx.lookup(suffix);
            return object;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    private Object doLookup(String name) throws NamingException {
        Object answer = this.bindings.get(name);
        if (answer == null) {
            throw new NameNotFoundException(name + " not found");
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String name, Object obj) throws NamingException {
        block7: {
            lock.writeLock().lock();
            try {
                Context ctx;
                CompositeName n = new CompositeName(name);
                if (n.size() < 1) {
                    throw new InvalidNameException("Cannot bind empty name");
                }
                if (n.size() == 1) {
                    this.doBindOrRebind(((Object)n).toString(), obj, false);
                    break block7;
                }
                String suffix = n.getSuffix(1).toString();
                try {
                    ctx = this.resolveContext(n.get(0));
                }
                catch (NameNotFoundException e) {
                    ctx = this.createSubcontext(n.get(0));
                }
                ctx.bind(suffix, obj);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    private TransientContext resolveContext(String s) throws NamingException {
        Object obj = this.bindings.get(s);
        if (obj == null) {
            throw new NameNotFoundException(s);
        }
        if (!(obj instanceof TransientContext)) {
            throw new NameAlreadyBoundException(s);
        }
        TransientContext ctx = (TransientContext)obj;
        return ctx;
    }

    private void doBindOrRebind(String name, Object obj, boolean rebind) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (!rebind && this.bindings.get(name) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Object obj) throws NamingException {
        lock.writeLock().lock();
        try {
            CompositeName n = new CompositeName(name);
            if (n.size() < 1) {
                throw new InvalidNameException("Cannot bind empty name");
            }
            if (n.size() == 1) {
                this.doBindOrRebind(((Object)n).toString(), obj, true);
            } else {
                String suffix = n.getSuffix(1).toString();
                Context ctx = null;
                try {
                    ctx = this.resolveContext(n.get(0));
                    ctx.rebind(suffix, obj);
                }
                catch (NameNotFoundException e) {
                    ctx = this.createSubcontext(n.get(0));
                    ctx.rebind(suffix, obj);
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    private void doUnbind(String name) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        if (this.bindings.get(name) == null) {
            throw new NameNotFoundException("Cannot find name to unbind");
        }
        this.bindings.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String name) throws NamingException {
        lock.writeLock().lock();
        try {
            CompositeName n = new CompositeName(name);
            if (n.size() < 1) {
                throw new InvalidNameException("Cannot unbind empty name");
            }
            if (n.size() == 1) {
                this.doUnbind(((Object)n).toString());
            } else {
                String suffix = n.getSuffix(1).toString();
                TransientContext ctx = this.resolveContext(n.get(0));
                ctx.unbind(suffix);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String oldname, String newname) throws NamingException {
        if (oldname.equals("") || newname.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        lock.writeLock().lock();
        try {
            if (this.bindings.get(newname) != null) {
                throw new NameAlreadyBoundException(newname + " is already bound");
            }
            Object oldBinding = this.bindings.remove(oldname);
            if (oldBinding == null) {
                throw new NameNotFoundException(oldname + " not bound");
            }
            this.bindings.put(newname, oldBinding);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable list() {
        lock.readLock().lock();
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(this.bindings);
            return hashtable;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public Hashtable listContext(String name) throws NamingException {
        lock.readLock().lock();
        try {
            if (LogFacade.logger.isLoggable(Level.FINE)) {
                TransientContext.print(this.bindings);
            }
            if (name.equals("")) {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>(this.bindings);
                return hashtable;
            }
            Object target = this.lookup(name);
            if (target instanceof TransientContext) {
                Hashtable hashtable = ((TransientContext)target).listContext("");
                return hashtable;
            }
            throw new NotContextException(name + " cannot be listed");
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        lock.readLock().lock();
        try {
            if (LogFacade.logger.isLoggable(Level.FINE)) {
                TransientContext.print(this.bindings);
            }
            if (name.equals("")) {
                RepNames<NameClassPair> repNames = new RepNames<NameClassPair>(new Hashtable<String, Object>(this.bindings));
                return repNames;
            }
            Object target = this.lookup(name);
            if (target instanceof Context) {
                NamingEnumeration<NameClassPair> namingEnumeration = ((Context)target).list("");
                return namingEnumeration;
            }
            throw new NotContextException(name + " cannot be listed");
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        lock.readLock().lock();
        try {
            if (name.equals("")) {
                RepBindings<Binding> repBindings = new RepBindings<Binding>(new Hashtable<String, Object>(this.bindings));
                return repBindings;
            }
            Object target = this.lookup(name);
            if (target instanceof Context) {
                NamingEnumeration<Binding> namingEnumeration = ((Context)target).listBindings("");
                return namingEnumeration;
            }
            throw new NotContextException(name + " cannot be listed");
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        lock.writeLock().lock();
        try {
            if (this.myEnv == null) {
                this.myEnv = new Hashtable(5, 0.75f);
            }
            Object object = this.myEnv.put(propName, propVal);
            return object;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        lock.writeLock().lock();
        try {
            if (this.myEnv == null) {
                Object var2_2 = null;
                return var2_2;
            }
            Object v = this.myEnv.remove(propName);
            return v;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getEnvironment() throws NamingException {
        lock.writeLock().lock();
        try {
            if (this.myEnv == null) {
                this.myEnv = new Hashtable(3, 0.75f);
            }
            Hashtable hashtable = this.myEnv;
            return hashtable;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws NamingException {
        this.myEnv = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace() not implemented");
    }

    private static void print(Map<String, Object> ht) {
        for (Map.Entry<String, Object> entry : ht.entrySet()) {
            Object value = entry.getValue();
            LogFacade.logger.log(Level.FINE, "[{0}, {1}:{2}]", new Object[]{entry.getKey(), value, value.getClass().getName()});
        }
    }

    static class RepBindings<T>
    implements NamingEnumeration<T> {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        @Override
        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public T nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return (T)new Binding(name, this.bindings.get(name));
            }
            return null;
        }

        @Override
        public T next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() {
        }
    }

    static class RepNames<T>
    implements NamingEnumeration<T> {
        private Map<String, String> nameToClassName = new HashMap<String, String>();
        private Iterator<String> iter;

        RepNames(Hashtable bindings) {
            HashSet<String> names = new HashSet<String>();
            for (Object k : bindings.keySet()) {
                names.add((String)k);
            }
            this.iter = names.iterator();
            for (Object object : bindings.entrySet()) {
                Map.Entry entry = (Map.Entry)object;
                this.nameToClassName.put((String)entry.getKey(), entry.getValue().getClass().getName());
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public T nextElement() {
            if (this.iter.hasNext()) {
                String name = this.iter.next();
                String className = this.nameToClassName.get(name);
                return (T)new NameClassPair(name, className);
            }
            return null;
        }

        @Override
        public T next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() {
        }
    }
}

