/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.JavaURLContext;
import com.sun.enterprise.naming.impl.ProviderManager;
import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.SerialNameParser;
import com.sun.enterprise.naming.util.LogFacade;
import java.lang.annotation.Annotation;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;

@Service
@Singleton
public final class GlassfishNamingManagerImpl
implements GlassfishNamingManager {
    @LogMessageInfo(message="Error during CosNaming.unbind for name {0}: {1}")
    public static final String ERROR_COSNAMING_UNBIND = "AS-NAMING-00004";
    @LogMessageInfo(message="Naming binding already exists for {0} in namespace {1}")
    public static final String NAMING_ALREADY_EXISTS = "AS-NAMING-00005";
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.util.IIOPObjectFactory";
    private static final int JAVA_COMP_LENGTH = "java:comp".length();
    private static final int JAVA_MODULE_LENGTH = "java:module".length();
    @Inject
    private ServiceLocator habitat;
    volatile InvocationManager invMgr = null;
    private InitialContext initialContext;
    private Context cosContext;
    private NameParser nameParser = new SerialNameParser();
    private Map componentNamespaces;
    private Map<String, Map> appNamespaces;
    private Map<AppModuleKey, Map> moduleNamespaces;
    private Map<String, ComponentIdInfo> componentIdInfo;

    public GlassfishNamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    void setInvocationManager(InvocationManager invMgr) {
        this.invMgr = invMgr;
    }

    public GlassfishNamingManagerImpl(InitialContext ic) throws NamingException {
        this.initialContext = ic;
        this.componentNamespaces = new Hashtable();
        this.appNamespaces = new HashMap<String, Map>();
        this.moduleNamespaces = new HashMap<AppModuleKey, Map>();
        this.componentIdInfo = new HashMap<String, ComponentIdInfo>();
        JavaURLContext.setNamingManager(this);
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public NameParser getNameParser() {
        return this.nameParser;
    }

    public Remote initializeRemoteNamingSupport(ORB orb) throws NamingException {
        Remote remoteProvider;
        try {
            Hashtable<String, String> cosNamingEnv = new Hashtable<String, String>();
            cosNamingEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            cosNamingEnv.put("java.naming.corba.orb", (String)orb);
            this.cosContext = new InitialContext(cosNamingEnv);
            ProviderManager pm = ProviderManager.getProviderManager();
            remoteProvider = pm.initRemoteProvider(orb);
        }
        catch (RemoteException re) {
            NamingException ne = new NamingException("Exception during remote naming initialization");
            ne.initCause(ne);
            throw ne;
        }
        return remoteProvider;
    }

    private Context getCosContext() {
        return this.cosContext;
    }

    public void publishObject(String name, Object obj, boolean rebind) throws NamingException {
        CompositeName nameobj = new CompositeName(name);
        this.publishObject(nameobj, obj, rebind);
    }

    public void publishObject(Name name, Object obj, boolean rebind) throws NamingException {
        if (rebind) {
            this.initialContext.rebind(name, obj);
        } else {
            this.initialContext.bind(name, obj);
        }
    }

    public void publishCosNamingObject(String name, Object obj, boolean rebind) throws NamingException {
        CompositeName nameObj = new CompositeName(name);
        this.createSubContexts(nameObj, this.getCosContext());
        if (rebind) {
            this.getCosContext().rebind(name, obj);
        } else {
            this.getCosContext().bind(name, obj);
        }
        Reference serialObj = new Reference("reference", new StringRefAddr("url", name), IIOPOBJECT_FACTORY, null);
        this.publishObject(name, (Object)serialObj, rebind);
    }

    public void unpublishObject(String name) throws NamingException {
        this.initialContext.unbind(name);
    }

    public void unpublishCosNamingObject(String name) throws NamingException {
        try {
            this.getCosContext().unbind(name);
        }
        catch (NamingException cne) {
            LogFacade.logger.log(Level.WARNING, ERROR_COSNAMING_UNBIND, new Object[]{name, cne});
        }
        this.initialContext.unbind(name);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }

    private void createSubContexts(Name name, Context rootCtx) throws NamingException {
        int numSubContexts = name.size() - 1;
        Context currentCtx = rootCtx;
        for (int subCtxIndex = 0; subCtxIndex < numSubContexts; ++subCtxIndex) {
            String subCtxName = name.get(subCtxIndex);
            try {
                Object obj = currentCtx.lookup(subCtxName);
                if (obj == null) {
                    currentCtx = currentCtx.createSubcontext(subCtxName);
                    continue;
                }
                if (obj instanceof Context) {
                    currentCtx = (Context)obj;
                    continue;
                }
                throw new NameAlreadyBoundException(subCtxName);
            }
            catch (NameNotFoundException e) {
                currentCtx = currentCtx.createSubcontext(subCtxName);
            }
        }
    }

    private Map getComponentNamespace(String componentId) throws NamingException {
        HashMap<String, JavaURLContext> namespace = (HashMap<String, JavaURLContext>)this.componentNamespaces.get(componentId);
        if (namespace == null) {
            namespace = new HashMap<String, JavaURLContext>();
            this.componentNamespaces.put(componentId, namespace);
            JavaURLContext jc = new JavaURLContext("java:", null);
            namespace.put("java:", jc);
            namespace.put("java:/", jc);
            JavaURLContext jcc = new JavaURLContext("java:comp", null);
            namespace.put("java:comp", jcc);
            namespace.put("java:comp/", jcc);
            JavaURLContext jccEnv = new JavaURLContext("java:comp/env", null);
            namespace.put("java:comp/env", jccEnv);
            namespace.put("java:comp/env/", jccEnv);
        }
        return namespace;
    }

    private Map getModuleNamespace(AppModuleKey appModuleKey) throws NamingException {
        if (appModuleKey.getAppName() == null || appModuleKey.getModuleName() == null) {
            throw new NamingException("Invalid appModuleKey " + appModuleKey);
        }
        Hashtable<String, JavaURLContext> namespace = this.moduleNamespaces.get(appModuleKey);
        if (namespace == null) {
            namespace = new Hashtable<String, JavaURLContext>();
            this.moduleNamespaces.put(appModuleKey, namespace);
            JavaURLContext jc = new JavaURLContext("java:", null);
            namespace.put("java:", jc);
            namespace.put("java:/", jc);
            JavaURLContext jMod = new JavaURLContext("java:module", null);
            namespace.put("java:module", jMod);
            namespace.put("java:module/", jMod);
            JavaURLContext jModEnv = new JavaURLContext("java:module/env", null);
            namespace.put("java:module/env", jModEnv);
            namespace.put("java:module/env/", jModEnv);
        }
        return namespace;
    }

    private Object lookupFromNamespace(String name, Map namespace, Hashtable env) throws NamingException {
        Object o;
        block7: {
            o = namespace.get(name);
            if (o == null) {
                throw new NameNotFoundException("No object bound to name " + name);
            }
            if (o instanceof NamingObjectProxy) {
                NamingObjectProxy namingProxy = (NamingObjectProxy)o;
                InitialContext ic = this.initialContext;
                if (env != null) {
                    ic = new InitialContext(env);
                }
                o = namingProxy.create((Context)ic);
            } else if (o instanceof Reference) {
                try {
                    o = this.getObjectInstance(name, o, env);
                }
                catch (Exception e) {
                    if (!LogFacade.logger.isLoggable(Level.FINEST)) break block7;
                    LogFacade.logger.log(Level.FINEST, "Unable to get Object instance from Reference for name [" + name + "]. " + "Hence returning the Reference object ", e);
                }
            }
        }
        return o;
    }

    public Object lookupFromAppNamespace(String appName, String name, Hashtable env) throws NamingException {
        Map namespace = this.getAppNamespace(appName);
        return this.lookupFromNamespace(name, namespace, env);
    }

    public Object lookupFromModuleNamespace(String appName, String moduleName, String name, Hashtable env) throws NamingException {
        AppModuleKey appModuleKey = new AppModuleKey(appName, moduleName);
        Map namespace = this.getModuleNamespace(appModuleKey);
        return this.lookupFromNamespace(name, namespace, env);
    }

    private Object getObjectInstance(String name, Object obj, Hashtable env) throws Exception {
        if (env == null) {
            env = new Hashtable();
        }
        return NamingManager.getObjectInstance(obj, new CompositeName(name), null, env);
    }

    private Map getAppNamespace(String appName) throws NamingException {
        if (appName == null) {
            throw new NamingException("Null appName");
        }
        Hashtable<String, JavaURLContext> namespace = this.appNamespaces.get(appName);
        if (namespace == null) {
            namespace = new Hashtable<String, JavaURLContext>();
            this.appNamespaces.put(appName, namespace);
            JavaURLContext jc = new JavaURLContext("java:", null);
            namespace.put("java:", jc);
            namespace.put("java:/", jc);
            JavaURLContext jApp = new JavaURLContext("java:app", null);
            namespace.put("java:app", jApp);
            namespace.put("java:app/", jApp);
            JavaURLContext jAppEnv = new JavaURLContext("java:app/env", null);
            namespace.put("java:app/env", jAppEnv);
            namespace.put("java:app/env/", jAppEnv);
        }
        return namespace;
    }

    private Map getNamespace(String componentId, String logicalJndiName) throws NamingException {
        ComponentIdInfo info = this.componentIdInfo.get(componentId);
        return info != null ? this.getNamespace(info.appName, info.moduleName, componentId, logicalJndiName) : this.getComponentNamespace(componentId);
    }

    private Map getNamespace(String appName, String moduleName, String componentId, String logicalJndiName) throws NamingException {
        Map namespace = logicalJndiName.startsWith("java:comp") ? this.getComponentNamespace(componentId) : (logicalJndiName.startsWith("java:module") ? this.getModuleNamespace(new AppModuleKey(appName, moduleName)) : (logicalJndiName.startsWith("java:app") ? this.getAppNamespace(appName) : this.getComponentNamespace(componentId)));
        return namespace;
    }

    private void bindToNamespace(Map namespace, String logicalJndiName, Object value) throws NamingException {
        if (LogFacade.logger.isLoggable(Level.FINE)) {
            LogFacade.logger.log(Level.FINE, "naming.bind Binding name:{0}", logicalJndiName);
        }
        if (namespace.put(logicalJndiName, value) != null) {
            LogFacade.logger.log(Level.WARNING, NAMING_ALREADY_EXISTS, new Object[]{logicalJndiName, namespace.toString()});
        }
        this.bindIntermediateContexts(namespace, logicalJndiName);
    }

    private boolean existsInNamespace(Map namespace, String logicalJndiName) {
        return namespace.containsKey(logicalJndiName);
    }

    public void bindToComponentNamespace(String appName, String moduleName, String componentId, boolean treatComponentAsModule, Collection<? extends JNDIBinding> bindings) throws NamingException {
        if (appName != null && moduleName != null) {
            ComponentIdInfo info = new ComponentIdInfo();
            info.appName = appName;
            info.moduleName = moduleName;
            info.componentId = componentId;
            info.treatComponentAsModule = treatComponentAsModule;
            this.componentIdInfo.put(componentId, info);
        }
        for (JNDIBinding jNDIBinding : bindings) {
            String logicalJndiName = jNDIBinding.getName();
            Map namespace = null;
            if (treatComponentAsModule && logicalJndiName.startsWith("java:comp")) {
                logicalJndiName = this.logicalCompJndiNameToModule(logicalJndiName);
            }
            if (logicalJndiName.startsWith("java:comp")) {
                namespace = this.getComponentNamespace(componentId);
            } else if (logicalJndiName.startsWith("java:module")) {
                namespace = this.getModuleNamespace(new AppModuleKey(appName, moduleName));
            } else if (logicalJndiName.startsWith("java:app")) {
                namespace = this.getAppNamespace(appName);
            }
            if (namespace == null || this.existsInNamespace(namespace, logicalJndiName)) continue;
            this.bindToNamespace(namespace, logicalJndiName, jNDIBinding.getValue());
        }
    }

    private String logicalCompJndiNameToModule(String logicalCompName) {
        String tail = logicalCompName.substring(JAVA_COMP_LENGTH);
        return "java:module" + tail;
    }

    private String logicalModuleJndiNameToComp(String logicalModuleName) {
        String tail = logicalModuleName.substring(JAVA_MODULE_LENGTH);
        return "java:comp" + tail;
    }

    public void bindToModuleNamespace(String appName, String moduleName, Collection<? extends JNDIBinding> bindings) throws NamingException {
        AppModuleKey appModuleKey = new AppModuleKey(appName, moduleName);
        Map namespace = this.getModuleNamespace(appModuleKey);
        for (JNDIBinding jNDIBinding : bindings) {
            String logicalJndiName = jNDIBinding.getName();
            if (!logicalJndiName.startsWith("java:module")) continue;
            this.bindToNamespace(namespace, jNDIBinding.getName(), jNDIBinding.getValue());
        }
    }

    public void bindToAppNamespace(String appName, Collection<? extends JNDIBinding> bindings) throws NamingException {
        Map namespace = this.getAppNamespace(appName);
        for (JNDIBinding jNDIBinding : bindings) {
            String logicalJndiName = jNDIBinding.getName();
            if (!logicalJndiName.startsWith("java:app")) continue;
            this.bindToNamespace(namespace, jNDIBinding.getName(), jNDIBinding.getValue());
        }
    }

    private void bindIntermediateContexts(Map namespace, String name) throws NamingException {
        String partialName;
        if (name.startsWith("java:comp/")) {
            partialName = "java:comp";
        } else if (name.startsWith("java:module/")) {
            partialName = "java:module";
        } else if (name.startsWith("java:app/")) {
            partialName = "java:app";
        } else {
            throw new NamingException("Invalid environment namespace name : " + name);
        }
        name = name.substring((partialName + "/").length());
        StringTokenizer toks = new StringTokenizer(name, "/", false);
        StringBuilder sb = new StringBuilder();
        sb.append(partialName);
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            sb.append("/").append(tok);
            partialName = sb.toString();
            if (namespace.get(partialName) != null) continue;
            namespace.put(partialName, new JavaURLContext(partialName, null));
        }
    }

    public void unbindComponentObjects(String componentId) throws NamingException {
        this.componentNamespaces.remove(componentId);
        this.componentIdInfo.remove(componentId);
    }

    public void unbindAppObjects(String appName) throws NamingException {
        this.appNamespaces.remove(appName);
        Iterator<Map.Entry<AppModuleKey, Map>> moduleEntries = this.moduleNamespaces.entrySet().iterator();
        while (moduleEntries.hasNext()) {
            Map.Entry<AppModuleKey, Map> entry = moduleEntries.next();
            if (!entry.getKey().getAppName().equals(appName)) continue;
            moduleEntries.remove();
        }
    }

    public void unbindAppObject(String appName, String name) throws NamingException {
        Map namespaces = this.appNamespaces.get(appName);
        if (namespaces != null) {
            namespaces.remove(name);
        }
    }

    public void unbindModuleObject(String appName, String moduleName, String name) throws NamingException {
        AppModuleKey appModuleKey = new AppModuleKey(appName, moduleName);
        Map namespaces = this.moduleNamespaces.get(appModuleKey);
        if (namespaces != null) {
            namespaces.remove(name);
        }
    }

    public Context restoreJavaCompEnvContext(String contextName) throws NamingException {
        if (!contextName.startsWith("java:")) {
            throw new NamingException("Invalid context name [" + contextName + "]. Name must start with java:");
        }
        return new JavaURLContext(contextName, null);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(name, (SerialContext)null);
    }

    public Object lookup(String name, SerialContext serialContext) throws NamingException {
        Context ic = serialContext != null ? serialContext : this.initialContext;
        String componentId = this.getComponentId();
        return this.lookup(componentId, name, ic);
    }

    public Object lookup(String componentId, String name) throws NamingException {
        return this.lookup(componentId, name, this.initialContext);
    }

    private Object lookup(String componentId, String name, Context ctx) throws NamingException {
        Map namespace;
        Object obj;
        boolean replaceName;
        ComponentIdInfo info = this.componentIdInfo.get(componentId);
        String logicalJndiName = name;
        boolean bl = replaceName = info != null && info.treatComponentAsModule && name.startsWith("java:comp");
        if (replaceName) {
            logicalJndiName = this.logicalCompJndiNameToModule(name);
        }
        if ((obj = (namespace = this.getNamespace(componentId, logicalJndiName)).get(logicalJndiName)) == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (obj instanceof NamingObjectProxy) {
            NamingObjectProxy namingProxy = (NamingObjectProxy)obj;
            obj = namingProxy.create(ctx);
        } else if (obj instanceof Context) {
            if (replaceName) {
                obj = new JavaURLContext(name, null);
            }
            if (obj instanceof JavaURLContext) {
                obj = ctx instanceof SerialContext ? new JavaURLContext((JavaURLContext)obj, (SerialContext)ctx) : new JavaURLContext((JavaURLContext)obj, null);
            }
        }
        return obj;
    }

    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new BindingsIterator<NameClassPair>(this, list.iterator(), true);
    }

    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new BindingsIterator<Binding>(this, list.iterator(), false);
    }

    private ArrayList listNames(String name) throws NamingException {
        Map namespace;
        Object obj;
        boolean replaceName;
        String componentId = this.getComponentId();
        ComponentIdInfo info = this.componentIdInfo.get(componentId);
        String logicalJndiName = name;
        boolean bl = replaceName = info != null && info.treatComponentAsModule && name.startsWith("java:comp");
        if (replaceName) {
            logicalJndiName = this.logicalCompJndiNameToModule(name);
        }
        if ((obj = (namespace = this.getNamespace(componentId, logicalJndiName)).get(logicalJndiName)) == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (!(obj instanceof JavaURLContext)) {
            throw new NotContextException(name + " cannot be listed");
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator itr = namespace.keySet().iterator();
        if (!logicalJndiName.endsWith("/")) {
            logicalJndiName = logicalJndiName + "/";
        }
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(logicalJndiName) || key.indexOf(47, logicalJndiName.length()) != -1 || key.equals(logicalJndiName)) continue;
            String toAdd = replaceName ? this.logicalModuleJndiNameToComp(key) : key;
            list.add(toAdd);
        }
        return list;
    }

    private String getComponentId() throws NamingException {
        String id;
        ComponentInvocation ci = this.invMgr == null ? ((InvocationManager)this.habitat.getService(InvocationManager.class, new Annotation[0])).getCurrentInvocation() : this.invMgr.getCurrentInvocation();
        if (ci == null) {
            throw new NamingException("Invocation exception: Got null ComponentInvocation ");
        }
        try {
            id = ci.getComponentId();
            if (id == null) {
                throw new NamingException("Invocation exception: ComponentId is null");
            }
        }
        catch (Throwable th) {
            NamingException ine = new NamingException("Invocation exception: " + th);
            ine.initCause(th);
            throw ine;
        }
        return id;
    }

    private static class BindingsIterator<T>
    implements NamingEnumeration<T> {
        private GlassfishNamingManagerImpl nm;
        private Iterator names;
        private boolean producesNamesOnly;

        BindingsIterator(GlassfishNamingManagerImpl nm, Iterator names, boolean producesNamesOnly) {
            this.nm = nm;
            this.names = names;
            this.producesNamesOnly = producesNamesOnly;
        }

        @Override
        public boolean hasMoreElements() {
            return this.names.hasNext();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public T nextElement() {
            if (this.names.hasNext()) {
                try {
                    String name = (String)this.names.next();
                    Object obj = this.nm.lookup(name);
                    return (T)(this.producesNamesOnly ? new NameClassPair(name, this.getClass().getName()) : new Binding(name, obj));
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return null;
        }

        @Override
        public T next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() {
        }
    }

    private static class ComponentIdInfo {
        String appName;
        String moduleName;
        String componentId;
        boolean treatComponentAsModule;

        private ComponentIdInfo() {
        }

        public String toString() {
            return "appName = " + this.appName + " , module = " + this.moduleName + " , componentId = " + this.componentId + ", treatComponentAsModule = " + this.treatComponentAsModule;
        }
    }

    private static class AppModuleKey {
        private String app;
        private String module;

        public AppModuleKey(String appName, String moduleName) {
            this.app = appName;
            this.module = moduleName;
        }

        public boolean equals(Object o) {
            boolean equal = false;
            if (o != null && o instanceof AppModuleKey) {
                AppModuleKey other = (AppModuleKey)o;
                if (this.app.equals(other.app) && this.module.equals(other.module)) {
                    equal = true;
                }
            }
            return equal;
        }

        public int hashCode() {
            return this.app.hashCode();
        }

        public String getAppName() {
            return this.app;
        }

        public String getModuleName() {
            return this.module;
        }

        public String toString() {
            return "appName = " + this.app + " , module = " + this.module;
        }
    }
}

