/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class ModuleInfo {
    protected Set<EngineRef> engines = new LinkedHashSet<EngineRef>();
    protected final Map<Class<? extends Object>, Object> metaData = new HashMap<Class<? extends Object>, Object>();
    protected final String name;
    protected final Events events;
    private Properties moduleProps;
    private boolean started = false;
    private ClassLoader moduleClassLoader;
    private Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();

    public ModuleInfo(Events events, String name, Collection<EngineRef> refs, Properties moduleProps) {
        this.name = name;
        this.events = events;
        for (EngineRef ref : refs) {
            this.engines.add(ref);
        }
        this.moduleProps = moduleProps;
    }

    public Set<EngineRef> getEngineRefs() {
        LinkedHashSet<EngineRef> copy = new LinkedHashSet<EngineRef>();
        copy.addAll(this._getEngineRefs());
        return copy;
    }

    protected Set<EngineRef> _getEngineRefs() {
        return this.engines;
    }

    public Set<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    public void cleanClassLoaders() {
        this.classLoaders = null;
        this.moduleClassLoader = null;
    }

    public void addMetaData(Object o) {
        this.metaData.put(o.getClass(), o);
    }

    public <T> T getMetaData(Class<T> c) {
        return c.cast(this.metaData.get(c));
    }

    public Object getMetaData(String className) {
        for (Class<? extends Object> c : this.metaData.keySet()) {
            if (!c.getName().equals(className)) continue;
            return this.metaData.get(c);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Properties getModuleProps() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.moduleProps);
        return props;
    }

    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineRef engine : this._getEngineRefs()) {
            sniffers.add(engine.getContainerInfo().getSniffer());
        }
        return sniffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        Logger logger = context.getLogger();
        context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
        DeploymentTracing tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.LOAD);
        }
        this.moduleClassLoader = context.getClassLoader();
        LinkedHashSet<EngineRef> filteredEngines = new LinkedHashSet<EngineRef>();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            for (EngineRef engine : this._getEngineRefs()) {
                EngineInfo engineInfo = engine.getContainerInfo();
                if (tracing != null) {
                    tracing.addContainerMark(DeploymentTracing.ContainerMark.LOAD, engineInfo.getSniffer().getModuleType());
                }
                Deployer deployer = engineInfo.getDeployer();
                try {
                    ApplicationContainer appCtr = deployer.load(engineInfo.getContainer(), (DeploymentContext)context);
                    if (appCtr == null) {
                        String msg = "Cannot load application in " + engineInfo.getContainer().getName() + " container";
                        logger.fine(msg);
                        continue;
                    }
                    engine.load(context, tracker);
                    engine.setApplicationContainer(appCtr);
                    filteredEngines.add(engine);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while invoking " + deployer.getClass() + " load method", e);
                    throw e;
                }
                if (tracing == null) continue;
                tracing.addContainerMark(DeploymentTracing.ContainerMark.LOADED, engineInfo.getSniffer().getModuleType());
            }
            this.engines = filteredEngines;
            if (tracing != null) {
                tracing.addMark(DeploymentTracing.Mark.LOAD_EVENTS);
            }
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.MODULE_LOADED, (Object)this), false);
            }
            if (tracing != null) {
                tracing.addMark(DeploymentTracing.Mark.LOADED);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public <T extends Container> EngineRef getEngineRefForContainer(Class<T> type2) {
        for (EngineRef engine : this._getEngineRefs()) {
            Container container = null;
            try {
                container = (Container)type2.cast(engine.getContainerInfo().getContainer());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (container == null) continue;
            return engine;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(DeploymentContext context, ProgressTracker tracker) throws Exception {
        Logger logger = context.getLogger();
        if (this.started) {
            return;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            for (EngineRef engine : this._getEngineRefs()) {
                DeploymentTracing tracing;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("starting " + engine.getContainerInfo().getSniffer().getModuleType());
                }
                if ((tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class)) != null) {
                    tracing.addContainerMark(DeploymentTracing.ContainerMark.START, engine.getContainerInfo().getSniffer().getModuleType());
                }
                try {
                    if (!engine.start((ApplicationContext)context, tracker)) {
                        logger.log(Level.SEVERE, "Module not started " + engine.getApplicationContainer().toString());
                        throw new Exception("Module not started " + engine.getApplicationContainer().toString());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while invoking " + engine.getApplicationContainer().getClass() + " start method", e);
                    throw e;
                }
                if (tracing == null) continue;
                tracing.addContainerMark(DeploymentTracing.ContainerMark.STARTED, engine.getContainerInfo().getSniffer().getModuleType());
            }
            this.started = true;
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.MODULE_STARTED, (Object)this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(ExtendedDeploymentContext context, Logger logger) {
        if (!this.started) {
            return;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
            for (EngineRef module : this._getEngineRefs()) {
                try {
                    context.setClassLoader(this.moduleClassLoader);
                    module.stop((ApplicationContext)context);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Cannot stop module " + module.getContainerInfo().getSniffer().getModuleType(), e);
                }
            }
            this.started = false;
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.MODULE_STOPPED, (Object)this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(ExtendedDeploymentContext context) {
        Logger logger = context.getLogger();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
            for (EngineRef engine : this._getEngineRefs()) {
                if (engine.getApplicationContainer() == null || engine.getApplicationContainer().getClassLoader() == null) continue;
                this.classLoaders.add(engine.getApplicationContainer().getClassLoader());
                try {
                    context.setClassLoader(this.moduleClassLoader);
                    engine.unload(context);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Failed to unload from container type : " + engine.getContainerInfo().getSniffer().getModuleType(), e);
                }
            }
            if (this.classLoaders != null && this.moduleClassLoader != null) {
                this.classLoaders.add(this.moduleClassLoader);
            }
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.MODULE_UNLOADED, (Object)this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            context.setClassLoader(null);
        }
    }

    public void clean(ExtendedDeploymentContext context) throws Exception {
        for (EngineRef ref : this._getEngineRefs()) {
            ref.clean(context);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_CLEANED, (Object)context), false);
        }
    }

    public boolean suspend(Logger logger) {
        boolean isSuccess = true;
        for (EngineRef engine : this._getEngineRefs()) {
            try {
                engine.getApplicationContainer().suspend();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error suspending module " + engine.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public boolean resume(Logger logger) {
        boolean isSuccess = true;
        for (EngineRef module : this._getEngineRefs()) {
            try {
                module.getApplicationContainer().resume();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error resuming module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public void save(Module module) throws TransactionFailure, PropertyVetoException {
        if (Boolean.valueOf(this.moduleProps.getProperty("isComposite")).booleanValue()) {
            this.moduleProps.remove("isComposite");
            for (String string : this.moduleProps.keySet()) {
                Property prop = (Property)module.createChild(Property.class);
                module.getProperty().add(prop);
                prop.setName(string);
                prop.setValue(this.moduleProps.getProperty(string));
            }
        }
        for (EngineRef engineRef : this._getEngineRefs()) {
            Engine engine = (Engine)module.createChild(Engine.class);
            module.getEngines().add(engine);
            engineRef.save(engine);
        }
    }
}

