/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

public class EngineInfo<T extends Container, U extends ApplicationContainer<?>> {
    final ServiceHandle<T> container;
    final Sniffer sniffer;
    ContainerRegistry registry;
    Deployer<T, U> deployer;

    public EngineInfo(ServiceHandle<T> container, Sniffer sniffer, ClassLoader cloader) {
        this.container = container;
        this.sniffer = sniffer;
    }

    public T getContainer() {
        return (T)((Container)this.container.getService());
    }

    public Sniffer getSniffer() {
        return this.sniffer;
    }

    public Deployer<T, U> getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer<T, U> deployer) {
        this.deployer = deployer;
    }

    public void load(ExtendedDeploymentContext context) {
    }

    public void unload(ExtendedDeploymentContext context) throws Exception {
    }

    public void clean(ExtendedDeploymentContext context) throws Exception {
        this.getDeployer().clean((DeploymentContext)context);
    }

    public void setRegistry(ContainerRegistry registry) {
        this.registry = registry;
    }

    public void stop(Logger logger) {
        ServiceHandle serviceHandle;
        if (this.getDeployer() != null && (serviceHandle = this.registry.serviceLocator.getServiceHandle(this.getDeployer().getClass(), new Annotation[0])) != null) {
            serviceHandle.close();
        }
        if (this.container != null && this.container.isActive()) {
            this.container.close();
        }
        this.registry.removeContainer(this);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Container " + this.getContainer().getName() + " stopped");
        }
    }

    public String toString() {
        return this.deployer + ", " + super.toString();
    }
}

