/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mejb;

import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.ListenerRegistration;
import org.glassfish.admin.mejb.EventListenerProxy;
import org.glassfish.admin.mejb.MEJBUtility;
import org.glassfish.admin.mejb.RemoteListenerConnector;

public final class ListenerRegistry
implements ListenerRegistration {
    private static final boolean debug = true;
    private final Hashtable<NotificationListener, RemoteListenerConnector> listenerConnectors = new Hashtable();
    private final String serverAddress;

    private static void debug(String s) {
        System.out.println(s);
    }

    public ListenerRegistry(String ip) {
        this.serverAddress = ip;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws RemoteException {
        String proxyAddress = EventListenerProxy.getEventListenerProxy().getProxyAddress();
        try {
            ListenerRegistry.debug("ListenerRegistry:addNotificationListener() to " + name);
            RemoteListenerConnector connector = new RemoteListenerConnector(proxyAddress);
            this.getMEJBUtility().addNotificationListener(name, connector, filter, connector.getId());
            EventListenerProxy.getEventListenerProxy().addListener(connector.getId(), listener, handback);
            this.listenerConnectors.put(listener, connector);
        }
        catch (InstanceNotFoundException inf) {
            throw new RemoteException(inf.getMessage(), inf);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws RemoteException {
        EventListenerProxy proxy = EventListenerProxy.getEventListenerProxy();
        try {
            ListenerRegistry.debug("ListenerRegistry.removeNotificationListener: " + listener + " for " + name);
            RemoteListenerConnector connector = this.listenerConnectors.get(listener);
            this.getMEJBUtility().removeNotificationListener(name, connector);
            proxy.removeListener(connector.getId());
            this.listenerConnectors.remove(listener);
        }
        catch (InstanceNotFoundException inf) {
            throw new RemoteException(inf.getMessage(), inf);
        }
        catch (ListenerNotFoundException lnf) {
            throw new RemoteException(lnf.getMessage(), lnf);
        }
    }

    private MEJBUtility getMEJBUtility() {
        return MEJBUtility.getInstance();
    }
}

