/*
 * Copyright (c) 2009, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.embeddable;

/**
 * GlassFish has a very sophisticated command line interface (CLI) viz.,
 * 'asadmin' to executive administrative commands.
 *
 * <p/>This is a programmatic interface equivalent to 'asadmin'.
 *
 * <p/>This interface allows the execution of the adminstrative commands
 * from an application which embeds GlassFish.
 *
 * <p/>A command runner is obtained by calling
 * {@link org.glassfish.embeddable.GlassFish#getCommandRunner()}.
 *
 * <p/>A command runner is a per-lookup type object, which means each time
 * {@link GlassFish#getCommandRunner()} is called, it returns a new instance of command runner.
 *
 * Command specific options are passed in the var-args argument of {@link #run(String, String...)} method.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public interface CommandRunner {

    /**
     * Execute an administrative command in {@link GlassFish} using the supplied
     * command arguments. Refer to GlassFish Administration Guide to know about the commands supported
     * in GlassFish and their usage.
     *
     * <p/>Example: To add an additional http listener 9090 :
     *
     * <pre>
     *      commandRunner.run("create-http-listener", "--listenerport", "9090",
     *                                       "--listeneraddress", "0.0.0.0",
     *                                       "--defaultvs", "server",
     *                                       "--securityenabled", "false",
     *                                       "listener_id", "my-http-listener-1");
     *
     * </pre>
     * asadmin commands also allow option values to be specified using '=', so the above example can be written as:
     *
     * <pre>
     *      commandRunner.run("create-http-listener", "--listenerport=9090",
     *                                       "--listeneraddress=0.0.0.0",
     *                                       "--defaultvs=server",
     *                                       "--securityenabled=false",
     *                                       "listener_id=my-http-listener-1");
     *
     * </pre>
     * @param command command to be executed.
     * @param args command arguments.
     * @return {@link CommandResult} which encapsulates exit status, command output, failure cause (if any).
     */
    CommandResult run(String command, String... args);

    /**
     * Set the terse level.
     * If true, output data is very concise  and  in  a  format that  is  optimized  for  use  in programs
     * instead of for reading  by  humans. Typically,  descriptive  text  and detailed  status messages are
     * also omitted from the output data. Default is true.
     *
     * @param terse true to get concise output, false otherwise.
     */
    void setTerse(boolean terse);
}
