/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.concurrent.runtime.ContextSetupProviderImpl;
import org.glassfish.concurrent.runtime.TransactionSetupProviderImpl;
import org.glassfish.concurrent.runtime.deployer.ContextServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedExecutorServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedScheduledExecutorServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedThreadFactoryConfig;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ConcurrentRuntime
implements PostConstruct,
PreDestroy {
    private static ConcurrentRuntime _runtime;
    private Map<String, ManagedExecutorServiceImpl> managedExecutorServiceMap;
    private Map<String, ManagedScheduledExecutorServiceImpl> managedScheduledExecutorServiceMap;
    private Map<String, ContextServiceImpl> contextServiceMap;
    private Map<String, ManagedThreadFactoryImpl> managedThreadFactoryMap;
    public static final String CONTEXT_INFO_CLASSLOADER = "Classloader";
    public static final String CONTEXT_INFO_JNDI = "JNDI";
    public static final String CONTEXT_INFO_SECURITY = "Security";
    public static final String CONTEXT_INFO_WORKAREA = "WorkArea";
    private ScheduledExecutorService internalScheduler;
    private static final Logger logger;
    @Inject
    InvocationManager invocationManager;
    @Inject
    Deployment deployment;
    @Inject
    Applications applications;
    @Inject
    JavaEETransactionManager transactionManager;
    @Inject
    ApplicationRegistry applicationRegistry;

    public static ConcurrentRuntime getRuntime() {
        if (_runtime == null) {
            throw new RuntimeException("ConcurrentRuntime not initialized");
        }
        return _runtime;
    }

    private static void setRuntime(ConcurrentRuntime runtime) {
        _runtime = runtime;
    }

    ConcurrentRuntime() {
        ConcurrentRuntime.setRuntime(this);
    }

    InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    Deployment getDeployment() {
        return this.deployment;
    }

    Applications getApplications() {
        return this.applications;
    }

    JavaEETransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    ApplicationRegistry getApplicationRegistry() {
        return this.applicationRegistry;
    }

    public synchronized ContextServiceImpl getContextService(ResourceInfo resource, ContextServiceConfig config) {
        String jndiName = config.getJndiName();
        if (this.contextServiceMap != null && this.contextServiceMap.containsKey(jndiName)) {
            return this.contextServiceMap.get(jndiName);
        }
        ContextServiceImpl contextService = this.createContextService(config.getJndiName(), config.getContextInfo(), config.getContextInfoEnabled(), false);
        if (this.contextServiceMap == null) {
            this.contextServiceMap = new HashMap<String, ContextServiceImpl>();
        }
        this.contextServiceMap.put(jndiName, contextService);
        return contextService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownContextService(String jndiName) {
        ConcurrentRuntime concurrentRuntime = this;
        synchronized (concurrentRuntime) {
            if (this.contextServiceMap != null) {
                this.contextServiceMap.remove(jndiName);
            }
        }
    }

    public synchronized ManagedExecutorServiceImpl getManagedExecutorService(ResourceInfo resource, ManagedExecutorServiceConfig config) {
        String jndiName = config.getJndiName();
        if (this.managedExecutorServiceMap != null && this.managedExecutorServiceMap.containsKey(jndiName)) {
            return this.managedExecutorServiceMap.get(jndiName);
        }
        ManagedThreadFactoryImpl managedThreadFactory = new ManagedThreadFactoryImpl(config.getJndiName() + "-managedThreadFactory", null, config.getThreadPriority());
        ManagedExecutorServiceImpl mes = new ManagedExecutorServiceImpl(config.getJndiName(), managedThreadFactory, (long)config.getHungAfterSeconds() * 1000L, config.isLongRunningTasks(), config.getCorePoolSize(), config.getMaximumPoolSize(), config.getKeepAliveSeconds(), TimeUnit.SECONDS, config.getThreadLifeTimeSeconds(), config.getTaskQueueCapacity(), this.createContextService(config.getJndiName() + "-contextservice", config.getContextInfo(), config.getContextInfoEnabled(), true), AbstractManagedExecutorService.RejectPolicy.ABORT);
        if (this.managedExecutorServiceMap == null) {
            this.managedExecutorServiceMap = new HashMap<String, ManagedExecutorServiceImpl>();
        }
        this.managedExecutorServiceMap.put(jndiName, mes);
        if ((long)config.getHungAfterSeconds() > 0L && !config.isLongRunningTasks()) {
            this.scheduleInternalTimer(config.getHungLoggerInitialDelaySeconds(), config.getHungLoggerIntervalSeconds());
        }
        return mes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownManagedExecutorService(String jndiName) {
        ManagedExecutorServiceImpl mes = null;
        ConcurrentRuntime concurrentRuntime = this;
        synchronized (concurrentRuntime) {
            if (this.managedExecutorServiceMap != null) {
                mes = this.managedExecutorServiceMap.remove(jndiName);
            }
        }
        if (mes != null) {
            mes.shutdownNow();
        }
    }

    public synchronized ManagedScheduledExecutorServiceImpl getManagedScheduledExecutorService(ResourceInfo resource, ManagedScheduledExecutorServiceConfig config) {
        String jndiName = config.getJndiName();
        if (this.managedScheduledExecutorServiceMap != null && this.managedScheduledExecutorServiceMap.containsKey(jndiName)) {
            return this.managedScheduledExecutorServiceMap.get(jndiName);
        }
        ManagedThreadFactoryImpl managedThreadFactory = new ManagedThreadFactoryImpl(config.getJndiName() + "-managedThreadFactory", null, config.getThreadPriority());
        ManagedScheduledExecutorServiceImpl mes = new ManagedScheduledExecutorServiceImpl(config.getJndiName(), managedThreadFactory, (long)config.getHungAfterSeconds() * 1000L, config.isLongRunningTasks(), config.getCorePoolSize(), config.getKeepAliveSeconds(), TimeUnit.SECONDS, config.getThreadLifeTimeSeconds(), this.createContextService(config.getJndiName() + "-contextservice", config.getContextInfo(), config.getContextInfoEnabled(), true), AbstractManagedExecutorService.RejectPolicy.ABORT);
        if (this.managedScheduledExecutorServiceMap == null) {
            this.managedScheduledExecutorServiceMap = new HashMap<String, ManagedScheduledExecutorServiceImpl>();
        }
        this.managedScheduledExecutorServiceMap.put(jndiName, mes);
        if ((long)config.getHungAfterSeconds() > 0L && !config.isLongRunningTasks()) {
            this.scheduleInternalTimer(config.getHungLoggerInitialDelaySeconds(), config.getHungLoggerIntervalSeconds());
        }
        return mes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownScheduledManagedExecutorService(String jndiName) {
        ManagedScheduledExecutorServiceImpl mses = null;
        ConcurrentRuntime concurrentRuntime = this;
        synchronized (concurrentRuntime) {
            if (this.managedScheduledExecutorServiceMap != null) {
                mses = this.managedScheduledExecutorServiceMap.remove(jndiName);
            }
        }
        if (mses != null) {
            mses.shutdownNow();
        }
    }

    public synchronized ManagedThreadFactoryImpl getManagedThreadFactory(ResourceInfo resource, ManagedThreadFactoryConfig config) {
        String jndiName = config.getJndiName();
        if (this.managedThreadFactoryMap != null && this.managedThreadFactoryMap.containsKey(jndiName)) {
            return this.managedThreadFactoryMap.get(jndiName);
        }
        ManagedThreadFactoryImpl managedThreadFactory = new ManagedThreadFactoryImpl(config.getJndiName(), this.createContextService(config.getJndiName() + "-contextservice", config.getContextInfo(), config.getContextInfoEnabled(), true), config.getThreadPriority());
        if (this.managedThreadFactoryMap == null) {
            this.managedThreadFactoryMap = new HashMap<String, ManagedThreadFactoryImpl>();
        }
        this.managedThreadFactoryMap.put(jndiName, managedThreadFactory);
        return managedThreadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownManagedThreadFactory(String jndiName) {
        ManagedThreadFactoryImpl mtf = null;
        ConcurrentRuntime concurrentRuntime = this;
        synchronized (concurrentRuntime) {
            if (this.managedThreadFactoryMap != null) {
                mtf = this.managedThreadFactoryMap.remove(jndiName);
            }
        }
        if (mtf != null) {
            mtf.stop();
        }
    }

    private ContextServiceImpl createContextService(String jndiName, String contextInfo, String contextInfoEnabled, boolean cleanupTransaction) {
        boolean isContextInfoEnabled = Boolean.valueOf(contextInfoEnabled);
        ContextSetupProviderImpl.CONTEXT_TYPE[] contextTypes = this.parseContextInfo(contextInfo, isContextInfoEnabled);
        ContextSetupProviderImpl contextSetupProvider = new ContextSetupProviderImpl(this.invocationManager, this.deployment, this.applications, cleanupTransaction ? this.transactionManager : null, contextTypes);
        ContextServiceImpl obj = new ContextServiceImpl(jndiName, (ContextSetupProvider)contextSetupProvider, (TransactionSetupProvider)new TransactionSetupProviderImpl(this.transactionManager));
        return obj;
    }

    private ContextSetupProviderImpl.CONTEXT_TYPE[] parseContextInfo(String contextInfo, boolean isContextInfoEnabled) {
        ArrayList<ContextSetupProviderImpl.CONTEXT_TYPE> contextTypeArray = new ArrayList<ContextSetupProviderImpl.CONTEXT_TYPE>();
        ContextSetupProviderImpl.CONTEXT_TYPE[] contextTypes = new ContextSetupProviderImpl.CONTEXT_TYPE[]{};
        if (contextInfo == null) {
            contextTypeArray.add(ContextSetupProviderImpl.CONTEXT_TYPE.CLASSLOADING);
            contextTypeArray.add(ContextSetupProviderImpl.CONTEXT_TYPE.NAMING);
            contextTypeArray.add(ContextSetupProviderImpl.CONTEXT_TYPE.SECURITY);
            contextTypeArray.add(ContextSetupProviderImpl.CONTEXT_TYPE.WORKAREA);
            return contextTypeArray.toArray(contextTypes);
        }
        if (isContextInfoEnabled) {
            StringTokenizer st = new StringTokenizer(contextInfo, ",", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (CONTEXT_INFO_CLASSLOADER.equalsIgnoreCase(token)) {
                    contextTypeArray.add(ContextSetupProviderImpl.CONTEXT_TYPE.CLASSLOADING);
                    continue;
                }
                if (CONTEXT_INFO_JNDI.equalsIgnoreCase(token)) {
                    contextTypeArray.add(ContextSetupProviderImpl.CONTEXT_TYPE.NAMING);
                    continue;
                }
                if (CONTEXT_INFO_SECURITY.equalsIgnoreCase(token)) {
                    contextTypeArray.add(ContextSetupProviderImpl.CONTEXT_TYPE.SECURITY);
                    continue;
                }
                if (!CONTEXT_INFO_WORKAREA.equalsIgnoreCase(token)) continue;
                contextTypeArray.add(ContextSetupProviderImpl.CONTEXT_TYPE.WORKAREA);
            }
        }
        return contextTypeArray.toArray(contextTypes);
    }

    private void scheduleInternalTimer(long initialDelay, long interval) {
        if (this.internalScheduler == null) {
            String name = "glassfish-internal";
            ManagedThreadFactoryImpl managedThreadFactory = new ManagedThreadFactoryImpl(name + "-managedThreadFactory", null, 5);
            this.internalScheduler = new ManagedScheduledExecutorServiceImpl(name, managedThreadFactory, 0L, false, 1, 60L, TimeUnit.SECONDS, 0L, this.createContextService(name + "-contextservice", CONTEXT_INFO_CLASSLOADER, "true", false), AbstractManagedExecutorService.RejectPolicy.ABORT);
            this.internalScheduler.scheduleAtFixedRate(new HungTasksLogger(), initialDelay, interval, TimeUnit.SECONDS);
        }
    }

    public void postConstruct() {
    }

    public void preDestroy() {
    }

    static {
        logger = LogFacade.getLogger();
    }

    class HungTasksLogger
    implements Runnable {
        HungTasksLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection hungThreads;
            ArrayList<ManagedExecutorServiceImpl> executorServices = new ArrayList<ManagedExecutorServiceImpl>();
            ArrayList<ManagedScheduledExecutorServiceImpl> scheduledExecutorServices = new ArrayList<ManagedScheduledExecutorServiceImpl>();
            Iterator iterator = ConcurrentRuntime.this;
            synchronized (iterator) {
                if (ConcurrentRuntime.this.managedExecutorServiceMap != null) {
                    Collection<ManagedExecutorServiceImpl> mesColl = ConcurrentRuntime.this.managedExecutorServiceMap.values();
                    executorServices.addAll(mesColl);
                }
            }
            iterator = ConcurrentRuntime.this;
            synchronized (iterator) {
                if (ConcurrentRuntime.this.managedScheduledExecutorServiceMap != null) {
                    Collection<ManagedScheduledExecutorServiceImpl> msesColl = ConcurrentRuntime.this.managedScheduledExecutorServiceMap.values();
                    scheduledExecutorServices.addAll(msesColl);
                }
            }
            for (ManagedExecutorServiceImpl mes : executorServices) {
                hungThreads = mes.getHungThreads();
                this.logHungThreads(hungThreads, mes.getManagedThreadFactory(), mes.getName());
            }
            for (ManagedScheduledExecutorServiceImpl mses : scheduledExecutorServices) {
                hungThreads = mses.getHungThreads();
                this.logHungThreads(hungThreads, mses.getManagedThreadFactory(), mses.getName());
            }
        }

        private void logHungThreads(Collection<AbstractManagedThread> hungThreads, ManagedThreadFactoryImpl mtf, String mesName) {
            if (hungThreads != null) {
                for (AbstractManagedThread hungThread : hungThreads) {
                    Object[] params = new Object[]{hungThread.getTaskIdentityName(), hungThread.getName(), hungThread.getTaskRunTime(System.currentTimeMillis()) / 1000L, mtf.getHungTaskThreshold() / 1000L, mesName};
                    logger.log(Level.WARNING, "AS-CONCURRENT-00001", params);
                }
            }
        }
    }
}

