/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer.cfg;

import com.sun.enterprise.deployment.annotation.handlers.ContextServiceDefinitionData;
import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.concurrent.config.ContextService;
import org.glassfish.concurrent.runtime.deployer.cfg.CfgParser;
import org.glassfish.concurrent.runtime.deployer.cfg.ConcurrentServiceCfg;

public class ContextServiceCfg
implements Serializable {
    private static final long serialVersionUID = -2284599070400343119L;
    private final ConcurrentServiceCfg serviceConfig;
    private final Set<ConcurrencyContextType> propagatedContexts;
    private final Set<ConcurrencyContextType> clearedContexts;
    private final Set<ConcurrencyContextType> unchangedContexts;

    public ContextServiceCfg(ContextServiceDefinitionData data) {
        this.serviceConfig = new ConcurrentServiceCfg(data.getName());
        this.propagatedContexts = CfgParser.standardize(data.getPropagated());
        this.clearedContexts = CfgParser.standardize(data.getCleared());
        this.unchangedContexts = CfgParser.standardize(data.getUnchanged());
    }

    public ContextServiceCfg(ContextService config) {
        this.propagatedContexts = CfgParser.parseContextInfo(config.getContextInfo(), config.getContextInfoEnabled());
        this.serviceConfig = new ConcurrentServiceCfg(config.getJndiName(), this.propagatedContexts);
        this.clearedContexts = new HashSet<ConcurrencyContextType>();
        this.unchangedContexts = new HashSet<ConcurrencyContextType>();
    }

    public ConcurrentServiceCfg getServiceConfig() {
        return this.serviceConfig;
    }

    public Set<ConcurrencyContextType> getPropagatedContexts() {
        return this.propagatedContexts;
    }

    public Set<ConcurrencyContextType> getClearedContexts() {
        return this.clearedContexts;
    }

    public Set<ConcurrencyContextType> getUnchangedContexts() {
        return this.unchangedContexts;
    }

    public String toString() {
        return super.toString() + "[serviceConfig=" + this.serviceConfig + "]";
    }
}

