/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.concurrent.config.ManagedThreadFactory;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="managed-thread-factory")
@I18n(value="managed.thread.factory.manager")
@ConfiguredBy(value=Resources.class)
public class ManagedThreadFactoryManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ManagedThreadFactoryManager.class);
    private static final String DESCRIPTION = "description";
    private String jndiName = null;
    private String description = null;
    private String threadPriority = "5";
    private String virtual = Boolean.FALSE.toString();
    private String contextInfoEnabled = Boolean.TRUE.toString();
    private String contextInfo = "Classloader,JNDI,Security,WorkArea";
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private BindableResourcesHelper resourcesHelper;

    public String getResourceType() {
        return "managed-thread-factory";
    }

    public ResourceStatus create(Resources resources, HashMap attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            SingleConfigCode configCode = param -> this.createResource((Resources)param, properties);
            ConfigSupport.apply((SingleConfigCode)configCode, (ConfigBeanProxy)resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.managed.thread.factory.failed", "Managed thread factory {0} creation failed", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("create.managed.thread.factory.success", "Managed thread factory {0} created successfully", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.jndiName == null) {
            String msg = localStrings.getLocalString("managed.thread.factory.noJndiName", "No JNDI name defined for managed thread factory.");
            return new ResourceStatus(1, msg);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, ManagedThreadFactory.class);
        return status;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get(DESCRIPTION);
        this.contextInfoEnabled = (String)attributes.get("context-info-enabled");
        this.contextInfo = (String)attributes.get("context-info");
        this.threadPriority = (String)attributes.get("thread-priority");
        this.virtual = (String)attributes.get("use-virtual-threads");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
    }

    private ManagedThreadFactory createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ManagedThreadFactory newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private ManagedThreadFactory createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ManagedThreadFactory managedThreadFactory = (ManagedThreadFactory)param.createChild(ManagedThreadFactory.class);
        managedThreadFactory.setJndiName(this.jndiName);
        if (this.description != null) {
            managedThreadFactory.setDescription(this.description);
        }
        managedThreadFactory.setContextInfoEnabled(this.contextInfoEnabled);
        managedThreadFactory.setContextInfo(this.contextInfo);
        managedThreadFactory.setThreadPriority(this.threadPriority);
        managedThreadFactory.setUseVirtualThreads(this.virtual);
        managedThreadFactory.setEnabled(this.enabled);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)managedThreadFactory.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                managedThreadFactory.getProperty().add(prop);
            }
        }
        return managedThreadFactory;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }

    public ResourceStatus delete(Resources resources, SimpleJndiName jndiName, String target) throws Exception {
        if (jndiName == null) {
            String msg = localStrings.getLocalString("managed.thread.factory.noJndiName", "No JNDI name defined for managed thread factory.");
            return new ResourceStatus(1, msg);
        }
        Resource resource = resources.getResourceByName(ManagedThreadFactory.class, jndiName);
        if (resource == null) {
            String msg = localStrings.getLocalString("delete.managed.thread.factory.notfound", "A managed thread factory named {0} does not exist.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        if ("system-all-req".equals(resource.getObjectType())) {
            String msg = localStrings.getLocalString("delete.concurrent.resource.notAllowed", "The {0} resource cannot be deleted as it is required to be configured in the system.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        if (this.environment.isDas()) {
            if ("domain".equals(target)) {
                if (!this.resourceUtil.getTargetsReferringResourceRef(jndiName).isEmpty()) {
                    String msg = localStrings.getLocalString("delete.managed.thread.factory.resource-ref.exist", "This managed thread factory [ {0} ] is referenced in an instance/cluster target, use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    return new ResourceStatus(1, msg);
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(jndiName, target)) {
                    String msg = localStrings.getLocalString("delete.managed.thread.factory.no.resource-ref", "This managed thread factory [ {0} ] is not referenced in target [ {1} ]", new Object[]{jndiName, target});
                    return new ResourceStatus(1, msg);
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(jndiName).size() > 1) {
                    String msg = localStrings.getLocalString("delete.managed.thread.factory.multiple.resource-refs", "This managed thread factory [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    return new ResourceStatus(1, msg);
                }
            }
        }
        try {
            if (!"domain".equals(target)) {
                this.resourceUtil.deleteResourceRef(jndiName, target);
            }
            if (ConfigSupport.apply(param -> param.getResources().remove(resource), (ConfigBeanProxy)resources) == null) {
                String msg = localStrings.getLocalString("delete.managed.thread.factory.failed", "Managed thread factory {0} deletion failed", new Object[]{jndiName});
                return new ResourceStatus(1, msg);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("delete.managed.thread.factory.failed", "Managed thread factory {0} deletion failed ", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("delete.managed.thread.factory.success", "Managed thread factory {0} deleted successfully", new Object[]{jndiName});
        return new ResourceStatus(0, msg);
    }
}

