/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deployment.annotation.handlers.ContextualResourceDefinition;
import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import com.sun.enterprise.deployment.types.StandardContextType;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.concurrent.runtime.ContextSetupProviderImpl;
import org.glassfish.concurrent.runtime.LogFacade;
import org.glassfish.concurrent.runtime.TransactionSetupProviderImpl;
import org.glassfish.concurrent.runtime.deployer.cfg.ConcurrentServiceCfg;
import org.glassfish.concurrent.runtime.deployer.cfg.ContextServiceCfg;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedExecutorServiceCfg;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedScheduledExecutorServiceCfg;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedThreadFactoryCfg;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.AbstractManagedThread;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedExecutorServiceImpl;
import org.glassfish.concurro.ManagedScheduledExecutorServiceImpl;
import org.glassfish.concurro.ManagedThreadFactoryImpl;
import org.glassfish.concurro.spi.ContextHandle;
import org.glassfish.concurro.spi.ContextSetupProvider;
import org.glassfish.concurro.spi.TransactionSetupProvider;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ConcurrentRuntime {
    private static final Logger LOG = LogFacade.getLogger();
    private static ConcurrentRuntime singletonInstance;
    private final Map<SimpleJndiName, ManagedExecutorServiceImpl> managedExecutorServiceMap = new HashMap<SimpleJndiName, ManagedExecutorServiceImpl>();
    private final Map<SimpleJndiName, ManagedScheduledExecutorServiceImpl> managedScheduledExecutorServiceMap = new HashMap<SimpleJndiName, ManagedScheduledExecutorServiceImpl>();
    private final Map<SimpleJndiName, ContextServiceImpl> contextServiceMap = new HashMap<SimpleJndiName, ContextServiceImpl>();
    private final Map<SimpleJndiName, ManagedThreadFactoryImpl> managedThreadFactoryMap = new HashMap<SimpleJndiName, ManagedThreadFactoryImpl>();
    private ScheduledExecutorService internalScheduler;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private Deployment deployment;
    @Inject
    private Applications applications;
    @Inject
    private JavaEETransactionManager transactionManager;
    @Inject
    private ApplicationRegistry applicationRegistry;
    @Inject
    private ResourceNamingService resourceNamingService;

    public static ConcurrentRuntime getRuntime() {
        if (singletonInstance == null) {
            throw new RuntimeException("ConcurrentRuntime not initialized");
        }
        return singletonInstance;
    }

    ConcurrentRuntime() {
        singletonInstance = this;
    }

    InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    Deployment getDeployment() {
        return this.deployment;
    }

    Applications getApplications() {
        return this.applications;
    }

    JavaEETransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    ApplicationRegistry getApplicationRegistry() {
        return this.applicationRegistry;
    }

    public synchronized ManagedExecutorServiceImpl getManagedExecutorService(ManagedExecutorServiceCfg config) {
        LOG.log(Level.FINEST, "getManagedExecutorService(config={0})", config);
        SimpleJndiName jndiName = config.getServiceConfig().getJndiName();
        if (this.managedExecutorServiceMap != null && this.managedExecutorServiceMap.containsKey(jndiName)) {
            return this.managedExecutorServiceMap.get(jndiName);
        }
        ContextServiceImpl contextService = this.getContextService(config.getServiceConfig(), true);
        ManagedExecutorServiceImpl mes = this.createManagedExecutorService(config, contextService);
        this.managedExecutorServiceMap.put(jndiName, mes);
        return mes;
    }

    public synchronized ManagedExecutorServiceImpl createManagedExecutorService(ManagedExecutorServiceCfg config, ContextServiceImpl contextService) {
        LOG.log(Level.FINE, "createManagedExecutorService(config={0}, contextService={1})", new Object[]{config, contextService});
        SimpleJndiName jndiName = config.getServiceConfig().getJndiName();
        GlassFishManagedThreadFactory managedThreadFactory = new GlassFishManagedThreadFactory(ConcurrentRuntime.toManagedThreadFactoryName(jndiName), null, config.getThreadPriority());
        ManagedExecutorServiceImpl mes = new ManagedExecutorServiceImpl(jndiName.toString(), (ManagedThreadFactoryImpl)managedThreadFactory, (long)config.getHungAfterSeconds() * 1000L, config.isLongRunningTasks(), config.getCorePoolSize(), config.getMaximumPoolSize(), config.getKeepAliveSeconds(), TimeUnit.SECONDS, config.getThreadLifeTimeSeconds(), config.getTaskQueueCapacity(), contextService, AbstractManagedExecutorService.RejectPolicy.ABORT);
        if ((long)config.getHungAfterSeconds() > 0L && !config.isLongRunningTasks()) {
            this.scheduleInternalTimer(config.getHungLoggerInitialDelaySeconds(), config.getHungLoggerIntervalSeconds(), config.isHungLoggerPrintOnce());
        }
        return mes;
    }

    public synchronized ManagedScheduledExecutorServiceImpl getManagedScheduledExecutorService(ManagedScheduledExecutorServiceCfg config) {
        LOG.log(Level.FINE, "getManagedScheduledExecutorService(config={0})", config);
        SimpleJndiName jndiName = config.getServiceConfig().getJndiName();
        if (this.managedScheduledExecutorServiceMap != null && this.managedScheduledExecutorServiceMap.containsKey(jndiName)) {
            return this.managedScheduledExecutorServiceMap.get(jndiName);
        }
        ContextServiceImpl contextService = this.getContextService(config.getServiceConfig(), true);
        ManagedScheduledExecutorServiceImpl mes = this.createManagedScheduledExecutorService(config, contextService);
        this.managedScheduledExecutorServiceMap.put(jndiName, mes);
        if ((long)config.getHungAfterSeconds() > 0L && !config.isLongRunningTasks()) {
            this.scheduleInternalTimer(config.getHungLoggerInitialDelaySeconds(), config.getHungLoggerIntervalSeconds(), config.isHungLoggerPrintOnce());
        }
        return mes;
    }

    public ManagedScheduledExecutorServiceImpl createManagedScheduledExecutorService(ManagedScheduledExecutorServiceCfg config, ContextServiceImpl contextService) {
        SimpleJndiName jndiName = config.getServiceConfig().getJndiName();
        GlassFishManagedThreadFactory managedThreadFactory = new GlassFishManagedThreadFactory(ConcurrentRuntime.toManagedThreadFactoryName(jndiName), null, config.getThreadPriority());
        ManagedScheduledExecutorServiceImpl mes = new ManagedScheduledExecutorServiceImpl(jndiName.toString(), (ManagedThreadFactoryImpl)managedThreadFactory, (long)config.getHungAfterSeconds() * 1000L, config.isLongRunningTasks(), config.getCorePoolSize(), config.getKeepAliveSeconds(), TimeUnit.SECONDS, config.getThreadLifeTimeSeconds(), contextService, AbstractManagedExecutorService.RejectPolicy.ABORT);
        return mes;
    }

    public synchronized ManagedThreadFactoryImpl getManagedThreadFactory(ManagedThreadFactoryCfg config) {
        LOG.log(Level.FINE, "getManagedThreadFactory(config={0})", config);
        SimpleJndiName jndiName = config.getServiceConfig().getJndiName();
        if (this.managedThreadFactoryMap != null && this.managedThreadFactoryMap.containsKey(jndiName)) {
            return this.managedThreadFactoryMap.get(jndiName);
        }
        ContextServiceImpl contextService = this.getContextService(config.getServiceConfig(), true);
        GlassFishManagedThreadFactory managedThreadFactory = this.createManagedThreadFactory(config, contextService);
        this.managedThreadFactoryMap.put(jndiName, managedThreadFactory);
        return managedThreadFactory;
    }

    public GlassFishManagedThreadFactory createManagedThreadFactory(ManagedThreadFactoryCfg config, ContextServiceImpl contextService) {
        SimpleJndiName jndiName = config.getServiceConfig().getJndiName();
        return new GlassFishManagedThreadFactory(jndiName, contextService, config.getThreadPriority());
    }

    public ContextServiceImpl findOrCreateContextService(ContextualResourceDefinition definition, String applicationName, String moduleName) {
        SimpleJndiName jndiName = ConcurrentRuntime.toContextServiceName(definition.getContext(), definition.getJndiName());
        LOG.log(Level.FINEST, "findOrCreateContextService(jndiName={0}, applicationName={1}, moduleName={2})", new Object[]{definition, applicationName, moduleName});
        ResourceInfo contextResourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        ContextServiceImpl lookup1 = this.lookup((GenericResourceInfo)contextResourceInfo, jndiName);
        if (lookup1 != null) {
            return lookup1;
        }
        ContextServiceImpl lookup2 = this.lookup(definition.getContext());
        if (lookup2 != null) {
            return lookup2;
        }
        Set<StandardContextType> provided = Set.of(StandardContextType.Classloader, StandardContextType.JNDI, StandardContextType.Security, StandardContextType.WorkArea);
        ConcurrentServiceCfg config = new ConcurrentServiceCfg(jndiName, provided);
        return this.contextServiceMap.computeIfAbsent(jndiName, n -> this.createContextService(jndiName, config, true));
    }

    public synchronized ContextServiceImpl getContextService(ContextServiceCfg config) {
        return this.contextServiceMap.computeIfAbsent(config.getServiceConfig().getJndiName(), n -> this.createContextService(config));
    }

    public synchronized ContextServiceImpl createContextService(ContextServiceCfg config) {
        LOG.log(Level.FINE, "createContextService(config={0})", config);
        boolean keepTxUnchanged = config.getUnchangedContexts().contains(StandardContextType.WorkArea);
        boolean clearTx = config.getClearedContexts().contains(StandardContextType.WorkArea);
        TransactionSetupProvider txSetupProvider = this.createTxSetupProvider(keepTxUnchanged, clearTx);
        ContextSetupProviderImpl ctxSetupProvider = new ContextSetupProviderImpl(config.getPropagatedContexts(), config.getClearedContexts(), config.getUnchangedContexts());
        SimpleJndiName jndiName = config.getServiceConfig().getJndiName();
        return new ContextServiceImpl(jndiName.toString(), (ContextSetupProvider)ctxSetupProvider, txSetupProvider);
    }

    public synchronized ContextServiceImpl getContextService(ConcurrentServiceCfg config, boolean cleanupTransaction) {
        SimpleJndiName contextServiceJndiName = ConcurrentRuntime.toContextServiceName(config.getContext(), config.getJndiName());
        return this.contextServiceMap.computeIfAbsent(contextServiceJndiName, n -> this.createContextService(contextServiceJndiName, config, cleanupTransaction));
    }

    public void shutdownManagedExecutorService(SimpleJndiName jndiName) {
        ManagedExecutorServiceImpl mes = this.removeManagedExecutorService(jndiName);
        if (mes != null) {
            mes.shutdownNow();
        }
    }

    public void shutdownScheduledManagedExecutorService(SimpleJndiName jndiName) {
        ManagedScheduledExecutorServiceImpl mses = this.removeManagedScheduledExecutorService(jndiName);
        if (mses != null) {
            mses.shutdownNow();
        }
    }

    public void shutdownManagedThreadFactory(SimpleJndiName jndiName) {
        ManagedThreadFactoryImpl mtf = this.removeManagedThreadFactory(jndiName);
        if (mtf != null) {
            mtf.stop();
        }
    }

    public synchronized void shutdownContextService(SimpleJndiName jndiName) {
        this.contextServiceMap.remove(jndiName);
    }

    private ContextServiceImpl createContextService(SimpleJndiName contextServiceJndiName, ConcurrentServiceCfg config, boolean cleanupTransaction) {
        boolean clearTx;
        Set<ConcurrencyContextType> cleared;
        LOG.log(Level.FINE, "createContextService(contextServiceJndiName={0}, config={1}, cleanupTransaction={2})", new Object[]{contextServiceJndiName, config, cleanupTransaction});
        Set<ConcurrencyContextType> propagated = config.getContextInfo();
        if (cleanupTransaction && !propagated.contains(StandardContextType.WorkArea)) {
            cleared = Set.of(StandardContextType.WorkArea);
            clearTx = true;
        } else {
            cleared = Collections.emptySet();
            clearTx = false;
        }
        TransactionSetupProvider txSetupProvider = this.createTxSetupProvider(false, clearTx);
        ContextSetupProviderImpl ctxSetupProvider = new ContextSetupProviderImpl(propagated, cleared, Collections.emptySet());
        return new ContextServiceImpl(contextServiceJndiName.toString(), (ContextSetupProvider)ctxSetupProvider, txSetupProvider);
    }

    private void scheduleInternalTimer(long initialDelay, long interval, boolean logOnce) {
        if (this.internalScheduler != null) {
            return;
        }
        SimpleJndiName name = new SimpleJndiName("Glassfish-Internal");
        GlassFishManagedThreadFactory managedThreadFactory = new GlassFishManagedThreadFactory(ConcurrentRuntime.toManagedThreadFactoryName(name), null, 5);
        ConcurrentServiceCfg config = new ConcurrentServiceCfg(ConcurrentRuntime.toContextServiceName(name), StandardContextType.Classloader, null);
        ContextServiceImpl contextService = this.getContextService(config, false);
        this.internalScheduler = new ManagedScheduledExecutorServiceImpl(name.toString(), (ManagedThreadFactoryImpl)managedThreadFactory, 0L, false, 1, 60L, TimeUnit.SECONDS, 0L, contextService, AbstractManagedExecutorService.RejectPolicy.ABORT);
        this.internalScheduler.scheduleAtFixedRate(new HungTasksLogger(logOnce), initialDelay, interval, TimeUnit.SECONDS);
    }

    private TransactionSetupProvider createTxSetupProvider(boolean keepTransactionUnchanged, boolean clearTransaction) {
        return new TransactionSetupProviderImpl(this.transactionManager, keepTransactionUnchanged, clearTransaction);
    }

    private ContextServiceImpl lookup(GenericResourceInfo contextResourceInfo, SimpleJndiName jndiName) {
        try {
            return (ContextServiceImpl)this.resourceNamingService.lookup(contextResourceInfo, jndiName);
        }
        catch (NamingException e) {
            return null;
        }
    }

    private ContextServiceImpl lookup(String jndiName) {
        LOG.log(Level.FINEST, "lookup(jndiName={0})", jndiName);
        try {
            return (ContextServiceImpl)InitialContext.doLookup(jndiName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private synchronized ManagedExecutorServiceImpl removeManagedExecutorService(SimpleJndiName jndiName) {
        return this.managedExecutorServiceMap.remove(jndiName);
    }

    private synchronized ManagedScheduledExecutorServiceImpl removeManagedScheduledExecutorService(SimpleJndiName jndiName) {
        return this.managedScheduledExecutorServiceMap.remove(jndiName);
    }

    private synchronized ManagedThreadFactoryImpl removeManagedThreadFactory(SimpleJndiName jndiName) {
        return this.managedThreadFactoryMap.remove(jndiName);
    }

    private static SimpleJndiName toContextServiceName(String configuredContextJndiName, SimpleJndiName parentObjectJndiName) {
        return configuredContextJndiName == null ? ConcurrentRuntime.toContextServiceName(parentObjectJndiName) : new SimpleJndiName(configuredContextJndiName);
    }

    private static SimpleJndiName toContextServiceName(SimpleJndiName jndiName) {
        return new SimpleJndiName(jndiName + "-ContextService");
    }

    private static SimpleJndiName toManagedThreadFactoryName(SimpleJndiName jndiName) {
        return new SimpleJndiName(jndiName + "-ManagedThreadFactory");
    }

    private static class GlassFishManagedThreadFactory
    extends ManagedThreadFactoryImpl {
        private static final Logger LOG = Logger.getLogger(GlassFishManagedThreadFactory.class.getName());

        GlassFishManagedThreadFactory(SimpleJndiName name, ContextServiceImpl contextService, int threadPriority) {
            super(name.toString(), contextService, threadPriority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Thread createThread(Runnable runnable, ContextHandle contextHandleForSetup) {
            LOG.log(Level.FINE, "createThread(runnable={0}, contextHandleForSetup={1})", new Object[]{runnable, contextHandleForSetup});
            Thread thread = Thread.currentThread();
            ClassLoader originalCL = thread.getContextClassLoader();
            thread.setContextClassLoader(null);
            try {
                Thread thread2 = super.createThread(runnable, contextHandleForSetup);
                return thread2;
            }
            finally {
                thread.setContextClassLoader(originalCL);
            }
        }
    }

    class HungTasksLogger
    implements Runnable {
        private final Boolean logOnce;
        private final Map<String, Collection<Thread>> cachedHungThreadsMap = new HashMap<String, Collection<Thread>>();

        HungTasksLogger(Boolean logOnce) {
            this.logOnce = logOnce;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection hungThreads;
            ArrayList<ManagedExecutorServiceImpl> executorServices = new ArrayList<ManagedExecutorServiceImpl>();
            ArrayList<ManagedScheduledExecutorServiceImpl> scheduledExecutorServices = new ArrayList<ManagedScheduledExecutorServiceImpl>();
            Iterator iterator = ConcurrentRuntime.this;
            synchronized (iterator) {
                if (ConcurrentRuntime.this.managedExecutorServiceMap != null) {
                    Collection<ManagedExecutorServiceImpl> mesColl = ConcurrentRuntime.this.managedExecutorServiceMap.values();
                    executorServices.addAll(mesColl);
                }
            }
            iterator = ConcurrentRuntime.this;
            synchronized (iterator) {
                if (ConcurrentRuntime.this.managedScheduledExecutorServiceMap != null) {
                    Collection<ManagedScheduledExecutorServiceImpl> msesColl = ConcurrentRuntime.this.managedScheduledExecutorServiceMap.values();
                    scheduledExecutorServices.addAll(msesColl);
                }
            }
            for (ManagedExecutorServiceImpl mes : executorServices) {
                hungThreads = mes.getHungThreads();
                this.logHungThreads(hungThreads, mes.getManagedThreadFactory(), mes.getName());
            }
            for (ManagedScheduledExecutorServiceImpl mses : scheduledExecutorServices) {
                hungThreads = mses.getHungThreads();
                this.logHungThreads(hungThreads, mses.getManagedThreadFactory(), mses.getName());
            }
        }

        private void logHungThreads(Collection<Thread> hungThreads, ManagedThreadFactoryImpl mtf, String mesName) {
            if (!this.logOnce.booleanValue()) {
                this.logRawHungThreads(hungThreads, mtf, mesName);
                return;
            }
            if (hungThreads == null) {
                this.cachedHungThreadsMap.remove(mesName);
                return;
            }
            HashSet<Thread> targetHungThreads = new HashSet<Thread>();
            targetHungThreads.addAll(hungThreads);
            Collection<Thread> cachedHungThreads = this.cachedHungThreadsMap.get(mesName);
            if (cachedHungThreads != null) {
                targetHungThreads.removeAll(cachedHungThreads);
            }
            this.logRawHungThreads(targetHungThreads, mtf, mesName);
            this.cachedHungThreadsMap.put(mesName, hungThreads);
        }

        private void logRawHungThreads(Collection<Thread> hungThreads, ManagedThreadFactoryImpl mtf, String mesName) {
            if (hungThreads != null) {
                for (Thread hungThread : hungThreads) {
                    String taskIdentityName = "virtual";
                    long taskRunTime = 0L;
                    if (hungThread instanceof AbstractManagedThread) {
                        AbstractManagedThread managedThread = (AbstractManagedThread)hungThread;
                        taskIdentityName = managedThread.getTaskIdentityName();
                        taskRunTime = managedThread.getTaskRunTime(System.currentTimeMillis()) / 1000L;
                    }
                    Object[] params = new Object[]{taskIdentityName, hungThread.getName(), taskRunTime, mtf.getHungTaskThreshold() / 1000L, mesName};
                    LOG.log(Level.WARNING, "AS-CONCURRENT-00001", params);
                }
            }
        }
    }
}

