/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import java.beans.PropertyVetoException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.LegacyConfigurationUpgrade;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.WriteableView;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.tiger_types.Types;

@Service(name="set")
@ExecuteOn(value={RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@I18n(value="set")
public class SetCommand
extends V2DottedNameSupport
implements AdminCommand,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    ConfigSupport config;
    @Inject
    Target targetService;
    @Param(primary=true, multiple=true)
    String[] values;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetCommand.class);
    private HashMap<String, Integer> targetLevel = null;

    public void postConstruct() {
        this.targetLevel = new HashMap();
        this.targetLevel.put("applications", 0);
        this.targetLevel.put("system-applications", 0);
        this.targetLevel.put("resources", 0);
        this.targetLevel.put("configs", 3);
        this.targetLevel.put("clusters", 3);
        this.targetLevel.put("servers", 3);
        this.targetLevel.put("nodes", 3);
    }

    public void execute(AdminCommandContext context) {
        for (String value : this.values) {
            if (value.contains(".log-service")) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.logservice.command", "For setting log levels/attributes use set-log-levels/set-log-attributes command."));
                return;
            }
            if (this.set(context, value)) continue;
            return;
        }
    }

    private boolean set(AdminCommandContext context, String nameval) {
        Map<Object, Object> matchingNodes;
        String prefix;
        int i = nameval.indexOf(61);
        if (i < 0) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.namevalue", "Invalid name value pair {0}. Missing expected equal sign.", new Object[]{nameval}));
            return false;
        }
        String target = nameval.substring(0, i);
        String value = nameval.substring(i + 1);
        int lastDotIndex = SetCommand.trueLastIndexOf(target, '.');
        if (lastDotIndex == -1) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.attributename", "Invalid attribute name {0}", new Object[]{target}));
            return false;
        }
        String attrName = target.substring(lastDotIndex + 1).replace("\\.", ".");
        String pattern = target.substring(0, lastDotIndex);
        if (attrName.replace('_', '-').equals("jndi-name")) {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.reject.keychange", "Cannot change a primary key\nChange of {0}", new Object[]{target}));
            return false;
        }
        boolean isProperty = false;
        if ("property".equals(pattern.substring(SetCommand.trueLastIndexOf(pattern, '.') + 1))) {
            pattern = target.replaceAll("\\\\\\.", "\\.");
            isProperty = true;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, pattern);
        boolean lookAtSubNodes = true;
        if (parentNodes[0].relativeName.length() == 0 || parentNodes[0].relativeName.equals("domain")) {
            prefix = "";
            lookAtSubNodes = false;
        } else if (!pattern.startsWith(parentNodes[0].relativeName)) {
            prefix = pattern.substring(0, pattern.indexOf(parentNodes[0].relativeName));
            pattern = parentNodes[0].relativeName;
        } else {
            prefix = "";
            pattern = parentNodes[0].relativeName;
        }
        String targetName = prefix + pattern;
        boolean applyOverrideRules = false;
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        if (lookAtSubNodes) {
            for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
                dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
            }
            matchingNodes = this.getMatchingNodes(dottedNames, pattern);
            applyOverrideRules = true;
        } else {
            matchingNodes = new HashMap();
            for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
                matchingNodes.put(parentNode.node, pattern);
            }
        }
        if (matchingNodes.isEmpty() && (pattern = target.substring(0, SetCommand.trueLastIndexOf(target, '.'))).endsWith("property")) {
            pattern = pattern.substring(0, SetCommand.trueLastIndexOf(pattern, '.'));
            parentNodes = this.getAliasedParent(this.domain, pattern);
            pattern = parentNodes[0].relativeName;
            matchingNodes = this.getMatchingNodes(dottedNames, pattern);
            if (matchingNodes.isEmpty()) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
                return false;
            }
            Dom parentNode = null;
            for (Map.Entry<Object, Object> node : matchingNodes.entrySet()) {
                if (!((String)node.getValue()).equals(pattern)) continue;
                parentNode = (Dom)node.getKey();
            }
            if (parentNode == null) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
                return false;
            }
            if (value == null || value.length() == 0) {
                this.success(context, targetName, value);
                return true;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("value", value);
            attributes.put("name", attrName);
            try {
                ConfigSupport.createAndSet((ConfigBean)((ConfigBean)parentNode), Property.class, attributes);
                this.success(context, targetName, value);
                this.runLegacyChecks(context);
                return !this.targetService.isThisDAS() || this.replicateSetCommand(context, targetName, value);
            }
            catch (TransactionFailure transactionFailure) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                return false;
            }
        }
        HashMap changes = new HashMap();
        boolean setElementSuccess = false;
        boolean delPropertySuccess = false;
        boolean delProperty = false;
        HashMap<String, String> attrChanges = new HashMap<String, String>();
        if (isProperty) {
            attrName = "value";
            if (value == null || value.length() == 0) {
                delProperty = true;
            }
            attrChanges.put(attrName, value);
        }
        List<Map.Entry> mNodes = new ArrayList<Map.Entry>(matchingNodes.entrySet());
        if (applyOverrideRules) {
            mNodes = this.applyOverrideRules(mNodes);
        }
        block12: for (Map.Entry node : mNodes) {
            String finalDottedName;
            Dom targetNode = (Dom)node.getKey();
            for (String name : targetNode.model.getAttributeNames()) {
                finalDottedName = (String)node.getValue() + "." + name;
                if (!this.matches(finalDottedName, pattern) || !attrName.equals(name) && !attrName.replace('_', '-').equals(name.replace('_', '-'))) continue;
                if (this.isDeprecatedAttr(targetNode, name)) {
                    this.warning(context, localStrings.getLocalString("admin.set.deprecated", "Warning: The attribute {0} is deprecated.", new Object[]{finalDottedName}));
                }
                if (!isProperty) {
                    targetName = prefix + finalDottedName;
                    if (value != null && value.length() > 0) {
                        attrChanges.put(name, value);
                    } else {
                        attrChanges.put(name, null);
                    }
                } else {
                    targetName = prefix + (String)node.getValue();
                }
                if (delProperty) {
                    String str = (String)node.getValue();
                    if (SetCommand.trueLastIndexOf(str, '.') != -1) {
                        str = str.substring(SetCommand.trueLastIndexOf(str, '.') + 1);
                    }
                    try {
                        if (str == null) continue;
                        ConfigSupport.deleteChild((ConfigBean)((ConfigBean)targetNode.parent()), (ConfigBean)((ConfigBean)targetNode));
                        delPropertySuccess = true;
                        continue;
                    }
                    catch (IllegalArgumentException ie) {
                        SetCommand.fail(context, localStrings.getLocalString("admin.set.delete.property.failure", "Could not delete the property: {0}", new Object[]{ie.getMessage()}), ie);
                        return false;
                    }
                    catch (TransactionFailure transactionFailure) {
                        SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                        return false;
                    }
                }
                changes.put((ConfigBean)node.getKey(), attrChanges);
            }
            for (String name : targetNode.model.getLeafElementNames()) {
                finalDottedName = (String)node.getValue() + "." + name;
                if (!this.matches(finalDottedName, pattern) || !attrName.equals(name) && !attrName.replace('_', '-').equals(name.replace('_', '-'))) continue;
                if (this.isDeprecatedAttr(targetNode, name)) {
                    this.warning(context, localStrings.getLocalString("admin.set.elementdeprecated", "Warning: The element {0} is deprecated.", new Object[]{finalDottedName}));
                }
                try {
                    SetCommand.setLeafElement((ConfigBean)targetNode, name, value);
                }
                catch (TransactionFailure ex) {
                    SetCommand.fail(context, localStrings.getLocalString("admin.set.badelement", "Cannot change the element: {0}", new Object[]{ex.getMessage()}), (Exception)((Object)ex));
                    return false;
                }
                setElementSuccess = true;
                continue block12;
            }
        }
        if (!changes.isEmpty()) {
            try {
                this.config.apply(changes);
                this.success(context, targetName, value);
                this.runLegacyChecks(context);
            }
            catch (TransactionFailure transactionFailure) {
                SetCommand.fail(context, localStrings.getLocalString("admin.set.attribute.change.failure", "Could not change the attributes: {0}", new Object[]{transactionFailure.getMessage()}), (Exception)((Object)transactionFailure));
                return false;
            }
        } else if (delPropertySuccess || setElementSuccess) {
            this.success(context, targetName, value);
        } else {
            SetCommand.fail(context, localStrings.getLocalString("admin.set.configuration.notfound", "No configuration found for {0}", new Object[]{targetName}));
            return false;
        }
        return !this.targetService.isThisDAS() || this.replicateSetCommand(context, targetName, value);
    }

    public static void setLeafElement(final ConfigBean node, final String elementName, final String values) throws TransactionFailure {
        ConfigBeanProxy readableView = node.getProxy(node.getProxyType());
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConfigBeanProxy>(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                WriteableView writeableParent = (WriteableView)Proxy.getInvocationHandler(param);
                StringTokenizer st = new StringTokenizer(values, ",");
                ArrayList<String> valList = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    valList.add(st.nextToken());
                }
                ConfigBean bean = writeableParent.getMasterView();
                for (Method m : writeableParent.getProxyType().getMethods()) {
                    Class<?>[] argClasses = m.getParameterTypes();
                    Type[] argTypes = m.getGenericParameterTypes();
                    if (!bean.model.toProperty(m).xmlName().equals(elementName) || argClasses.length != 1 || !Collection.class.isAssignableFrom(argClasses[0]) || argTypes.length != 1 || !(argTypes[0] instanceof ParameterizedType) || !Types.erasure((Type)Types.getTypeArgument((Type)argTypes[0], (int)0)).isAssignableFrom(values.getClass())) continue;
                    try {
                        m.invoke((Object)writeableParent.getProxy(writeableParent.getProxyType()), valList);
                    }
                    catch (IllegalAccessException e) {
                        throw new TransactionFailure("Exception while setting element", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new TransactionFailure("Exception while setting element", (Throwable)e);
                    }
                    return node;
                }
                throw new TransactionFailure("No method found for setting element");
            }
        }, (ConfigBeanProxy)readableView);
    }

    private boolean isDeprecatedAttr(Dom dom, String name) {
        if (dom == null || dom.model == null || name == null) {
            return false;
        }
        Class t = dom.getProxyType();
        if (t == null) {
            return false;
        }
        for (Method method : t.getDeclaredMethods()) {
            ConfigModel.Property p = dom.model.toProperty(method);
            if (p == null || !name.equals(p.xmlName())) continue;
            return method.isAnnotationPresent(Deprecated.class);
        }
        for (AccessibleObject accessibleObject : t.getDeclaredFields()) {
            if (!name.equals(dom.model.camelCaseToXML(((Field)accessibleObject).getName()))) continue;
            return accessibleObject.isAnnotationPresent(Deprecated.class);
        }
        return false;
    }

    private String getElementFromString(String name, int index) {
        StringTokenizer token = new StringTokenizer(name, ".");
        String target = null;
        for (int j = 0; j < index; ++j) {
            if (!token.hasMoreTokens()) continue;
            target = token.nextToken();
        }
        return target;
    }

    private boolean replicateSetCommand(AdminCommandContext context, String targetName, String value) {
        String tName;
        List replicationInstances = null;
        if (targetName.startsWith("domain.")) {
            tName = targetName.substring("domain.".length());
            if (tName.indexOf(46) == -1) {
                replicationInstances = this.targetService.getAllInstances();
            }
        } else {
            tName = targetName;
        }
        if (replicationInstances == null) {
            int dotIdx = tName.indexOf(46);
            String firstElementOfName = dotIdx != -1 ? tName.substring(0, dotIdx) : tName;
            Integer targetElementLocation = this.targetLevel.get(firstElementOfName);
            if (targetElementLocation == null) {
                targetElementLocation = 1;
            }
            if (targetElementLocation == 0) {
                if ("resources".equals(firstElementOfName)) {
                    replicationInstances = this.targetService.getAllInstances();
                }
                if ("applications".equals(firstElementOfName)) {
                    String appName = this.getElementFromString(tName, 3);
                    if (appName == null) {
                        SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.appname", "Unable to extract application name from {0}", new Object[]{targetName}));
                        return false;
                    }
                    replicationInstances = this.targetService.getInstances(this.domain.getAllReferencedTargetsForApplication(appName));
                }
            } else {
                String target = this.getElementFromString(tName, targetElementLocation);
                if (target == null) {
                    SetCommand.fail(context, localStrings.getLocalString("admin.set.invalid.target", "Unable to extract replication target from {0}", new Object[]{targetName}));
                    return false;
                }
                replicationInstances = this.targetService.getInstances(target);
            }
        }
        if (replicationInstances != null && !replicationInstances.isEmpty()) {
            ParameterMap params = new ParameterMap();
            params.set((Object)"DEFAULT", (Object)(targetName + "=" + value));
            ActionReport.ExitCode ret = ClusterOperationUtil.replicateCommand((String)"set", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (FailurePolicy)FailurePolicy.Ignore, (List)replicationInstances, (AdminCommandContext)context, (ParameterMap)params, (Habitat)this.habitat);
            if (ret.equals((Object)ActionReport.ExitCode.FAILURE)) {
                return false;
            }
        }
        return true;
    }

    private void runLegacyChecks(AdminCommandContext context) {
        Collection list = this.habitat.getAllByContract(LegacyConfigurationUpgrade.class);
        for (LegacyConfigurationUpgrade upgrade : list) {
            upgrade.execute(context);
        }
    }

    private static int trueLastIndexOf(String target, char ch) {
        int i = target.lastIndexOf(ch);
        while (i > 0 && target.charAt(i - 1) == '\\') {
            i = target.lastIndexOf(ch, i - 1);
        }
        return i;
    }

    private static void fail(AdminCommandContext context, String msg) {
        SetCommand.fail(context, msg, null);
    }

    private static void fail(AdminCommandContext context, String msg, Exception ex) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
        if (ex != null) {
            context.getActionReport().setFailureCause((Throwable)ex);
        }
        context.getActionReport().setMessage(msg);
    }

    private void warning(AdminCommandContext context, String msg) {
        ActionReport ar = context.getActionReport().addSubActionsReport();
        ar.setActionExitCode(ActionReport.ExitCode.WARNING);
        ar.setMessage(msg);
    }

    private void success(AdminCommandContext context, String target, String value) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport.MessagePart part = context.getActionReport().getTopMessagePart().addChild();
        part.setChildrenType("DottedName");
        part.setMessage(target + "=" + value);
    }
}

