/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.common.DoNothingActionReporter;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.SystemTasks;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.RunLevelDefaultScope;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantActivator;
import org.jvnet.hk2.component.RunLevelListener;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.RunLevelState;
import org.jvnet.hk2.component.ServiceContext;

@Service
public class AppServerStartup
implements ModuleStartup {
    StartupContext context;
    static final Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    static final Level level = Level.FINE;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry systemRegistry;
    @Inject
    ExecutorService executor;
    @Inject
    Events events;
    @Inject
    Version version;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    @Inject
    SystemTasks pidWriter;
    @Inject
    RunLevelService<?> rls;
    private long platformInitTime;
    private String platform = System.getProperty("GlassFish_Platform");
    private final Map<Class, Long> servicesTiming = new HashMap<Class, Long>();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);
    private Thread serverThread;

    @Inject
    public void setStartupContext(StartupContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.commonCLS.getCommonClassLoader());
            this.doStart();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    private void doStart() {
        this.run();
        final CountDownLatch latch = new CountDownLatch(1);
        this.serverThread = new Thread("GlassFish Kernel Main Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.logp(level, "AppServerStartup", "run", "[{0}] started", new Object[]{this});
                latch.countDown();
                try {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                logger.logp(level, "AppServerStartup", "run", "[{0}] exiting", new Object[]{this});
            }
        };
        this.serverThread.setDaemon(false);
        this.serverThread.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void run() {
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
            return;
        }
        if (this.platform == null) {
            this.platform = "Embedded";
        }
        this.platformInitTime = System.currentTimeMillis();
        if (logger.isLoggable(level)) {
            logger.log(level, "Startup class : {0}", this.getClass().getName());
        }
        this.habitat.addComponent((Object)this);
        this.habitat.addComponent((Object)this.systemRegistry);
        this.habitat.addComponent((Object)logger);
        Inhabitant inh = this.habitat.getInhabitantByType(ProcessEnvironment.class);
        if (inh != null) {
            this.habitat.remove(inh);
        }
        this.habitat.removeAllByType(ProcessEnvironment.class);
        if (this.env.isEmbedded()) {
            this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(ProcessEnvironment.class, (Object)new ProcessEnvironment(ProcessEnvironment.ProcessType.Embedded)));
        } else {
            this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(ProcessEnvironment.class, (Object)new ProcessEnvironment(ProcessEnvironment.ProcessType.Server)));
        }
        if (this.proceedTo(1, new InitInhabitantActivator()) && this.proceedTo(10, new StartupInhabitantActivator())) {
            this.proceedTo(20, new PostStartupInhabitantActivator());
        }
    }

    public static void printModuleStatus(ModulesRegistry registry, Level level) {
        if (!logger.isLoggable(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder("Module Status Report Begins\n");
        for (Module m : registry.getModules()) {
            if (m.getState() != ModuleState.READY) continue;
            sb.append(m).append("\n");
        }
        sb.append("\n");
        for (Module m : registry.getModules()) {
            if (m.getState() != ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
        }
        sb.append("\n");
        for (Module m : registry.getModules()) {
            if (m.getState() == ModuleState.READY || m.getState() == ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
        }
        sb.append("Module Status Report Ends");
        logger.log(level, sb.toString());
    }

    private void shutdown() {
        CommandRunner runner = (CommandRunner)this.habitat.getByContract(CommandRunner.class);
        if (runner != null) {
            ParameterMap params = new ParameterMap();
            if (this.context.getArguments().containsKey("--noforcedshutdown")) {
                params.set((Object)"force", (Object)"false");
            }
            if (this.env.isDas()) {
                runner.getCommandInvocation("stop-domain", (ActionReport)new DoNothingActionReporter()).parameters(params).execute();
            } else {
                runner.getCommandInvocation("_stop-instance", (ActionReport)new DoNothingActionReporter()).parameters(params).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.env.getStatus() != ServerEnvironment.Status.started) {
            logger.info("Already stopped, so just returning");
            return;
        }
        this.env.setStatus(ServerEnvironment.Status.stopping);
        this.events.send(new EventListener.Event(EventTypes.PREPARE_SHUTDOWN), false);
        this.proceedTo(1, new AppServerInhabitantActivator());
        this.env.setStatus(ServerEnvironment.Status.stopped);
        this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
        this.rls.proceedTo(0);
        logger.info(localStrings.getLocalString("shutdownfinished", "Shutdown procedure finished"));
        if (this.serverThread != null) {
            Thread thread = this.serverThread;
            synchronized (thread) {
                this.serverThread.notify();
            }
            try {
                this.serverThread.join(0L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proceedTo(int runLevel, AppServerInhabitantActivator activator) {
        this.habitat.addIndex((Inhabitant)new ExistingSingletonInhabitant((Object)activator), RunLevelListener.class.getName(), null);
        try {
            this.habitat.addIndex((Inhabitant)new ExistingSingletonInhabitant((Object)activator), InhabitantActivator.class.getName(), null);
            try {
                this.rls.proceedTo(runLevel);
            }
            catch (Exception e) {
                boolean bl;
                try {
                    logger.log(Level.SEVERE, "Shutdown required", e);
                    this.shutdown();
                    bl = false;
                }
                catch (Throwable throwable) {
                    this.habitat.removeIndex(InhabitantActivator.class.getName(), null);
                    throw throwable;
                }
                this.habitat.removeIndex(InhabitantActivator.class.getName(), null);
                this.habitat.removeIndex(RunLevelListener.class.getName(), null);
                return bl;
            }
            this.habitat.removeIndex(InhabitantActivator.class.getName(), null);
        }
        finally {
            this.habitat.removeIndex(RunLevelListener.class.getName(), null);
        }
        return !activator.isShutdown();
    }

    private class PostStartupInhabitantActivator
    extends AppServerInhabitantActivator {
        private PostStartupInhabitantActivator() {
        }

        public void awaitCompletion() throws ExecutionException, InterruptedException, TimeoutException {
            if (!this.isShutdown()) {
                AppServerStartup.printModuleStatus(AppServerStartup.this.systemRegistry, level);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartupInhabitantActivator
    extends AppServerInhabitantActivator {
        private ArrayList<Future<Result<Thread>>> futures;

        private StartupInhabitantActivator() {
            this.futures = new ArrayList();
        }

        @Override
        public void activate(Inhabitant<?> inhabitant) {
            Class type = inhabitant.type();
            if (type.getAnnotation(Async.class) == null) {
                long start = System.currentTimeMillis();
                try {
                    if (logger.isLoggable(level)) {
                        logger.log(level, "Running Startup services " + type);
                    }
                    Object startup = inhabitant.get();
                    if (logger.isLoggable(level)) {
                        logger.log(level, "Startup services finished" + startup);
                    }
                    if (startup instanceof FutureProvider) {
                        this.futures.addAll(((FutureProvider)startup).getFutures());
                    }
                }
                catch (RuntimeException e) {
                    logger.log(level, e.getMessage(), e);
                    logger.log(Level.SEVERE, localStrings.getLocalString("startupservicefailure", "Startup service failed to start {0} due to {1} ", new Object[]{inhabitant.typeName(), e.getMessage()}));
                    AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
                    this.forceShutdown();
                    return;
                }
                if (logger.isLoggable(level)) {
                    AppServerStartup.this.servicesTiming.put(type, System.currentTimeMillis() - start);
                }
            }
        }

        @Override
        public void awaitCompletion() throws ExecutionException, InterruptedException, TimeoutException {
            this.awaitCompletion(3L, TimeUnit.SECONDS);
        }

        @Override
        public void awaitCompletion(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            if (this.isShutdown()) {
                return;
            }
            AppServerStartup.this.env.setStatus(ServerEnvironment.Status.starting);
            AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_STARTUP), false);
            logger.info(localStrings.getLocalString("startup_end_message", "{0} ({1}) startup time : {2} ({3}ms), startup services({4}ms), total({5}ms)", new Object[]{Version.getVersion(), Version.getBuildVersion(), AppServerStartup.this.platform, AppServerStartup.this.platformInitTime - AppServerStartup.this.context.getCreationTime(), System.currentTimeMillis() - AppServerStartup.this.platformInitTime, System.currentTimeMillis() - AppServerStartup.this.context.getCreationTime()}));
            AppServerStartup.printModuleStatus(AppServerStartup.this.systemRegistry, level);
            try {
                long realstart = Long.parseLong(System.getProperty("WALL_CLOCK_START"));
                logger.info("TOTAL TIME INCLUDING CLI: " + (System.currentTimeMillis() - realstart));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (logger.isLoggable(level)) {
                for (Map.Entry service : AppServerStartup.this.servicesTiming.entrySet()) {
                    logger.log(level, "Service : " + service.getKey() + " took " + service.getValue() + " ms");
                }
            }
            for (Future<Result<Thread>> future : this.futures) {
                try {
                    try {
                        if (!future.get(timeout, unit).isFailure()) continue;
                        Throwable t = future.get().exception();
                        logger.log(Level.SEVERE, localStrings.getLocalString("startupfatalstartup", "Shutting down v3 due to startup exception : ", new Object[]{t.getMessage()}));
                        logger.log(level, future.get().exception().getMessage(), t);
                        AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
                        this.forceShutdown();
                        return;
                    }
                    catch (TimeoutException e) {
                        logger.warning(localStrings.getLocalString("startupwaittimeout", "Timed out, ignoring some startup service status"));
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, t.getMessage(), t);
                }
            }
            AppServerStartup.this.env.setStatus(ServerEnvironment.Status.started);
            AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_READY), false);
            AppServerStartup.this.pidWriter.writePidFile();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitInhabitantActivator
    extends AppServerInhabitantActivator {
        private InitInhabitantActivator() {
        }

        @Override
        public void activate(Inhabitant<?> inhabitant) {
            long start = System.currentTimeMillis();
            inhabitant.get();
            if (logger.isLoggable(level)) {
                Class type = inhabitant.type();
                long finish = System.currentTimeMillis();
                logger.log(level, type + " Init done in " + (finish - AppServerStartup.this.context.getCreationTime()) + " ms");
                AppServerStartup.this.servicesTiming.put(type, finish - start);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AppServerInhabitantActivator
    implements InhabitantActivator,
    RunLevelListener {
        protected boolean shutdown;

        private AppServerInhabitantActivator() {
        }

        public void activate(Inhabitant<?> inhabitant) {
            inhabitant.get();
        }

        public void deactivate(Inhabitant<?> inhabitant) {
            if (inhabitant.isActive()) {
                try {
                    if (logger.isLoggable(level)) {
                        logger.log(level, "Releasing services {0}", inhabitant.type());
                    }
                    inhabitant.release();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        public void awaitCompletion() throws ExecutionException, InterruptedException, TimeoutException {
        }

        public void awaitCompletion(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            this.awaitCompletion();
        }

        public void onCancelled(RunLevelState<?> state, ServiceContext ctx, int previousProceedTo, boolean isInterrupt) {
            if (RunLevelDefaultScope.class.getName().equals(state.getScopeName())) {
                logger.log(Level.INFO, "shutdown requested");
                this.forceShutdown();
            }
        }

        public void onError(RunLevelState<?> state, ServiceContext ctx, Throwable t, boolean willContinue) {
            if (RunLevelDefaultScope.class.getName().equals(state.getScopeName())) {
                logger.log(Level.INFO, "shutdown requested", t);
                this.forceShutdown();
            }
        }

        public void onProgress(RunLevelState<?> state) {
            if (RunLevelDefaultScope.class.getName().equals(state.getScopeName())) {
                logger.log(level, "progress event: {0}", state);
            }
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        protected void forceShutdown() {
            this.shutdown = true;
            AppServerStartup.this.shutdown();
        }
    }
}

