/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ContainerStarter {
    @Inject
    Habitat habitat;
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ContainerRegistry registry;

    public Collection<EngineInfo> startContainer(Sniffer sniffer) {
        assert (sniffer != null);
        String containerName = sniffer.getModuleType();
        assert (containerName != null);
        try {
            Object[] modules = sniffer.setup(null, this.logger);
            this.logger.logp(Level.INFO, "ContainerStarter", "startContainer", "Snifer {0} set up following modules: {1}", new Object[]{sniffer, Arrays.toString(modules)});
        }
        catch (FileNotFoundException fnf) {
            this.logger.log(Level.SEVERE, fnf.getMessage());
            return null;
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, ioe.getMessage(), ioe);
            return null;
        }
        HashMap<String, EngineInfo> containers = new HashMap<String, EngineInfo>();
        for (String name : sniffer.getContainersNames()) {
            Inhabitant provider = this.habitat.getInhabitant(Container.class, name);
            if (provider == null) {
                this.logger.severe("Cannot find Container named " + name + ", so unable to start " + sniffer.getModuleType() + " container");
                return null;
            }
            EngineInfo info = new EngineInfo(provider, sniffer, null);
            containers.put(name, info);
        }
        for (Map.Entry entry : containers.entrySet()) {
            this.registry.addContainer((String)entry.getKey(), (EngineInfo)entry.getValue());
        }
        return containers.values();
    }
}

