/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.AppServerStartup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.PostConstruct;
import org.glassfish.hk2.PreDestroy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Priority;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RunLevelBridge
implements PostConstruct,
PreDestroy {
    private static final Logger logger = Logger.getLogger(RunLevelBridge.class.getName());
    private static final Level level = AppServerStartup.level;
    @Inject
    private Habitat habitat;
    private final Class bridgeClass;
    private final Class additionalShutdownClass;

    RunLevelBridge(Class bridgeClass) {
        this.bridgeClass = bridgeClass;
        this.additionalShutdownClass = null;
    }

    RunLevelBridge(Class bridgeClass, Class additionalShutdownClass) {
        this.bridgeClass = bridgeClass;
        this.additionalShutdownClass = additionalShutdownClass;
    }

    public void postConstruct() {
        List<Inhabitant<?>> inhabitants = this.sort(this.habitat.getInhabitants(this.bridgeClass));
        for (Inhabitant<?> i : inhabitants) {
            if (!this.qualifies(true, i)) continue;
            long start = System.currentTimeMillis();
            logger.log(level, "starting {0}", i);
            try {
                this.activate(i);
            }
            catch (RuntimeException e) {
                logger.log(Level.SEVERE, "problem starting {0}: {1}", new Object[]{i, e.getMessage()});
                logger.log(level, "nested error", e);
                throw e;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "problem starting {0}: {1}", new Object[]{i, e.getMessage()});
                logger.log(level, "nested error", e);
            }
            if (!logger.isLoggable(level)) continue;
            logger.log(level, "start of " + i + " done in " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public void preDestroy() {
        List<Inhabitant<?>> inhabitants;
        if (null == this.additionalShutdownClass) {
            inhabitants = this.sort(this.habitat.getInhabitants(this.bridgeClass));
        } else {
            Collection inhabitants1 = this.habitat.getInhabitants(this.bridgeClass);
            Collection inhabitants2 = this.habitat.getInhabitants(this.additionalShutdownClass);
            inhabitants = new ArrayList();
            inhabitants.addAll(inhabitants2);
            inhabitants.addAll(inhabitants1);
            Collections.reverse(this.sort(inhabitants));
        }
        for (Inhabitant<?> i : inhabitants) {
            if (!this.qualifies(false, i)) continue;
            logger.log(level, "releasing {0}", i);
            try {
                this.deactivate(i);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "problem releasing {0}: {1}", new Object[]{i, e.getMessage()});
                logger.log(level, "nested error", e);
            }
        }
    }

    protected void activate(Inhabitant<?> i) {
        i.get();
    }

    protected void deactivate(Inhabitant<?> i) {
        i.release();
    }

    protected boolean qualifies(boolean startup, Inhabitant<?> i) {
        RunLevel rl = i.type().getAnnotation(RunLevel.class);
        if (startup) {
            return !i.isActive() && null == rl;
        }
        return i.isActive() && (null == rl || !rl.strict());
    }

    protected List<Inhabitant<?>> sort(Collection<Inhabitant<?>> coll) {
        List<Object> sorted;
        List<Object> list = sorted = List.class.isInstance(coll) ? (List)List.class.cast(coll) : new ArrayList(coll);
        if (sorted.size() > 1) {
            logger.log(level, "sorting {0},{1}", new Object[]{this.bridgeClass, this.additionalShutdownClass});
            Collections.sort(sorted, RunLevelBridge.getInhabitantComparator());
        }
        return sorted;
    }

    private static Comparator<Inhabitant<?>> getInhabitantComparator() {
        return new Comparator<Inhabitant<?>>(){

            @Override
            public int compare(Inhabitant<?> o1, Inhabitant<?> o2) {
                int o2level;
                int o1level = o1.type().getAnnotation(Priority.class) != null ? o1.type().getAnnotation(Priority.class).value() : 5;
                int n = o2level = o2.type().getAnnotation(Priority.class) != null ? o2.type().getAnnotation(Priority.class).value() : 5;
                if (o1level == o2level) {
                    return 0;
                }
                if (o1level < o2level) {
                    return -1;
                }
                return 1;
            }
        };
    }
}

