/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.v3.server.HK2Dispatcher;
import com.sun.enterprise.v3.services.impl.Endpoint;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpUtils;
import com.sun.enterprise.v3.services.impl.SnifferAdapter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.grizzly.config.ContextRootInfo;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.http.Note;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.server.util.MimeType;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.internal.grizzly.V3Mapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerMapper
extends StaticHttpHandler {
    private static final Logger LOGGER = Logger.getLogger(ContainerMapper.class.getName());
    private static final String ROOT = "";
    private Mapper mapper;
    private final GrizzlyListener listener;
    private String defaultHostName = "server";
    private final GrizzlyService grizzlyService;
    protected static final Note<MappingData> MAPPING_DATA = Request.createNote((String)"MappingData");
    private static final Note<DataChunk> DATA_CHUNK = Request.createNote((String)"DataChunk");
    private final HK2Dispatcher hk2Dispatcher = new HK2Dispatcher();
    private String version;
    private static final AfterServiceListener afterServiceListener = new AfterServiceListenerImpl();
    private boolean mapMultipleAdapter;

    public ContainerMapper(GrizzlyService service, GrizzlyListener grizzlyListener) {
        this.listener = grizzlyListener;
        this.grizzlyService = service;
        this.version = System.getProperty("product.name");
        if (this.version == null) {
            this.version = Version.getVersion();
        }
    }

    protected synchronized void setDefaultHost(String defaultHost) {
        this.defaultHostName = defaultHost;
    }

    protected void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected synchronized void configureMapper() {
        this.mapper.setDefaultHostName(this.defaultHostName);
        this.mapper.addHost(this.defaultHostName, new String[0], null);
        this.mapper.addContext(this.defaultHostName, ROOT, (Object)new ContextRootInfo((HttpHandler)this, null), new String[]{"index.html", "index.htm"}, null);
        Mapper.setAllowReplacement((boolean)true);
    }

    public void service(Request request, Response response) throws Exception {
        block19: {
            try {
                HttpHandler httpHandler;
                request.addAfterServiceListener(afterServiceListener);
                if (!this.mapMultipleAdapter && this.mapper instanceof V3Mapper && (httpHandler = ((V3Mapper)this.mapper).getHttpHandler()) != null) {
                    request.setNote(MAPPING_DATA, null);
                    httpHandler.service(request, response);
                    return;
                }
                DataChunk decodedURI = request.getRequest().getRequestURIRef().getDecodedRequestURIBC(this.isAllowEncodedSlash());
                MappingData mappingData = (MappingData)request.getNote(MAPPING_DATA);
                if (mappingData == null) {
                    mappingData = new MappingData();
                    request.setNote(MAPPING_DATA, (Object)mappingData);
                } else {
                    mappingData.recycle();
                }
                CharChunk decodedURICC = decodedURI.getCharChunk();
                int semicolon = decodedURICC.indexOf(';', 0);
                HttpHandler httpService = this.mapUriWithSemicolon(request, decodedURI, semicolon, mappingData);
                if (httpService == null || httpService instanceof ContainerMapper) {
                    String ext = decodedURI.toString();
                    String type = ROOT;
                    if (ext.lastIndexOf(".") > 0) {
                        ext = "*" + ext.substring(ext.lastIndexOf("."));
                        type = ext.substring(ext.lastIndexOf(".") + 1);
                    }
                    if (!MimeType.contains((String)type) && !"/".equals(ext)) {
                        this.initializeFileURLPattern(ext);
                        mappingData.recycle();
                        httpService = this.mapUriWithSemicolon(request, decodedURI, semicolon, mappingData);
                    } else {
                        super.service(request, response);
                        return;
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Request: {0} was mapped to Adapter: {1}", new Object[]{decodedURI.toString(), httpService});
                }
                if (httpService == null || httpService instanceof ContainerMapper) {
                    super.service(request, response);
                } else {
                    ContextRootInfo contextRootInfo = null;
                    if (mappingData.context != null && mappingData.context instanceof ContextRootInfo) {
                        contextRootInfo = (ContextRootInfo)mappingData.context;
                    }
                    if (contextRootInfo == null) {
                        httpService.service(request, response);
                    } else {
                        ClassLoader cl = null;
                        if (contextRootInfo.getContainer() instanceof ApplicationContainer) {
                            cl = ((ApplicationContainer)contextRootInfo.getContainer()).getClassLoader();
                        }
                        this.hk2Dispatcher.dispatch(httpService, cl, request, response);
                    }
                }
            }
            catch (Exception ex) {
                try {
                    response.setStatus(500);
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Internal Server error: " + request.getRequest().getRequestURIRef().getDecodedRequestURIBC(), ex);
                    }
                    this.customizedErrorPage(request, response);
                }
                catch (Exception ex2) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block19;
                    LOGGER.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
    }

    public synchronized void initializeFileURLPattern(String ext) {
        for (Sniffer sniffer : this.grizzlyService.habitat.getAllByContract(Sniffer.class)) {
            boolean match = false;
            if (sniffer.getURLPatterns() == null) continue;
            for (String pattern : sniffer.getURLPatterns()) {
                if (!pattern.equalsIgnoreCase(ext)) continue;
                match = true;
                break;
            }
            if (!match) continue;
            HttpHandler adapter = (HttpHandler)this.grizzlyService.habitat.getComponent(SnifferAdapter.class);
            ((SnifferAdapter)adapter).initialize(sniffer, this);
            ContextRootInfo c = new ContextRootInfo(adapter, null);
            for (String pattern : sniffer.getURLPatterns()) {
                for (String host : this.grizzlyService.hosts) {
                    this.mapper.addWrapper(host, ROOT, pattern, (Object)c, "*.jsp".equals(pattern) || "*.jspx".equals(pattern));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final HttpHandler mapUriWithSemicolon(Request req, DataChunk decodedURI, int semicolonPos, MappingData mappingData) throws Exception {
        CharChunk charChunk = decodedURI.getCharChunk();
        int oldStart = charChunk.getStart();
        int oldEnd = charChunk.getEnd();
        if (semicolonPos == 0) {
            semicolonPos = decodedURI.indexOf(';', 0);
        }
        DataChunk localDecodedURI = decodedURI;
        if (semicolonPos >= 0) {
            charChunk.setEnd(semicolonPos);
            localDecodedURI = (DataChunk)req.getNote(DATA_CHUNK);
            if (localDecodedURI == null) {
                localDecodedURI = DataChunk.newInstance();
                req.setNote(DATA_CHUNK, (Object)localDecodedURI);
            }
            localDecodedURI.duplicate(decodedURI);
        }
        try {
            HttpHandler httpHandler = this.map(req, localDecodedURI, mappingData);
            return httpHandler;
        }
        finally {
            charChunk.setStart(oldStart);
            charChunk.setEnd(oldEnd);
        }
    }

    HttpHandler map(Request req, DataChunk decodedURI, MappingData mappingData) throws Exception {
        if (mappingData == null) {
            mappingData = (MappingData)req.getNote(MAPPING_DATA);
        }
        this.mapper.map(req.getRequest().serverName(), decodedURI, mappingData);
        if (!mappingData.contextPath.isNull()) {
            ContainerMapper.updateContextPath((Request)req, (String)mappingData.contextPath.toString());
        }
        if (mappingData.context != null && (mappingData.context instanceof ContextRootInfo || mappingData.wrapper instanceof ContextRootInfo)) {
            ContextRootInfo contextRootInfo = mappingData.wrapper != null ? (ContextRootInfo)mappingData.wrapper : (ContextRootInfo)mappingData.context;
            return contextRootInfo.getHttpHandler();
        }
        if (mappingData.context != null && "com.sun.enterprise.web.WebModule".equals(mappingData.context.getClass().getName())) {
            return ((V3Mapper)this.mapper).getHttpHandler();
        }
        return null;
    }

    protected void customizedErrorPage(Request req, Response res) throws Exception {
        byte[] errorBody = res.getStatus() == 404 ? HttpUtils.getErrorPage(Version.getVersion(), String.format("The requested resource (%s) is not available.", req.getDecodedRequestURI()), "404") : HttpUtils.getErrorPage(Version.getVersion(), "Internal Error", "500");
        ByteChunk chunk = new ByteChunk();
        chunk.setBytes(errorBody, 0, errorBody.length);
        res.setContentLength(errorBody.length);
        res.setContentType("text/html");
        if (!this.version.isEmpty()) {
            res.addHeader("Server", this.version);
        }
        res.flush();
        res.getOutputBuffer().write(chunk.getBuffer());
    }

    public void register(String contextRoot, Collection<String> vs, HttpHandler httpService, ApplicationContainer container) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER({0}) REGISTER contextRoot: {1} adapter: {2} container: {3} port: {4}", new Object[]{this, contextRoot, httpService, container, this.listener.getPort()});
        }
        this.mapMultipleAdapter = true;
        ContextRootInfo c = new ContextRootInfo(httpService, (Object)container);
        for (String host : vs) {
            this.mapper.addContext(host, contextRoot, (Object)c, new String[0], null);
        }
    }

    public void unregister(String contextRoot) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER ({0}) UNREGISTER contextRoot: {1}", new Object[]{this, contextRoot});
        }
        for (String host : this.grizzlyService.hosts) {
            this.mapper.removeContext(host, contextRoot);
        }
    }

    public void register(final Endpoint endpoint) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER({0}) REGISTER endpoint: {1}", endpoint);
        }
        this.mapMultipleAdapter = true;
        String contextRoot = endpoint.getContextRoot();
        Collection<String> vs = endpoint.getVirtualServers();
        ContextRootInfo c = new ContextRootInfo(new ContextRootInfo.Holder(){

            public HttpHandler getHttpHandler() {
                return endpoint.getEndpointHandler();
            }

            public Object getContainer() {
                return endpoint.getContainer();
            }
        });
        for (String host : vs) {
            this.mapper.addContext(host, contextRoot, (Object)c, new String[0], null);
        }
    }

    public void unregister(Endpoint endpoint) {
        this.unregister(endpoint.getContextRoot());
    }

    private static final class AfterServiceListenerImpl
    implements AfterServiceListener {
        private AfterServiceListenerImpl() {
        }

        public void onAfterService(Request request) {
            MappingData mappingData = (MappingData)request.getNote(MAPPING_DATA);
            if (mappingData != null) {
                mappingData.recycle();
            }
        }
    }
}

