/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.services.impl.Endpoint;
import com.sun.enterprise.v3.services.impl.GlassfishNetworkListener;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpAdapter;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.ServiceInitializerListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.impl.UnsafeFutureImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyProxy
implements NetworkProxy {
    final Logger logger;
    final NetworkListener networkListener;
    protected GrizzlyListener grizzlyListener;
    private int portNumber;
    public static final String LEADER_FOLLOWER = "org.glassfish.grizzly.useLeaderFollower";
    public static final String AUTO_CONFIGURE = "org.glassfish.grizzly.autoConfigure";
    private InetAddress address;
    private GrizzlyService grizzlyService;

    public GrizzlyProxy(GrizzlyService service, NetworkListener listener) {
        this.grizzlyService = service;
        this.logger = service.getLogger();
        this.networkListener = listener;
    }

    public void initialize() throws IOException {
        String port = this.networkListener.getPort();
        this.portNumber = 8080;
        if (port == null) {
            this.logger.severe("Cannot find port information from domain.xml");
            throw new RuntimeException("Cannot find port information from domain configuration");
        }
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.logger.log(Level.SEVERE, "Cannot parse port value : {0}, using port 8080", port);
        }
        try {
            this.address = InetAddress.getByName(this.networkListener.getAddress());
        }
        catch (UnknownHostException ex) {
            this.logger.log(Level.SEVERE, "Unknown address " + this.address, ex);
        }
        this.createGrizzlyListener(this.networkListener);
        this.grizzlyListener.configure(this.grizzlyService.getHabitat(), this.networkListener);
    }

    protected void createGrizzlyListener(NetworkListener networkListener) {
        if ("light-weight-listener".equals(networkListener.getProtocol())) {
            this.createServiceInitializerListener();
        } else {
            this.createGlassfishListener();
        }
    }

    protected void createGlassfishListener() {
        this.grizzlyListener = new GlassfishNetworkListener(this.grizzlyService, this.logger);
    }

    protected void createServiceInitializerListener() {
        this.grizzlyListener = new ServiceInitializerListener(this.grizzlyService, this.logger);
    }

    static ArrayList<String> toArray(String list, String token) {
        return new ArrayList<String>(Arrays.asList(list.split(token)));
    }

    @Override
    public void stop() throws IOException {
        this.grizzlyListener.stop();
    }

    @Override
    public void destroy() {
        this.grizzlyListener.destroy();
    }

    public String toString() {
        return "GrizzlyProxy{address=" + this.address + ", portNumber=" + this.portNumber + '}';
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, HttpHandler endpointService, ApplicationContainer container) throws EndpointRegistrationException {
        if (contextRoot == null) {
            return;
        }
        if (endpointService == null) {
            throw new EndpointRegistrationException("The endpoint adapter is null");
        }
        HttpAdapter httpAdapter = (HttpAdapter)this.grizzlyListener.getAdapter(HttpAdapter.class);
        if (httpAdapter != null) {
            httpAdapter.getMapper().register(contextRoot, vsServers, endpointService, container);
        }
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        HttpAdapter httpAdapter = (HttpAdapter)this.grizzlyListener.getAdapter(HttpAdapter.class);
        if (httpAdapter != null) {
            httpAdapter.getMapper().unregister(contextRoot);
        }
    }

    @Override
    public void registerEndpoint(Endpoint endpoint) {
        HttpAdapter httpAdapter = (HttpAdapter)this.grizzlyListener.getAdapter(HttpAdapter.class);
        if (httpAdapter != null) {
            httpAdapter.getMapper().register(endpoint);
        }
    }

    @Override
    public void unregisterEndpoint(Endpoint endpoint) throws EndpointRegistrationException {
        this.unregisterEndpoint(endpoint.getContextRoot(), endpoint.getContainer());
    }

    @Override
    public Future<Result<Thread>> start() throws IOException {
        UnsafeFutureImpl future = UnsafeFutureImpl.create();
        long t1 = System.currentTimeMillis();
        this.grizzlyListener.start();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Grizzly Framework {0} started in: {1}ms - bound to [{2}{3}{4}{5}", new Object[]{Grizzly.getDotedVersion(), System.currentTimeMillis() - t1, this.grizzlyListener.getAddress(), Character.valueOf(':'), this.grizzlyListener.getPort(), Character.valueOf(']')});
        }
        future.result((Object)new Result((Object)Thread.currentThread()));
        return future;
    }

    @Override
    public int getPort() {
        return this.portNumber;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    public GrizzlyListener getUnderlyingListener() {
        return this.grizzlyListener;
    }
}

