/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ServiceInitializerListener;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.internal.grizzly.LazyServiceInitializer;
import org.jvnet.hk2.component.Habitat;

public class ServiceInitializerFilter
extends BaseFilter {
    private volatile LazyServiceInitializer targetInitializer = null;
    private Collection<LazyServiceInitializer> initializerImplList = null;
    protected final Logger logger;
    private final ServiceInitializerListener listener;
    private final Object LOCK_OBJ = new Object();

    public ServiceInitializerFilter(ServiceInitializerListener listener, Habitat habitat, Logger logger) {
        this.initializerImplList = habitat.getAllByContract(LazyServiceInitializer.class);
        if (this.initializerImplList == null) {
            throw new IllegalStateException("NO Lazy Initialiser was found for port = " + listener.getPort());
        }
        this.logger = logger;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        NIOConnection nioConnection = (NIOConnection)ctx.getConnection();
        SelectableChannel channel = nioConnection.getChannel();
        if (this.targetInitializer == null) {
            Object object = this.LOCK_OBJ;
            synchronized (object) {
                if (this.targetInitializer == null) {
                    LazyServiceInitializer targetInitializerLocal = null;
                    for (LazyServiceInitializer initializer : this.initializerImplList) {
                        String listenerName = this.listener.getName();
                        if (!listenerName.equalsIgnoreCase(initializer.getServiceName())) continue;
                        targetInitializerLocal = initializer;
                        break;
                    }
                    if (targetInitializerLocal == null) {
                        this.logger.log(Level.SEVERE, "NO Lazy Initialiser implementation was found for port = {0}", this.listener.getPort());
                        nioConnection.close();
                        return ctx.getStopAction();
                    }
                    if (!targetInitializerLocal.initializeService()) {
                        this.logger.log(Level.SEVERE, "Lazy Service initialization failed for port = {0}", this.listener.getPort());
                        nioConnection.close();
                        return ctx.getStopAction();
                    }
                    this.targetInitializer = targetInitializerLocal;
                }
            }
        }
        NextAction nextAction = ctx.getSuspendAction();
        ctx.completeAndRecycle();
        SelectorRunner runner = nioConnection.getSelectorRunner();
        SelectorHandler selectorHandler = ((NIOTransport)nioConnection.getTransport()).getSelectorHandler();
        selectorHandler.deregisterChannel(runner, channel);
        channel.configureBlocking(true);
        this.targetInitializer.handleRequest(channel);
        return nextAction;
    }
}

