/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.services.impl.ContainerMapper;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class SnifferAdapter
extends HttpHandler {
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    ContainerStarter containerStarter;
    @Inject
    ModulesRegistry modulesRegistry;
    private static final Logger LOGGER = LogDomains.getLogger(SnifferAdapter.class, (String)"javax.enterprise.system.core");
    private Sniffer sniffer;
    private ContainerMapper mapper;
    private HttpHandler adapter;

    public void initialize(Sniffer sniffer, ContainerMapper mapper) {
        this.sniffer = sniffer;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response resp) throws Exception {
        if (this.adapter != null) {
            this.adapter.service(req, resp);
            return;
        }
        ContainerRegistry containerRegistry = this.containerRegistry;
        synchronized (containerRegistry) {
            if (this.adapter != null) {
                this.adapter.service(req, resp);
                return;
            }
            if (this.containerRegistry.getContainer(this.sniffer.getContainersNames()[0]) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Container is claimed to be started...");
                }
                this.containerRegistry.getContainer(this.sniffer.getContainersNames()[0]).getContainer();
            } else {
                long startTime = System.currentTimeMillis();
                LOGGER.log(Level.INFO, "core.snifferadapter.starting.container", this.sniffer.getModuleType());
                try {
                    Collection<EngineInfo> containersInfo = this.containerStarter.startContainer(this.sniffer);
                    if (containersInfo != null && !containersInfo.isEmpty()) {
                        for (EngineInfo info : containersInfo) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "Got container, deployer is {0}", info.getDeployer());
                            }
                            info.getContainer();
                            LOGGER.log(Level.INFO, "core.snifferadapter.container.started", new Object[]{this.sniffer.getModuleType(), System.currentTimeMillis() - startTime});
                        }
                    } else {
                        LOGGER.severe("core.snifferadapter.no.container.available");
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "core.snifferadapter.exception.starting.container", new Object[]{this.sniffer.getContainersNames()[0]});
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            DataChunk decodedURI = req.getRequest().getRequestURIRef().getDecodedRequestURIBC();
            try {
                MappingData mappingData = (MappingData)req.getNote(ContainerMapper.MAPPING_DATA);
                mappingData.recycle();
                this.adapter = this.mapper.mapUriWithSemicolon(req, decodedURI, 0, null);
                if (this.adapter.equals((Object)this)) {
                    this.adapter = null;
                    throw new RuntimeException("SnifferAdapter cannot map themself.");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "core.snifferadapter.exception.mapping.request", e);
                throw e;
            }
            if (this.adapter == null) {
                throw new RuntimeException("No Adapter found.");
            }
            this.adapter.service(req, resp);
        }
    }
}

