/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.DomainXmlPersistence;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.glassfish.kernel.embedded.EmbeddedDomainXml;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.config.DomDocument;

public class EmbeddedDomainPersistence
extends DomainXmlPersistence {
    @Inject
    StartupContext startupContext;
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DomainXmlPersistence.class);

    protected File getDestination() throws IOException {
        String configFileReadOnly = this.startupContext.getArguments().getProperty("org.glassfish.embeddable.configFileReadOnly");
        if (configFileReadOnly != null && !Boolean.valueOf(configFileReadOnly).booleanValue()) {
            try {
                URI uri = EmbeddedDomainXml.getDomainXml(this.startupContext).toURI();
                if ("file".equalsIgnoreCase(uri.getScheme())) {
                    return new File(uri);
                }
                throw new IOException("configurationFile is writable but is not a file");
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return null;
    }

    public void save(DomDocument doc) throws IOException {
        File destination = this.getDestination();
        if (destination == null) {
            String msg = localStrings.getLocalString("NoLocation", "domain.xml cannot be persisted, null destination");
            this.logger.finer(msg);
            return;
        }
        super.save(doc);
    }

    protected void saved(File destination) {
        this.logger.log(Level.INFO, "Configuration saved at {0}", destination);
    }
}

