/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.event.AdminCommandEventBrokerImpl;
import com.sun.enterprise.admin.remote.AdminCommandStateImpl;
import com.sun.enterprise.admin.remote.JobPersistenceService;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobPersistence;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.services.common.SubjectUtil;

public class AdminCommandInstanceImpl
extends AdminCommandStateImpl
implements Job {
    private CommandProgress commandProgress;
    private Payload.Outbound payload;
    private final AdminCommandEventBroker broker = new AdminCommandEventBrokerImpl();
    private final long executionDate = new Date().getTime();
    private final String commandName;
    private final Subject subject;
    private final String scope;
    private boolean isManagedJob;
    private File jobsFile;

    protected AdminCommandInstanceImpl(String id, String name, String commandScope, Subject sub, boolean managedJob) {
        super(id);
        this.commandName = name;
        this.scope = commandScope;
        this.isManagedJob = managedJob;
        this.subject = sub;
    }

    protected AdminCommandInstanceImpl(String name, String scope, Subject sub, boolean managedJob) {
        this(null, name, scope, sub, managedJob);
    }

    public CommandProgress getCommandProgress() {
        return this.commandProgress;
    }

    public void setCommandProgress(CommandProgress commandProgress) {
        this.commandProgress = commandProgress;
        commandProgress.setEventBroker(this.broker);
    }

    public AdminCommandEventBroker getEventBroker() {
        return this.broker;
    }

    public File getJobsFile() {
        return this.jobsFile;
    }

    public void setJobsFile(File jobsFile) {
        this.jobsFile = jobsFile;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getName() {
        return this.commandName;
    }

    protected void setState(AdminCommandState.State state) {
        if (state != null && state != this.getState()) {
            super.setState(state);
            this.getEventBroker().fireEvent("AdminCommandInstance/stateChanged", (Object)this);
        }
    }

    public boolean isOutboundPayloadEmpty() {
        return this.payload == null || this.payload.size() == 0;
    }

    public void complete(ActionReport report, Payload.Outbound outbound) {
        if (this.commandProgress != null && report != null && report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
            this.commandProgress.complete();
        }
        this.payload = outbound;
        JobPersistence jobPersistenceService = null;
        if (this.isManagedJob) {
            jobPersistenceService = this.scope != null ? (JobPersistence)Globals.getDefaultHabitat().getService(JobPersistence.class, this.scope + "job-persistence", new Annotation[0]) : (JobPersistence)Globals.getDefaultHabitat().getService(JobPersistenceService.class, new Annotation[0]);
            List userList = SubjectUtil.getUsernamesFromSubject((Subject)this.subject);
            jobPersistenceService.persist((Object)new JobInfo(this.id, this.commandName, this.executionDate, AdminCommandState.State.COMPLETED.name(), (String)userList.get(0), report.getMessage(), this.getJobsFile()));
        }
        this.complete(report);
    }

    public long getCommandExecutionDate() {
        return this.executionDate;
    }

    public Payload.Outbound getPayload() {
        return this.payload;
    }
}

