/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CLIUtil;
import java.beans.PropertyVetoException;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-profiler")
@PerLookup
@I18n(value="delete.profiler")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Profiler.class, opType=RestEndpoint.OpType.DELETE, path="delete-profiler", description="Delete Profiler")})
public class DeleteProfiler
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteProfiler.class);
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    Target targetService;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @AccessRequired.To(value={"update"})
    private JavaConfig javaConfig;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.targetService, this.config, this.target);
        this.javaConfig = this.config.getJavaConfig();
        return true;
    }

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JavaConfig>(){

                public Object run(JavaConfig param) throws PropertyVetoException, TransactionFailure {
                    if (param.getProfiler() != null) {
                        param.setProfiler(null);
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return param;
                    }
                    report.setMessage(localStrings.getLocalString("delete.profiler.notfound", "delete failed, profiler not found"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return null;
                }
            }, (ConfigBeanProxy)this.javaConfig);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.profiler.fail", "delete failed "));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

