/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AuthorizationPreprocessor;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobManager;
import org.glassfish.security.services.common.SubjectUtil;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JobAuthorizationAttributeProcessor
implements AuthorizationPreprocessor {
    private static final String USER_ATTRIBUTE_NAME = "user";
    private static final Pattern JOB_PATTERN = Pattern.compile("(?:jobs/job(?:/(\\d*))?)");
    @Inject
    private JobManager jobManager;

    public void describeAuthorization(Subject subject, String resourceName, String action, AdminCommand command, Map<String, Object> context, Map<String, String> subjectAttributes, Map<String, String> resourceAttributes, Map<String, String> actionAttributes) {
        Matcher m = JOB_PATTERN.matcher(resourceName);
        if (!m.matches()) {
            return;
        }
        if (m.groupCount() == 0) {
            return;
        }
        String jobID = m.group(1);
        Job job = this.jobManager.get(jobID);
        String userID = (String)SubjectUtil.getUsernamesFromSubject((Subject)job.getSubject()).get(0);
        resourceAttributes.put(USER_ATTRIBUTE_NAME, userID);
    }
}

