/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ManagedJobConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.JobManagerService;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=10)
public class JobCleanUpService
implements PostConstruct,
ConfigListener {
    @Inject
    JobManagerService jobManagerService;
    @Inject
    Domain domain;
    private ManagedJobConfig managedJobConfig;
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private ScheduledExecutorService scheduler;
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(JobCleanUpService.class);

    public void postConstruct() {
        logger.fine(adminStrings.getLocalString("jobcleanup.service.init", "Initializing Job Cleanup service"));
        this.managedJobConfig = (ManagedJobConfig)this.domain.getExtensionByType(ManagedJobConfig.class);
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.managedJobConfig);
        logger.fine(adminStrings.getLocalString("init.managed.config.bean", "Initializing ManagedJobConfig bean"));
        bean.addListener((ConfigListener)this);
        this.scheduler = Executors.newScheduledThreadPool(10, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r);
                result.setDaemon(true);
                return result;
            }
        });
        this.scheduleCleanUp();
    }

    private void scheduleCleanUp() {
        logger.fine(adminStrings.getLocalString("scheduling.cleanup", "Scheduling cleanup"));
        long delayBetweenRuns = 1200000L;
        long initialDelay = 1200000L;
        delayBetweenRuns = this.jobManagerService.convert(this.managedJobConfig.getPollInterval());
        initialDelay = this.jobManagerService.convert(this.managedJobConfig.getInitialDelay());
        ScheduledFuture<?> cleanupFuture = this.scheduler.scheduleAtFixedRate(new JobCleanUpTask(), initialDelay, delayBetweenRuns, TimeUnit.MILLISECONDS);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new PropertyChangeHandler(), (Logger)logger);
    }

    private void cleanUpExpiredJobs() {
        ArrayList<JobInfo> expiredJobs = this.jobManagerService.getExpiredJobs();
        if (expiredJobs.size() > 0) {
            for (JobInfo job : expiredJobs) {
                this.jobManagerService.purgeJob(job.jobId);
                this.jobManagerService.purgeCompletedJobForId(job.jobId);
                logger.fine(adminStrings.getLocalString("cleaning.job", "Cleaning job {0}", new Object[]{job.jobId}));
            }
        }
    }

    class PropertyChangeHandler
    implements Changed {
        PropertyChangeHandler() {
        }

        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            switch (type) {
                case CHANGE: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(adminStrings.getLocalString("managedJobConfig.change", "ManagedJobConfig {0} was changed by {1} ", new Object[]{changedType.getName(), changedInstance}));
                    }
                    np = this.handleChangeEvent(changedInstance);
                    break;
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            JobCleanUpService.this.scheduleCleanUp();
            return null;
        }
    }

    private final class JobCleanUpTask
    implements Runnable {
        private JobCleanUpTask() {
        }

        @Override
        public void run() {
            try {
                logger.fine(adminStrings.getLocalString("cleaning.jobs", "Cleaning jobs"));
                JobCleanUpService.this.cleanUpExpiredJobs();
            }
            catch (Exception e) {
                throw new RuntimeException(adminStrings.getLocalString("error.cleaning.jobs", "Error while cleaning jobs" + e));
            }
        }
    }
}

