/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.LocalPassword;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=1)
public class LocalPasswordImpl
implements PostConstruct,
LocalPassword {
    @Inject
    ServerEnvironment env;
    private String password;
    private static final String LOCAL_PASSWORD_FILE = "local-password";
    private static final int PASSWORD_BYTES = 20;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger logger = KernelLoggerInfo.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        logger.fine("Generating local password");
        SecureRandom random = new SecureRandom();
        byte[] pwd = new byte[20];
        random.nextBytes(pwd);
        this.password = LocalPasswordImpl.toHex(pwd);
        File localPasswordFile = new File(this.env.getConfigDirPath(), LOCAL_PASSWORD_FILE);
        PrintWriter w = null;
        try {
            if (localPasswordFile.exists() && !localPasswordFile.delete()) {
                logger.log(Level.WARNING, "NCLS-CORE-0005", localPasswordFile.toString());
                return;
            }
            if (!localPasswordFile.createNewFile()) {
                logger.log(Level.WARNING, "NCLS-CORE-0006", localPasswordFile.toString());
                return;
            }
            localPasswordFile.setWritable(false, false);
            localPasswordFile.setWritable(true, true);
            localPasswordFile.setReadable(false, false);
            localPasswordFile.setReadable(true, true);
            w = new PrintWriter(localPasswordFile);
            w.println(this.password);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Exception writing local password file", ex);
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    public boolean isLocalPassword(String p) {
        return this.password != null && this.password.equals(p);
    }

    public String getLocalPassword() {
        return this.password;
    }

    private static String toHex(byte[] b) {
        char[] bc = new char[b.length * 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            byte bb = b[i];
            bc[j++] = hex[bb >> 4 & 0xF];
            bc[j++] = hex[bb & 0xF];
        }
        return new String(bc);
    }
}

