/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.AppServerStartup;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

abstract class RunLevelBridge
implements PostConstruct,
PreDestroy {
    private static final Logger logger = Logger.getLogger(RunLevelBridge.class.getName());
    private static final Level level = AppServerStartup.level;
    @Inject
    private ServiceLocator locator;
    private final Class bridgeClass;
    private List<ServiceHandle<?>> services = new LinkedList();

    RunLevelBridge(Class bridgeClass) {
        this.bridgeClass = bridgeClass;
    }

    public void postConstruct() {
        List serviceHandles = this.locator.getAllServiceHandles(this.bridgeClass, new Annotation[0]);
        for (ServiceHandle serviceHandle : serviceHandles) {
            long start = System.currentTimeMillis();
            logger.log(level, "starting {0}", serviceHandle);
            try {
                this.activate(serviceHandle);
            }
            catch (RuntimeException e) {
                logger.log(Level.SEVERE, "problem starting {0}: {1}", new Object[]{serviceHandle, e.getMessage()});
                logger.log(Level.SEVERE, "nested error", e);
                throw e;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "problem starting {0}: {1}", new Object[]{serviceHandle, e.getMessage()});
                logger.log(Level.SEVERE, "nested error", e);
            }
            if (!logger.isLoggable(level)) continue;
            logger.log(level, "start of " + serviceHandle + " done in " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public void preDestroy() {
        for (ServiceHandle<?> serviceHandle : this.services) {
            logger.log(level, "releasing {0}", serviceHandle);
            try {
                serviceHandle.getActiveDescriptor().dispose(serviceHandle.getService());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "problem releasing {0}: {1}", new Object[]{serviceHandle, e.getMessage()});
                logger.log(level, "nested error", e);
            }
        }
    }

    protected Object activate(ServiceHandle<?> serviceHandle) {
        Object service = serviceHandle.getService();
        this.services.add(0, serviceHandle);
        return service;
    }
}

