/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Service;

@Service
public class SnifferManagerImpl
implements SnifferManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SnifferManagerImpl.class);
    @Inject
    protected ServiceLocator habitat;

    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        sniffers.addAll(this.habitat.getAllServices(Sniffer.class, new Annotation[0]));
        Collections.sort(sniffers, new Comparator<Sniffer>(){

            @Override
            public int compare(Sniffer o1, Sniffer o2) {
                return o1.getModuleType().compareTo(o2.getModuleType());
            }
        });
        return sniffers;
    }

    public final boolean hasNoSniffers() {
        return this.getSniffers().isEmpty();
    }

    public Sniffer getSniffer(String appType) {
        assert (appType != null);
        for (Sniffer sniffer : this.getSniffers()) {
            if (!appType.equalsIgnoreCase(sniffer.getModuleType())) continue;
            return sniffer;
        }
        return null;
    }

    public Collection<Sniffer> getSniffers(DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        ArchiveHandler handler = context.getArchiveHandler();
        List uris = handler.getClassPathURIs(archive);
        Types types = (Types)context.getTransientAppMetaData(Types.class.getName(), Types.class);
        return this.getSniffers(context, uris, types);
    }

    public Collection<Sniffer> getSniffers(DeploymentContext context, List<URI> uris, Types types) {
        Collection<Sniffer> regularSniffers = this.getSniffers();
        List<Sniffer> appSniffers = this.getApplicableSniffers(context, uris, types, regularSniffers, true);
        for (Sniffer sniffer : regularSniffers) {
            if (appSniffers.contains(sniffer) || !sniffer.handles(context)) continue;
            appSniffers.add(sniffer);
        }
        return appSniffers;
    }

    private <T extends Sniffer> List<T> getApplicableSniffers(DeploymentContext context, List<URI> uris, Types types, Collection<T> sniffers, boolean checkPath) {
        ArchiveType archiveType = (ArchiveType)this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (sniffers == null || sniffers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Sniffer> result = new ArrayList<Sniffer>();
        for (Sniffer sniffer : sniffers) {
            Class[] annotations;
            if (archiveType != null && !sniffer.supportsArchiveType(archiveType) || (annotations = sniffer.getAnnotationTypes(context)) == null) continue;
            block1: for (Class annotationType : annotations) {
                Type type;
                if (types == null || !((type = types.getBy(annotationType.getName())) instanceof AnnotationType)) continue;
                Collection elements = ((AnnotationType)type).allAnnotatedTypes();
                for (AnnotatedElement element : elements) {
                    if (checkPath) {
                        Object t = element instanceof Member ? ((Member)element).getDeclaringType() : (Type)element;
                        if (!t.wasDefinedIn(uris)) continue;
                        result.add(sniffer);
                        continue block1;
                    }
                    result.add(sniffer);
                    continue block1;
                }
            }
        }
        return result;
    }

    public void validateSniffers(Collection<? extends Sniffer> snifferCol, DeploymentContext context) {
        for (Sniffer sniffer : snifferCol) {
            String[] incompatTypes = sniffer.getIncompatibleSnifferTypes();
            if (incompatTypes == null) {
                return;
            }
            for (String type : incompatTypes) {
                for (Sniffer sniffer2 : snifferCol) {
                    if (!sniffer2.getModuleType().equals(type)) continue;
                    throw new IllegalArgumentException(localStrings.getLocalString("invalidarchivepackaging", "Invalid archive packaging {2}", new Object[]{sniffer.getModuleType(), type, context.getSourceDir().getPath()}));
                }
            }
        }
    }
}

