/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
public class EventsImpl
implements Events {
    @Inject
    ExecutorService executor;
    static final Logger logger = KernelLoggerInfo.getLogger();
    List<EventListener> listeners = Collections.synchronizedList(new ArrayList());

    public synchronized void register(EventListener listener) {
        this.listeners.add(listener);
    }

    public void send(EventListener.Event event) {
        this.send(event, true);
    }

    public void send(final EventListener.Event event, boolean asynchronously) {
        ArrayList<EventListener> l = new ArrayList<EventListener>();
        l.addAll(this.listeners);
        for (final EventListener listener : l) {
            EventTypes interested;
            RestrictTo fooBar;
            Method m = null;
            try {
                m = listener.getClass().getMethod("event", EventListener.Event.class);
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "NCLS-CORE-0068", ex);
            }
            if (m != null && (fooBar = m.getParameterTypes()[0].getAnnotation(RestrictTo.class)) != null && !event.is(interested = EventTypes.create((String)fooBar.value()))) continue;
            if (asynchronously) {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.event(event);
                        }
                        catch (Throwable e) {
                            logger.log(Level.WARNING, "NCLS-CORE-0069", e);
                        }
                    }
                });
                continue;
            }
            try {
                listener.event(event);
            }
            catch (DeploymentException de) {
                throw de;
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "NCLS-CORE-0069", e);
            }
        }
    }

    public synchronized boolean unregister(EventListener listener) {
        return this.listeners.remove(listener);
    }
}

