/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;

import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.TargetType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.internal.api.Target;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.annotations.Service;

import jakarta.inject.Inject;
import jakarta.inject.Named;

import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.SystemPropertyConstants;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.api.admin.*;

/**
* Delete JDBC Resource command
*
*/
@Service(name="delete-profiler")
@PerLookup
@I18n("delete.profiler")
@ExecuteOn({RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType({CommandTarget.DAS,CommandTarget.STANDALONE_INSTANCE,CommandTarget.CLUSTER,CommandTarget.CONFIG})
@RestEndpoints({
    @RestEndpoint(configBean=Profiler.class,
        opType=RestEndpoint.OpType.DELETE,
        path="delete-profiler",
        description="Delete Profiler")
})
public class DeleteProfiler implements AdminCommand, AdminCommandSecurity.Preauthorization {

   final private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteProfiler.class);

    @Param(name="target", optional=true, defaultValue = SystemPropertyConstants.DEFAULT_SERVER_INSTANCE_NAME)
    String target;

    @Inject
    Target targetService;

    @Inject @Named(ServerEnvironment.DEFAULT_INSTANCE_NAME)
    Config config;

    @AccessRequired.To("update")
    private JavaConfig javaConfig;


    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        config = CLIUtil.chooseConfig(targetService, config, target);
        javaConfig = config.getJavaConfig();
        return true;
    }

    /**
    * Executes the command with the command parameters passed as Properties
    * where the keys are the paramter names and the values the parameter values
    *
    * @param context information
    */
   public void execute(AdminCommandContext context) {

        final ActionReport report = context.getActionReport();
        try {
           ConfigSupport.apply(new SingleConfigCode<JavaConfig>() {
               public Object run(JavaConfig param) throws PropertyVetoException, TransactionFailure {
                   if (param.getProfiler() != null) {
                       param.setProfiler(null);
                       report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return param;
                   }
                   // not found
                   report.setMessage(localStrings.getLocalString("delete.profiler.notfound", "delete failed, profiler not found"));
                   report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return null;
               }
           }, javaConfig);
       } catch(TransactionFailure e) {
           report.setMessage(localStrings.getLocalString("delete.profiler.fail", "delete failed "));
           report.setActionExitCode(ActionReport.ExitCode.FAILURE);
           report.setFailureCause(e);
       }
   }
}
