/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.KernelIdentity;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public abstract class AutoOperation {
    public static final Logger deplLogger = AutoDeployer.deplLogger;
    private static final String INFO_MSG = "NCLS-DEPLOYMENT-00035";
    private static final String WARNING_MSG = "NCLS-DEPLOYMENT-00036";
    private static final String EXCEPTION_OCCURRED = "NCLS-DEPLOYMENT-00037";
    private static final String DELETE_FAILED = "NCLS-DEPLOYMENT-00038";
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AutoDeployer.class);
    private static final String[] autoDeployFileSuffixes = new String[]{"_deployed", "_deployFailed", "_undeployed", "_undeployFailed", "_pending"};
    private File file;
    private Properties props;
    private String commandName;
    private AdminCommand command;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private AutodeployRetryManager retryManager;
    @Inject
    private KernelIdentity kernelIdentity;

    AutoOperation init(File file, Properties props, String commandName, AdminCommand command) {
        this.file = file;
        this.props = props;
        this.commandName = commandName;
        this.command = command;
        return this;
    }

    protected abstract void markFiles(AutoDeployer.AutodeploymentStatus var1, File var2);

    protected abstract String getMessageString(AutoDeployer.AutodeploymentStatus var1, File var2);

    final AutoDeployer.AutodeploymentStatus run() throws AutoDeploymentException {
        try {
            ParameterMap p = new ParameterMap();
            for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                p.set((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
            ActionReport report = this.commandRunner.getActionReport("hk2-agent");
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(this.commandName, report, this.kernelIdentity.getSubject());
            inv.parameters(p).execute(this.command);
            AutoDeployer.AutodeploymentStatus ds = AutoDeployer.AutodeploymentStatus.forExitCode(report.getActionExitCode());
            if (ds.status) {
                deplLogger.log(Level.INFO, INFO_MSG, this.getMessageString(ds, this.file));
            } else {
                deplLogger.log(Level.WARNING, WARNING_MSG, this.getMessageString(ds, this.file));
            }
            this.markFiles(ds, this.file);
            ds = this.retryManager.chooseAutodeploymentStatus(report.getActionExitCode(), this.file);
            return ds;
        }
        catch (Exception ex) {
            deplLogger.log(Level.SEVERE, EXCEPTION_OCCURRED, ex);
            return AutoDeployer.AutodeploymentStatus.FAILURE;
        }
    }

    private File getSuffixedFile(File f, String suffix) {
        String absPath = f.getAbsolutePath();
        File ret = new File(absPath + suffix);
        return ret;
    }

    protected File getDeployedFile(File f) {
        return this.getSuffixedFile(f, "_deployed");
    }

    protected File getDeployFailedFile(File f) {
        return this.getSuffixedFile(f, "_deployFailed");
    }

    protected File getUndeployedFile(File f) {
        return this.getSuffixedFile(f, "_undeployed");
    }

    protected File getUndeployFailedFile(File f) {
        return this.getSuffixedFile(f, "_undeployFailed");
    }

    protected void deleteAllMarks(File f) {
        try {
            for (String suffix : autoDeployFileSuffixes) {
                File suffixedFile = this.getSuffixedFile(f, suffix);
                if (!suffixedFile.exists() || suffixedFile.delete()) continue;
                deplLogger.log(Level.WARNING, DELETE_FAILED, suffixedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

