/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class MultiReadableArchive
extends AbstractReadableArchive {
    private ReadableArchive parentArchive = null;
    private ReadableArchive[] archives;
    @Inject
    private ArchiveFactory archiveFactory;

    public InputStream getEntry(String name) throws IOException {
        for (ReadableArchive ra : this.archives) {
            InputStream is = ra.getEntry(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public boolean exists(String name) throws IOException {
        for (ReadableArchive ra : this.archives) {
            if (!ra.exists(name)) continue;
            return true;
        }
        return false;
    }

    public long getEntrySize(String name) {
        for (ReadableArchive ra : this.archives) {
            long size = ra.getEntrySize(name);
            if (size == 0L) continue;
            return size;
        }
        return 0L;
    }

    public void open(URI uri) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void open(URI ... uris) throws IOException {
        this.archives = new ReadableArchive[uris.length];
        int slot = 0;
        for (URI uri : uris) {
            this.archives[slot++] = this.archiveFactory.openArchive(uri);
        }
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        for (ReadableArchive ra : this.archives) {
            ReadableArchive subArchive = ra.getSubArchive(name);
            if (subArchive == null) continue;
            return subArchive;
        }
        return null;
    }

    public boolean exists() {
        boolean result = true;
        for (ReadableArchive ra : this.archives) {
            result &= ra.exists();
        }
        return result;
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean renameTo(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParentArchive(ReadableArchive parentArchive) {
        this.parentArchive = parentArchive;
    }

    @Override
    public ReadableArchive getParentArchive() {
        return this.parentArchive;
    }

    public void close() throws IOException {
        for (ReadableArchive ra : this.archives) {
            ra.close();
        }
    }

    public Enumeration<String> entries() {
        LinkedHashSet enums = new LinkedHashSet();
        for (ReadableArchive ra : this.archives) {
            Enumeration e = ra.entries();
            while (e.hasMoreElements()) {
                enums.add(e.nextElement());
            }
        }
        return Collections.enumeration(enums);
    }

    public Enumeration<String> entries(String prefix) {
        LinkedHashSet enums = new LinkedHashSet();
        for (ReadableArchive ra : this.archives) {
            Enumeration e = ra.entries(prefix);
            while (e.hasMoreElements()) {
                enums.add(e.nextElement());
            }
        }
        return Collections.enumeration(enums);
    }

    public Collection<String> getDirectories() throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ReadableArchive ra : this.archives) {
            result.addAll(ra.getDirectories());
        }
        return result;
    }

    public boolean isDirectory(String name) {
        for (ReadableArchive ra : this.archives) {
            if (!ra.isDirectory(name)) continue;
            return true;
        }
        return false;
    }

    public Manifest getManifest() throws IOException {
        for (ReadableArchive ra : this.archives) {
            Manifest mf = ra.getManifest();
            if (mf == null) continue;
            return mf;
        }
        return null;
    }

    public URI getURI() {
        return this.archives[0].getURI();
    }

    public URI getURI(int slot) {
        return this.archives[slot].getURI();
    }

    public long getArchiveSize() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        StringBuilder name = new StringBuilder();
        for (ReadableArchive a : this.archives) {
            if (name.length() > 0) {
                name.append(",");
            }
            name.append(a.getName());
        }
        return name.toString();
    }
}

