/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;

public class DeploymentContextImpl
implements ExtendedDeploymentContext,
PreDestroy {
    @LogMessagesResourceBundle
    private static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.deployment.LogMessages";
    @LoggerInfo(subsystem="DEPLOYMENT", description="Deployment logger for common module", publish=true)
    private static final String DEPLOYMENT_LOGGER = "jakarta.enterprise.system.tools.deployment.common";
    public static final Logger deplLogger = Logger.getLogger("jakarta.enterprise.system.tools.deployment.common", "org.glassfish.deployment.LogMessages");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentContextImpl.class);
    private static final String INTERNAL_DIR_NAME = "__internal";
    private static final String APP_TENANTS_SUBDIR_NAME = "__app-tenants";
    ReadableArchive source;
    ReadableArchive originalSource;
    final OpsParams parameters;
    ActionReport actionReport;
    final ServerEnvironment env;
    ClassLoader cloader;
    ArchiveHandler archiveHandler;
    Properties props;
    Map<String, Object> modulesMetaData = new HashMap<String, Object>();
    ExtendedDeploymentContext.Phase phase = ExtendedDeploymentContext.Phase.UNKNOWN;
    ClassLoader sharableTemp;
    Map<String, Properties> modulePropsMap = new HashMap<String, Properties>();
    Map<String, Object> transientAppMetaData = new HashMap<String, Object>();
    Map<String, ArchiveHandler> moduleArchiveHandlers = new HashMap<String, ArchiveHandler>();
    Map<String, ExtendedDeploymentContext> moduleDeploymentContexts = new HashMap<String, ExtendedDeploymentContext>();
    ExtendedDeploymentContext parentContext;
    String moduleUri;
    private String tenant;
    private String originalAppName;
    private File tenantDir;

    public DeploymentContextImpl(Deployment.DeploymentContextBuilder builder, ServerEnvironment env) {
        this(builder.report(), builder.sourceAsArchive(), builder.params(), env);
    }

    public DeploymentContextImpl(ActionReport actionReport, Logger logger, ReadableArchive source, OpsParams params, ServerEnvironment env) {
        this(actionReport, source, params, env);
    }

    public DeploymentContextImpl(ActionReport actionReport, ReadableArchive source, OpsParams params, ServerEnvironment env) {
        this.originalSource = source;
        this.source = source;
        this.actionReport = actionReport;
        this.parameters = params;
        this.env = env;
    }

    public ExtendedDeploymentContext.Phase getPhase() {
        return this.phase;
    }

    public void setPhase(ExtendedDeploymentContext.Phase newPhase) {
        this.phase = newPhase;
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public void setSource(ReadableArchive source) {
        this.source = source;
    }

    public <U extends OpsParams> U getCommandParameters(Class<U> commandParametersType) {
        try {
            return (U)((OpsParams)commandParametersType.cast(this.parameters));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Logger getLogger() {
        return deplLogger;
    }

    public synchronized void preDestroy() {
        try {
            ((PreDestroy)PreDestroy.class.cast(this.sharableTemp)).preDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((PreDestroy)PreDestroy.class.cast(this.cloader)).preDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ClassLoader getFinalClassLoader() {
        return this.cloader;
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader(true);
    }

    public synchronized void setClassLoader(ClassLoader cloader) {
        this.cloader = cloader;
    }

    public synchronized void createDeploymentClassLoader(ClassLoaderHierarchy clh, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
        this.addTransientAppMetaData("isTempClassLoader", Boolean.TRUE);
        this.sharableTemp = this.createClassLoader(clh, handler, null);
    }

    public void createApplicationClassLoader(ClassLoaderHierarchy classLoaderHierarchy, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
        this.addTransientAppMetaData("isTempClassLoader", Boolean.FALSE);
        if (this.cloader == null) {
            this.cloader = this.createClassLoader(classLoaderHierarchy, handler, this.parameters.name());
        }
    }

    private ClassLoader createClassLoader(ClassLoaderHierarchy classLoaderHierarchy, ArchiveHandler handler, String appName) throws URISyntaxException, MalformedURLException {
        ClassLoader applibCL = classLoaderHierarchy.getAppLibClassLoader(appName, this.getAppLibs());
        ClassLoader parentCL = classLoaderHierarchy.createApplicationParentCL(applibCL, (DeploymentContext)this);
        return handler.getClassLoader(parentCL, (DeploymentContext)this);
    }

    public synchronized ClassLoader getClassLoader(boolean sharable) {
        if (this.phase == ExtendedDeploymentContext.Phase.PREPARE) {
            if (sharable) {
                return this.sharableTemp;
            }
            return ((InstrumentableClassLoader)InstrumentableClassLoader.class.cast(this.sharableTemp)).copy();
        }
        if (this.sharableTemp != null) {
            try {
                ((PreDestroy)PreDestroy.class.cast(this.sharableTemp)).preDestroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sharableTemp = null;
        }
        return this.cloader;
    }

    public File getScratchDir(String subDirName) {
        File rootScratchDir = this.env.getApplicationStubPath();
        if (this.tenant != null && this.originalAppName != null) {
            rootScratchDir = this.getRootScratchTenantDirForApp(this.originalAppName);
            rootScratchDir = new File(rootScratchDir, this.tenant);
            if (subDirName != null) {
                rootScratchDir = new File(rootScratchDir, subDirName);
            }
            return rootScratchDir;
        }
        if (subDirName != null) {
            rootScratchDir = new File(rootScratchDir, subDirName);
        }
        return new File(rootScratchDir, VersioningUtils.getRepositoryName(this.parameters.name()));
    }

    public File getSourceDir() {
        return new File(this.getSource().getURI());
    }

    public void addModuleMetaData(Object metaData) {
        if (metaData != null) {
            this.modulesMetaData.put(metaData.getClass().getName(), metaData);
        }
    }

    public <T> T getModuleMetaData(Class<T> metadataType) {
        Object moduleMetaData = this.modulesMetaData.get(metadataType.getName());
        if (moduleMetaData != null) {
            return metadataType.cast(moduleMetaData);
        }
        for (Object metadata : this.modulesMetaData.values()) {
            try {
                return metadataType.cast(metadata);
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    public Collection<Object> getModuleMetadata() {
        return new ArrayList<Object>(this.modulesMetaData.values());
    }

    public Map<String, Object> getTransientAppMetadata() {
        return new HashMap<String, Object>(this.transientAppMetaData);
    }

    public void addTransientAppMetaData(String metaDataKey, Object metaData) {
        if (metaData != null) {
            this.transientAppMetaData.put(metaDataKey, metaData);
        }
    }

    public <T> T getTransientAppMetaData(String key, Class<T> metadataType) {
        Object metaData = this.transientAppMetaData.get(key);
        if (metaData == null) {
            return null;
        }
        return metadataType.cast(metaData);
    }

    public Properties getAppProps() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    public Properties getModuleProps() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        InstrumentableClassLoader instrumentableClassLoader = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(this.getFinalClassLoader());
        ReentrantClassFileTransformer reentrantTransformer = new ReentrantClassFileTransformer(transformer);
        String isComposite = this.getAppProps().getProperty("isComposite");
        if (Boolean.valueOf(isComposite).booleanValue() && instrumentableClassLoader instanceof URLClassLoader) {
            boolean isAppLevel;
            URLClassLoader urlClassLoader = (URLClassLoader)instrumentableClassLoader;
            boolean bl = isAppLevel = this.getParentContext() == null;
            if (isAppLevel) {
                instrumentableClassLoader = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(urlClassLoader.getParent().getParent());
            } else {
                ClassLoader libClassLoader = urlClassLoader.getParent().getParent();
                if (!(libClassLoader instanceof InstrumentableClassLoader)) {
                    libClassLoader = libClassLoader.getParent();
                }
                if (libClassLoader instanceof InstrumentableClassLoader) {
                    ((InstrumentableClassLoader)InstrumentableClassLoader.class.cast(libClassLoader)).addTransformer((ClassFileTransformer)reentrantTransformer);
                }
            }
        }
        instrumentableClassLoader.addTransformer((ClassFileTransformer)reentrantTransformer);
    }

    public List<URI> getAppLibs() throws URISyntaxException {
        URL[] extensionListLibraries;
        ArrayList<URI> libURIs = new ArrayList<URI>();
        if (this.parameters.libraries() != null) {
            URL[] urls;
            for (URL url : urls = ASClassLoaderUtil.getDeployParamLibrariesAsURLs(this.parameters.libraries(), this.env)) {
                File file = new File(url.getFile());
                deplLogger.log(Level.FINE, "Specified library jar: " + file.getAbsolutePath());
                if (!file.exists()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.nonexist.libraries", "Specified library jar {0} does not exist: {1}", new Object[]{file.getName(), file.getAbsolutePath()}));
                }
                libURIs.add(url.toURI());
            }
        }
        Set<String> extensionList = null;
        try {
            extensionList = InstalledLibrariesResolver.getInstalledLibraries(this.source);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        for (URL url : extensionListLibraries = ASClassLoaderUtil.getLibrariesAsURLs(extensionList, this.env)) {
            libURIs.add(url.toURI());
            if (!deplLogger.isLoggable(Level.FINEST)) continue;
            deplLogger.log(Level.FINEST, "Detected [EXTENSION_LIST] installed-library [ " + url + " ] for archive [ " + this.source.getName() + "]");
        }
        return libURIs;
    }

    public void clean() {
        if (this.parameters.origin == OpsParams.Origin.undeploy || this.parameters.origin == OpsParams.Origin.deploy) {
            FileUtils.whack((File)this.getScratchDir("xml"));
            FileUtils.whack((File)this.getScratchDir("ejb"));
            FileUtils.whack((File)this.getScratchDir("jsp"));
            FileUtils.whack((File)this.getAppInternalDir());
            FileUtils.whack((File)this.getAppAltDDDir());
            FileUtils.whack((File)this.getRootTenantDirForApp(this.parameters.name()));
            FileUtils.whack((File)this.getRootScratchTenantDirForApp(this.parameters.name()));
        } else if (this.parameters.origin == OpsParams.Origin.mt_unprovision) {
            FileUtils.whack((File)this.tenantDir);
            FileUtils.whack((File)this.getScratchDir(null));
        }
    }

    public ArchiveHandler getArchiveHandler() {
        return this.archiveHandler;
    }

    public void setArchiveHandler(ArchiveHandler archiveHandler) {
        this.archiveHandler = archiveHandler;
    }

    public ReadableArchive getOriginalSource() {
        return this.originalSource;
    }

    public Map<String, Properties> getModulePropsMap() {
        return this.modulePropsMap;
    }

    public void setModulePropsMap(Map<String, Properties> modulePropsMap) {
        this.modulePropsMap = modulePropsMap;
    }

    public void setParentContext(ExtendedDeploymentContext parentContext) {
        this.parentContext = parentContext;
    }

    public ExtendedDeploymentContext getParentContext() {
        return this.parentContext;
    }

    public String getModuleUri() {
        return this.moduleUri;
    }

    public void setModuleUri(String moduleUri) {
        this.moduleUri = moduleUri;
    }

    public Map<String, ArchiveHandler> getModuleArchiveHandlers() {
        return this.moduleArchiveHandlers;
    }

    public Map<String, ExtendedDeploymentContext> getModuleDeploymentContexts() {
        return this.moduleDeploymentContexts;
    }

    public ActionReport getActionReport() {
        return this.actionReport;
    }

    public File getAppInternalDir() {
        File internalDir = new File(this.env.getApplicationRepositoryPath(), INTERNAL_DIR_NAME);
        return new File(internalDir, VersioningUtils.getRepositoryName(this.parameters.name()));
    }

    public File getAppAltDDDir() {
        File altDDDir = this.env.getApplicationAltDDPath();
        return new File(altDDDir, VersioningUtils.getRepositoryName(this.parameters.name()));
    }

    public void setTenant(String tenant, String appName) {
        this.tenant = tenant;
        this.originalAppName = appName;
        this.tenantDir = this.initTenantDir();
    }

    public String getTenant() {
        return this.tenant;
    }

    public File getTenantDir() {
        return this.tenantDir;
    }

    public void postDeployClean(boolean isFinalClean) {
        if (this.transientAppMetaData != null) {
            if (isFinalClean) {
                this.transientAppMetaData.clear();
            } else {
                String[] classNamesToClean;
                for (String className : classNamesToClean = new String[]{Types.class.getName(), Parser.class.getName()}) {
                    this.transientAppMetaData.remove(className);
                }
            }
        }
        this.actionReport = null;
    }

    public String toString() {
        return (this.source == null ? "" : this.source.toString()) + " " + (Serializable)(this.originalSource == null ? "" : this.originalSource.getURI());
    }

    public void prepareScratchDirs() throws IOException {
        this.prepareScratchDir(this.getScratchDir("ejb"));
        this.prepareScratchDir(this.getScratchDir("xml"));
        this.prepareScratchDir(this.getScratchDir("jsp"));
    }

    private File initTenantDir() {
        if (this.tenant == null || this.originalAppName == null) {
            return null;
        }
        File tenantDir = new File(this.getRootTenantDirForApp(this.originalAppName), this.tenant);
        if (!tenantDir.exists() && !tenantDir.mkdirs() && deplLogger.isLoggable(Level.FINEST)) {
            deplLogger.log(Level.FINEST, "Unable to create directory " + tenantDir.getAbsolutePath());
        }
        return tenantDir;
    }

    private File getRootTenantDirForApp(String appName) {
        return new File(new File(this.env.getApplicationRepositoryPath(), APP_TENANTS_SUBDIR_NAME), appName);
    }

    private File getRootScratchTenantDirForApp(String appName) {
        return new File(new File(this.env.getApplicationStubPath(), APP_TENANTS_SUBDIR_NAME), appName);
    }

    private void prepareScratchDir(File scratchDir) throws IOException {
        if (!scratchDir.isDirectory() && !scratchDir.mkdirs()) {
            throw new IOException("Cannot create scratch directory : " + scratchDir.getAbsolutePath());
        }
    }

    static final class ReentrantClassFileTransformer
    implements ClassFileTransformer {
        private final ThreadLocal<Boolean> bytecodeTransforming = ThreadLocal.withInitial(() -> false);
        private final ClassFileTransformer transformer;

        ReentrantClassFileTransformer(ClassFileTransformer transformer) {
            this.transformer = transformer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (this.bytecodeTransforming.get().booleanValue()) {
                return null;
            }
            this.bytecodeTransforming.set(true);
            try {
                byte[] byArray = this.transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                return byArray;
            }
            finally {
                this.bytecodeTransforming.remove();
            }
        }
    }
}

