/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.DeploymentContextImpl;

public class Artifacts {
    private static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    private final Set<FullAndPartURIs> artifacts = new HashSet<FullAndPartURIs>();
    private final String keyPrefix;

    private Artifacts(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    private String propNamePrefix() {
        return Artifacts.propNamePrefix(this.keyPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(DeploymentContext dc) {
        DeploymentContext deploymentContext = dc;
        synchronized (deploymentContext) {
            dc.addTransientAppMetaData(this.transientAppMetadataKey(), (Object)this);
        }
    }

    public synchronized void addArtifact(URI full, String part) {
        this.addArtifact(full, URI.create(part));
    }

    public synchronized void addArtifact(URI full, URI part) {
        this.addArtifact(full, part, false);
    }

    public synchronized void addArtifact(URI full, URI part, boolean isTemporary) {
        FullAndPartURIs fullAndPart = new FullAndPartURIs(full, part, isTemporary);
        this.artifacts.add(fullAndPart);
        deplLogger.log(Level.FINE, "Added {0} artifact: {1}", new Object[]{this.keyPrefix, fullAndPart});
    }

    public synchronized void addArtifacts(Collection<FullAndPartURIs> urisCollection) {
        this.artifacts.addAll(urisCollection);
        deplLogger.log(Level.FINE, "Added downloadable artifacts: {0}", urisCollection);
    }

    private String transientAppMetadataKey() {
        return Artifacts.transientAppMetadataKey(this.keyPrefix);
    }

    private String propName(URI partURI) {
        return this.propNamePrefix() + partURI.toASCIIString();
    }

    private String propValue(URI fullURI) {
        return fullURI.toASCIIString();
    }

    public synchronized Set<FullAndPartURIs> getArtifacts() {
        return this.artifacts;
    }

    public synchronized void record(Properties props) throws URISyntaxException {
        for (FullAndPartURIs artifactInfo : this.artifacts) {
            props.setProperty(this.propName(artifactInfo.getPart()), this.propValue(artifactInfo.getFull()));
        }
    }

    public synchronized void clearArtifacts() {
        this.artifacts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Artifacts get(DeploymentContext dc, String keyPrefix) {
        String key = Artifacts.transientAppMetadataKey(keyPrefix);
        DeploymentContext deploymentContext = dc;
        synchronized (deploymentContext) {
            Artifacts result = (Artifacts)dc.getTransientAppMetaData(key, Artifacts.class);
            if (result == null) {
                result = new Artifacts(keyPrefix);
                dc.addTransientAppMetaData(key, (Object)result);
            }
            return result;
        }
    }

    public static Artifacts get(Properties props, String keyPrefix) {
        Artifacts artifacts = new Artifacts(keyPrefix);
        for (String propName : props.stringPropertyNames()) {
            String propNamePrefix;
            if (!propName.startsWith(propNamePrefix = Artifacts.propNamePrefix(keyPrefix))) continue;
            URI fullURI = URI.create(props.getProperty(propName));
            artifacts.addArtifact(fullURI, propName.substring(propNamePrefix.length()));
        }
        return artifacts;
    }

    private static String propNamePrefix(String keyPrefix) {
        return keyPrefix + "Artifact.";
    }

    private static String transientAppMetadataKey(String keyPrefix) {
        return keyPrefix + "Artifacts";
    }

    public static class FullAndPartURIs {
        private final URI full;
        private final URI part;
        private final boolean isTemporary;

        public FullAndPartURIs(URI full, URI part) {
            this(full, part, false);
        }

        public FullAndPartURIs(URI full, String part) {
            this(full, part, false);
        }

        public FullAndPartURIs(URI full, String part, boolean isTemporary) {
            this(full, URI.create(part), isTemporary);
        }

        public FullAndPartURIs(URI full, URI part, boolean isTemporary) {
            this.full = full;
            this.part = part;
            this.isTemporary = isTemporary;
        }

        public URI getFull() {
            return this.full;
        }

        public URI getPart() {
            return this.part;
        }

        public boolean isTemporary() {
            return this.isTemporary;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FullAndPartURIs other = (FullAndPartURIs)obj;
            if (!(this.full == other.full || this.full != null && this.full.equals(other.full))) {
                return false;
            }
            return this.part == other.part || this.part != null && this.part.equals(other.part);
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + (this.full != null ? this.full.hashCode() : 0);
            hash = 29 * hash + (this.part != null ? this.part.hashCode() : 0);
            hash = 29 * hash + (this.isTemporary ? 0 : 1);
            return hash;
        }

        public String toString() {
            return "full URI=" + String.valueOf(this.full) + "; part URI=" + String.valueOf(this.part) + "; isTemporary=" + this.isTemporary;
        }
    }
}

