/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.security.ee.perms.EarEEPermissionsProcessor;
import com.sun.enterprise.security.ee.perms.PermsArchiveDelegate;
import com.sun.enterprise.security.ee.perms.SMGlobalPolicyUtil;
import com.sun.enterprise.security.integration.DDPermissionsLoader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.javaee.full.deployment.EarClassLoader;
import org.glassfish.javaee.full.deployment.EarDeployer;
import org.glassfish.javaee.full.deployment.EarLibClassLoader;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXException;

@Service(name="ear")
public class EarHandler
extends AbstractArchiveHandler
implements CompositeHandler {
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ServerEnvironment env;
    @Inject
    DasConfig dasConfig;
    @Inject
    @Named(value="ear")
    ArchiveDetector detector;
    private static final String EAR_LIB = "ear_lib";
    private static LocalStringsImpl strings = new LocalStringsImpl(EarHandler.class);
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EarHandler.class);
    private static final Logger _logger = EarDeployer.deplLogger;
    protected PermissionCollection earDeclaredPC;
    private Map<SMGlobalPolicyUtil.CommponentType, PermissionCollection> eeGarntsMap;

    public String getArchiveType() {
        return "ear";
    }

    public String getVersionIdentifier(ReadableArchive archive) {
        String versionIdentifier = null;
        try {
            GFApplicationXmlParser gfApplicationXMLParser = new GFApplicationXmlParser(archive);
            versionIdentifier = gfApplicationXMLParser.extractVersionIdentifierValue(archive);
        }
        catch (XMLStreamException e) {
            _logger.log(Level.SEVERE, e.getMessage());
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, e.getMessage());
        }
        return versionIdentifier;
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(ReadableArchive source, WritableArchive target, DeploymentContext context) throws IOException {
        super.expand(source, target, context);
        try (FileArchive source2 = null;){
            source2 = (FileArchive)target;
            ApplicationHolder holder = this.getApplicationHolder((ReadableArchive)source2, context, false);
            for (ModuleDescriptor md : holder.app.getModules()) {
                String moduleUri = md.getArchiveUri();
                ReadableArchive subArchive = null;
                ReadableArchive subArchiveToExpand = null;
                try {
                    subArchive = source2.getSubArchive(moduleUri);
                    if (subArchive == null) {
                        _logger.log(Level.WARNING, "Exception while locating sub archive: " + moduleUri);
                        continue;
                    }
                    ArchiveHandler subHandler = this.getArchiveHandlerFromModuleType(md.getModuleType());
                    if (subHandler == null) {
                        subHandler = this.deployment.getArchiveHandler(subArchive);
                    }
                    context.getModuleArchiveHandlers().put(moduleUri, subHandler);
                    if (subHandler == null) {
                        return;
                    }
                    WritableArchive subTarget = target.createSubArchive(FileUtils.makeFriendlyFilenameExtension((String)moduleUri));
                    try {
                        subArchiveToExpand = this.chooseSubArchiveToExpand(moduleUri, subTarget, subArchive, (ReadableArchive)source2);
                        if (subArchiveToExpand != null) {
                            subHandler.expand(subArchiveToExpand, subTarget, context);
                            continue;
                        }
                        if (EarHandler.areSameStorageType((Archive)subTarget, (Archive)subArchive)) continue;
                        String msg = MessageFormat.format(_logger.getResourceBundle().getString("enterprise.deployment.backend.badSubModPackaging"), subArchive.getURI().toASCIIString(), subArchive.getClass().getName());
                        throw new RuntimeException(msg);
                    }
                    finally {
                        if (subTarget == null) continue;
                        subTarget.close();
                    }
                }
                catch (IOException ioe) {
                    _logger.log(Level.FINE, "Exception while processing " + moduleUri, ioe);
                }
                finally {
                    try {
                        if (subArchive != null) {
                            subArchive.close();
                        }
                        if (subArchiveToExpand == null) continue;
                        subArchiveToExpand.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private ReadableArchive chooseSubArchiveToExpand(String moduleURI, WritableArchive subTarget, ReadableArchive subArchive, ReadableArchive expandedOriginalArchive) throws IOException {
        if (!subTarget.getURI().equals(subArchive.getURI())) {
            return subArchive;
        }
        if (expandedOriginalArchive.exists(moduleURI)) {
            URI unexpandedSubArchiveURI = expandedOriginalArchive.getURI().resolve(moduleURI);
            return this.archiveFactory.openArchive(unexpandedSubArchiveURI);
        }
        return null;
    }

    private static boolean areSameStorageType(Archive arch1, Archive arch2) {
        return arch1 instanceof FileArchive && arch2 instanceof FileArchive || arch1 instanceof JarArchive && arch2 instanceof JarArchive;
    }

    public ClassLoader getClassLoader(final ClassLoader parent, DeploymentContext context) {
        EarClassLoader cl;
        DelegatingClassLoader embeddedConnCl;
        ReadableArchive archive = context.getSource();
        ApplicationHolder holder = this.getApplicationHolder(archive, context, true);
        try {
            SunApplicationXmlParser sunApplicationXmlParser;
            GFApplicationXmlParser gfApplicationXmlParser;
            String compatProp = context.getAppProps().getProperty("compatibility");
            if (compatProp == null && (compatProp = (gfApplicationXmlParser = new GFApplicationXmlParser(context.getSource())).getCompatibilityValue()) != null) {
                context.getAppProps().put("compatibility", compatProp);
            }
            if (compatProp == null && (compatProp = (sunApplicationXmlParser = new SunApplicationXmlParser(context.getSourceDir())).getCompatibilityValue()) != null) {
                context.getAppProps().put("compatibility", compatProp);
            }
            if (System.getSecurityManager() != null) {
                this.earDeclaredPC = PermsArchiveDelegate.getDeclaredPermissions((SMGlobalPolicyUtil.CommponentType)SMGlobalPolicyUtil.CommponentType.ear, (DeploymentContext)context);
                this.processEEPermissions(context);
            }
            final URL[] earLibURLs = ASClassLoaderUtil.getAppLibDirLibraries((File)context.getSourceDir(), (String)holder.app.getLibraryDirectory(), (String)compatProp);
            final EarLibClassLoader earLibCl = AccessController.doPrivileged(new PrivilegedAction<EarLibClassLoader>(){

                @Override
                public EarLibClassLoader run() {
                    return new EarLibClassLoader(earLibURLs, parent);
                }
            });
            if (System.getSecurityManager() != null) {
                this.addEEOrDeclaredPermissions((ClassLoader)((Object)earLibCl), this.earDeclaredPC, false);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("added declaredPermissions to earlib: " + this.earDeclaredPC);
                }
                this.addEEOrDeclaredPermissions((ClassLoader)((Object)earLibCl), this.eeGarntsMap.get(SMGlobalPolicyUtil.CommponentType.ear), true);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("added all ee permissions to earlib: " + this.eeGarntsMap.get(SMGlobalPolicyUtil.CommponentType.ear));
                }
            }
            embeddedConnCl = AccessController.doPrivileged(new PrivilegedAction<DelegatingClassLoader>(){

                @Override
                public DelegatingClassLoader run() {
                    return new DelegatingClassLoader((ClassLoader)((Object)earLibCl));
                }
            });
            cl = AccessController.doPrivileged(new PrivilegedAction<EarClassLoader>(){

                @Override
                public EarClassLoader run() {
                    return new EarClassLoader((ClassLoader)embeddedConnCl);
                }
            });
            cl.addModuleClassLoader(EAR_LIB, (ClassLoader)((Object)earLibCl));
            if (System.getSecurityManager() != null) {
                this.addEEOrDeclaredPermissions((ClassLoader)((Object)cl), this.earDeclaredPC, false);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("declaredPermissions added: " + this.earDeclaredPC);
                }
                this.addEEOrDeclaredPermissions((ClassLoader)((Object)cl), this.eeGarntsMap.get(SMGlobalPolicyUtil.CommponentType.ejb), true);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("ee permissions added: " + this.eeGarntsMap.get(SMGlobalPolicyUtil.CommponentType.ejb));
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, strings.get("errAddLibs"), e);
            throw new RuntimeException(e);
        }
        for (ModuleDescriptor md : holder.app.getModules()) {
            String moduleUri = md.getArchiveUri();
            try {
                ReadableArchive sub = archive.getSubArchive(moduleUri);
                try {
                    if (sub == null) {
                        throw new IllegalArgumentException(strings.get("noSubModuleArchiveFound", new Object[]{moduleUri}));
                    }
                    if (sub instanceof InputJarArchive) {
                        throw new IllegalArgumentException(strings.get("wrongArchType", new Object[]{moduleUri}));
                    }
                    ArchiveHandler handler = (ArchiveHandler)context.getModuleArchiveHandlers().get(moduleUri);
                    if (handler == null) {
                        handler = this.getArchiveHandlerFromModuleType(md.getModuleType());
                        if (handler == null) {
                            handler = this.deployment.getArchiveHandler(sub);
                        }
                        context.getModuleArchiveHandlers().put(moduleUri, handler);
                    }
                    if (handler == null) continue;
                    ActionReport subReport = context.getActionReport().addSubActionsReport();
                    DeploymentContextImpl subContext = new DeploymentContextImpl(subReport, sub, context.getCommandParameters(DeployCommandParameters.class), this.env){

                        public File getScratchDir(String subDirName) {
                            String modulePortion = Util.getURIName((URI)this.getSource().getURI());
                            return new File(super.getScratchDir(subDirName), modulePortion);
                        }
                    };
                    subContext.setArchiveHandler(context.getArchiveHandler());
                    subContext.setParentContext((ExtendedDeploymentContext)context);
                    sub.setParentArchive(context.getSource());
                    ClassLoader subCl = handler.getClassLoader((ClassLoader)((Object)cl), (DeploymentContext)subContext);
                    if (System.getSecurityManager() != null && subCl instanceof DDPermissionsLoader) {
                        this.addEEOrDeclaredPermissions(subCl, this.earDeclaredPC, false);
                        _logger.log(Level.FINE, "added declared permissions to sub module of {0}", subCl);
                    }
                    if (md.getModuleType().equals((Object)DOLUtils.ejbType())) {
                        URL[] moduleURLs;
                        for (URL moduleURL : moduleURLs = ((URLClassLoader)subCl).getURLs()) {
                            cl.addURL(moduleURL);
                        }
                        cl.addModuleClassLoader(moduleUri, (ClassLoader)((Object)cl));
                        ((PreDestroy)PreDestroy.class.cast(subCl)).preDestroy();
                        continue;
                    }
                    if (md.getModuleType().equals((Object)DOLUtils.rarType())) {
                        embeddedConnCl.addDelegate((DelegatingClassLoader.ClassFinder)subCl);
                        cl.addModuleClassLoader(moduleUri, subCl);
                        continue;
                    }
                    Boolean isTempClassLoader = (Boolean)context.getTransientAppMetaData("isTempClassLoader", Boolean.class);
                    if (subCl instanceof URLClassLoader && isTempClassLoader != null && isTempClassLoader.booleanValue()) {
                        URL[] moduleURLs;
                        for (URL moduleURL : moduleURLs = ((URLClassLoader)subCl).getURLs()) {
                            cl.addURL(moduleURL);
                        }
                    }
                    cl.addModuleClassLoader(moduleUri, subCl);
                }
                finally {
                    if (sub == null) continue;
                    sub.close();
                }
            }
            catch (IOException e) {
                _logger.log(Level.SEVERE, strings.get("noClassLoader", new Object[]{moduleUri}), e);
            }
        }
        return cl;
    }

    protected void processEEPermissions(DeploymentContext dc) {
        EarEEPermissionsProcessor eePp = new EarEEPermissionsProcessor(dc);
        this.eeGarntsMap = eePp.getAllAdjustedEEPermission();
    }

    private void addEEOrDeclaredPermissions(ClassLoader cloader, final PermissionCollection pc, final boolean isEEPermission) {
        if (!(cloader instanceof DDPermissionsLoader)) {
            return;
        }
        final DDPermissionsLoader ddpl = (DDPermissionsLoader)cloader;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SecurityException {
                    if (isEEPermission) {
                        ddpl.addEEPermissions(pc);
                    } else {
                        ddpl.addDeclaredPermissions(pc);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new SecurityException(e.getException());
        }
    }

    public boolean accept(ReadableArchive source, String entryName) {
        return entryName.startsWith("META-INF");
    }

    public void initCompositeMetaData(DeploymentContext context) {
        this.getApplicationHolder(context.getSource(), context, true);
    }

    private ApplicationHolder getApplicationHolder(ReadableArchive source, DeploymentContext context, boolean isDirectory) {
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (holder == null || holder.app == null) {
            try {
                DeployCommandParameters params = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
                if (params != null && params.altdd != null) {
                    source.addArchiveMetaData("altdd", (Object)params.altdd);
                }
                long start = System.currentTimeMillis();
                ApplicationArchivist archivist = (ApplicationArchivist)this.habitat.getService(ApplicationArchivist.class, new Annotation[0]);
                archivist.setAnnotationProcessingRequested(true);
                String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
                archivist.setXMLValidationLevel(xmlValidationLevel);
                if (xmlValidationLevel.equals("none")) {
                    archivist.setXMLValidation(false);
                }
                holder = new ApplicationHolder(archivist.createApplication(source, isDirectory));
                _logger.fine("time to read application.xml " + (System.currentTimeMillis() - start));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            context.addModuleMetaData((Object)holder);
        }
        if (holder.app == null) {
            throw new RuntimeException(strings.get("errReadMetadata"));
        }
        return holder;
    }

    private ArchiveHandler getArchiveHandlerFromModuleType(ArchiveType type) {
        if (type.equals((Object)DOLUtils.warType())) {
            return (ArchiveHandler)this.habitat.getService(ArchiveHandler.class, "war", new Annotation[0]);
        }
        if (type.equals((Object)DOLUtils.rarType())) {
            return (ArchiveHandler)this.habitat.getService(ArchiveHandler.class, "rar", new Annotation[0]);
        }
        if (type.equals((Object)DOLUtils.ejbType())) {
            return (ArchiveHandler)this.habitat.getService(ArchiveHandler.class, "ejb", new Annotation[0]);
        }
        if (type.equals((Object)DOLUtils.carType())) {
            return (ArchiveHandler)this.habitat.getService(ArchiveHandler.class, "car", new Annotation[0]);
        }
        return null;
    }

    private static class GFApplicationXmlParser {
        private XMLStreamReader parser;
        private String compatValue;

        GFApplicationXmlParser(ReadableArchive archive) throws FileNotFoundException, IOException {
            InputStream input = null;
            File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
            if (runtimeAltDDFile != null && runtimeAltDDFile.getPath().indexOf("glassfish-") != -1 && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile()) {
                DOLUtils.validateRuntimeAltDDPath((String)runtimeAltDDFile.getPath());
                input = new FileInputStream(runtimeAltDDFile);
            } else {
                input = archive.getEntry("META-INF/glassfish-application.xml");
            }
            if (input != null) {
                try {
                    this.read(input);
                }
                catch (Throwable t) {
                    String msg = localStrings.getLocalString("exception_parsing_glassfishapplicationxml", "Error in parsing sun-application.xml for archive [{0}]: {1}", new Object[]{archive.getURI(), t.getMessage()});
                    throw new RuntimeException(msg);
                }
                finally {
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String extractVersionIdentifierValue(ReadableArchive archive) throws XMLStreamException, IOException {
            InputStream input = null;
            String versionIdentifierValue = null;
            try {
                File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
                if (runtimeAltDDFile != null && runtimeAltDDFile.getPath().indexOf("glassfish-") != -1 && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile()) {
                    DOLUtils.validateRuntimeAltDDPath((String)runtimeAltDDFile.getPath());
                    input = new FileInputStream(runtimeAltDDFile);
                } else {
                    input = archive.getEntry("META-INF/glassfish-application.xml");
                }
                if (input != null) {
                    this.parser = EarHandler.getXMLInputFactory().createXMLStreamReader(input);
                    int event = 0;
                    this.skipRoot("glassfish-application");
                    while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                        if (event != 1) continue;
                        String name = this.parser.getLocalName();
                        if ("version-identifier".equals(name)) {
                            versionIdentifierValue = this.parser.getElementText();
                            continue;
                        }
                        this.skipSubTree(name);
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return versionIdentifierValue;
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = EarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean done = false;
            this.skipRoot("glassfish-application");
            while (!done && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("compatibility".equals(name)) {
                    this.compatValue = this.parser.getElementText();
                    done = true;
                    continue;
                }
                this.skipSubTree(name);
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getCompatibilityValue() {
            return this.compatValue;
        }
    }

    private static class SunApplicationXmlParser {
        private XMLStreamReader parser = null;
        private String compatValue = null;

        SunApplicationXmlParser(File baseDir) throws FileNotFoundException {
            FileInputStream input = null;
            File f = new File(baseDir, "META-INF/sun-application.xml");
            if (f.exists()) {
                input = new FileInputStream(f);
                try {
                    this.read(input);
                }
                catch (Throwable t) {
                    String msg = localStrings.getLocalString("exception_parsing_sunapplicationxml", "Error in parsing glassfish-application.xml for archive [{0}]: {1}", new Object[]{baseDir.getPath(), t.getMessage()});
                    throw new RuntimeException(msg);
                }
                finally {
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = EarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean done = false;
            this.skipRoot("sun-application");
            while (!done && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("compatibility".equals(name)) {
                    this.compatValue = this.parser.getElementText();
                    done = true;
                    continue;
                }
                this.skipSubTree(name);
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getCompatibilityValue() {
            return this.compatValue;
        }
    }
}

