/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbAsyncInvocationManager;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbThreadPoolExecutor;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.EjbTimerService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.ejb.api.DistributedEJBTimerService;
import org.glassfish.ejb.spi.CMPDeployer;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class EjbContainerUtilImpl
implements PostConstruct,
PreDestroy,
EjbContainerUtil {
    private Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private ThreadPoolExecutor defaultThreadPoolExecutor;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerContext serverContext;
    private volatile boolean _ejbTimerServiceVerified = false;
    private boolean _ejbTimersCleanup = false;
    private volatile boolean _doDBReadBeforeTimeout = false;
    private static Object lock = new Object();
    private volatile EJBTimerService _ejbTimerService;
    private Map<Long, BaseContainer> id2Container = new ConcurrentHashMap<Long, BaseContainer>();
    private Timer _timer;
    private boolean _insideContainer = true;
    @Inject
    private InvocationManager _invManager;
    @Inject
    private InjectionManager _injectionManager;
    @Inject
    private GlassfishNamingManager _gfNamingManager;
    @Inject
    private ComponentEnvManager _compEnvManager;
    @Inject
    private JavaEETransactionManager txMgr;
    @Inject
    private EjbContainer ejbContainer;
    @Inject
    private GlassFishORBHelper orbHelper;
    @Inject
    private ServerEnvironmentImpl env;
    @Inject(optional=true)
    private Agent callFlowAgent;
    @Inject
    private EJBServerConfigLookup ejbServerConfigLookup;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private EjbAsyncInvocationManager ejbAsyncInvocationManager;
    @Inject
    ProbeProviderFactory probeProviderFactory;
    @Inject
    Domain domain;
    private static EjbContainerUtil _me;

    public String getHAPersistenceType() {
        return this.ejbServerConfigLookup.getSfsbHaPersistenceTypeFromConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postConstruct() {
        block5: {
            ClassLoader ejbImplClassLoader = EjbContainerUtilImpl.class.getClassLoader();
            if (this.callFlowAgent == null) {
                this.callFlowAgent = (Agent)Proxy.newProxyInstance(ejbImplClassLoader, new Class[]{Agent.class}, new InvocationHandler(){

                    public Object invoke(Object proxy, Method m, Object[] args) {
                        return null;
                    }
                });
            }
            this.defaultThreadPoolExecutor = this.createThreadPoolExecutor("__ejb-thread-pool");
            if (!this.isDas()) {
                this._doDBReadBeforeTimeout = true;
            }
            ClassLoader originalClassLoader = null;
            try {
                originalClassLoader = Utility.setContextClassLoader((ClassLoader)ejbImplClassLoader);
                this._timer = new Timer(true);
                Object var4_3 = null;
                if (originalClassLoader == null) break block5;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (originalClassLoader != null) {
                    Utility.setContextClassLoader((ClassLoader)originalClassLoader);
                }
                throw throwable;
            }
            Utility.setContextClassLoader((ClassLoader)originalClassLoader);
        }
        _me = this;
    }

    public void preDestroy() {
        if (this.defaultThreadPoolExecutor != null) {
            this.defaultThreadPoolExecutor.shutdown();
            this.defaultThreadPoolExecutor = null;
        }
    }

    public GlassFishORBHelper getORBHelper() {
        return this.orbHelper;
    }

    public Habitat getDefaultHabitat() {
        return this.habitat;
    }

    public static boolean isInitialized() {
        return _me != null;
    }

    public static EjbContainerUtil getInstance() {
        if (_me == null) {
            _me = (EjbContainerUtil)Globals.getDefaultHabitat().getComponent(EjbContainerUtilImpl.class);
            _me.getLogger().log(Level.WARNING, "Internal error: EJBContainerUtilImpl was null", new Throwable());
        }
        return _me;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setEJBTimerService(EJBTimerService es) {
        this._ejbTimerService = es;
    }

    public void unsetEJBTimerService() {
        this._ejbTimerServiceVerified = false;
        this._ejbTimerService = null;
    }

    public EJBTimerService getEJBTimerService() {
        return this.getEJBTimerService(null);
    }

    public boolean isEJBTimerServiceLoaded() {
        return this._ejbTimerServiceVerified;
    }

    public void setEJBTimerServiceDBReadBeforeTimeout(boolean value) {
        this._doDBReadBeforeTimeout = value;
        if (this._ejbTimerService != null) {
            this._ejbTimerService.setPerformDBReadBeforeTimeout(value);
        }
    }

    public EJBTimerService getEJBTimerService(String target) {
        return this.getEJBTimerService(target, true);
    }

    public EJBTimerService getEJBTimerService(String target, boolean force) {
        if (!this._ejbTimerServiceVerified) {
            this.deployEJBTimerService(target);
            if (this._ejbTimerService != null) {
                this.habitat.getByContract(DistributedEJBTimerService.class);
                if (this._ejbTimersCleanup) {
                    this._ejbTimerService.destroyAllTimers(0L);
                } else if (target == null) {
                    this._logger.log(Level.INFO, "Setting DBReadBeforeTimeout to " + this._doDBReadBeforeTimeout);
                    this._ejbTimerService.setPerformDBReadBeforeTimeout(this._doDBReadBeforeTimeout);
                    this._logger.log(Level.INFO, "==> Restoring Timers ... ");
                    if (this._ejbTimerService.restoreEJBTimers()) {
                        this._logger.log(Level.INFO, "<== ... Timers Restored.");
                    }
                }
            } else if (!force) {
                this._ejbTimerServiceVerified = false;
            }
        }
        return this._ejbTimerService;
    }

    public void registerContainer(BaseContainer container) {
        this.id2Container.put(container.getContainerId(), container);
    }

    public void unregisterContainer(BaseContainer container) {
        this.id2Container.remove(container.getContainerId());
    }

    public BaseContainer getContainer(long id) {
        return this.id2Container.get(id);
    }

    public EjbDescriptor getDescriptor(long id) {
        BaseContainer container = this.id2Container.get(id);
        return container != null ? container.getEjbDescriptor() : null;
    }

    public ClassLoader getClassLoader(long id) {
        BaseContainer container = this.id2Container.get(id);
        return container != null ? container.getClassLoader() : null;
    }

    public Timer getTimer() {
        return this._timer;
    }

    public void setInsideContainer(boolean bool) {
        this._insideContainer = bool;
    }

    public boolean isInsideContainer() {
        return this._insideContainer;
    }

    public InvocationManager getInvocationManager() {
        return this._invManager;
    }

    public InjectionManager getInjectionManager() {
        return this._injectionManager;
    }

    public GlassfishNamingManager getGlassfishNamingManager() {
        return this._gfNamingManager;
    }

    public ComponentEnvManager getComponentEnvManager() {
        return this._compEnvManager;
    }

    public ComponentInvocation getCurrentInvocation() {
        return this._invManager.getCurrentInvocation();
    }

    public JavaEETransactionManager getTransactionManager() {
        return this.txMgr;
    }

    public ServerContext getServerContext() {
        return this.serverContext;
    }

    public EjbAsyncInvocationManager getEjbAsyncInvocationManager() {
        return this.ejbAsyncInvocationManager;
    }

    private TxData getTxData(JavaEETransaction tx) {
        TxData txData = (TxData)tx.getContainerData();
        if (txData == null) {
            txData = new TxData();
            tx.setContainerData((Object)txData);
        }
        return txData;
    }

    public ContainerSynchronization getContainerSync(Transaction jtx) throws RollbackException, SystemException {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        if (txData.sync == null) {
            txData.sync = new ContainerSynchronization((Transaction)tx, this);
            tx.registerSynchronization((Synchronization)txData.sync);
        }
        return txData.sync;
    }

    public void removeContainerSync(Transaction tx) {
    }

    public void registerPMSync(Transaction jtx, Synchronization sync) throws RollbackException, SystemException {
        this.getContainerSync(jtx).addPMSynchronization(sync);
    }

    public EjbContainer getEjbContainer() {
        return this.ejbContainer;
    }

    public ServerEnvironmentImpl getServerEnvironment() {
        return this.env;
    }

    public Vector getBeans(Transaction jtx) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        if (txData.beans == null) {
            txData.beans = new Vector();
        }
        return txData.beans;
    }

    public Object getActiveTxCache(Transaction jtx) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        return txData.activeTxCache;
    }

    public void setActiveTxCache(Transaction jtx, Object cache) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        txData.activeTxCache = cache;
    }

    public Agent getCallFlowAgent() {
        return this.callFlowAgent;
    }

    public void addWork(Runnable task) {
        this.defaultThreadPoolExecutor.submit(task);
    }

    public EjbDescriptor ejbIdToDescriptor(long ejbId) {
        throw new RuntimeException("Not supported yet");
    }

    public boolean isEJBLite() {
        return this.habitat.getByContract(CMPDeployer.class) == null;
    }

    public boolean isEmbeddedServer() {
        return this.processEnv.getProcessType().isEmbedded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deployEJBTimerService(String target) {
        block19: {
            Object object = lock;
            synchronized (object) {
                Deployment deployment = (Deployment)this.habitat.getByContract(Deployment.class);
                boolean isRegistered = deployment.isRegistered("ejb-timer-service-app");
                if (isRegistered) {
                    this._logger.log(Level.WARNING, "EJBTimerService had been explicitly deployed.");
                } else {
                    this._logger.log(Level.INFO, "Loading EJBTimerService. Please wait.");
                    File root = this.serverContext.getInstallRoot();
                    File app = null;
                    try {
                        app = FileUtils.getManagedFile((String)"ejb-timer-service-app.war", (File)new File(root, "lib/install/applications/"));
                    }
                    catch (Exception e) {
                        this._logger.log(Level.WARNING, "Caught unexpected exception", e);
                    }
                    if (app == null || !app.exists()) {
                        this._logger.log(Level.WARNING, "Cannot deploy or load EJBTimerService: required WAR file (ejb-timer-service-app.war) is not installed");
                    } else {
                        String appName;
                        ActionReport report = (ActionReport)this.habitat.getComponent(ActionReport.class, "plain");
                        DeployCommandParameters params = new DeployCommandParameters(app);
                        params.name = appName = "ejb-timer-service-app";
                        File rootScratchDir = this.env.getApplicationStubPath();
                        File appScratchFile = new File(rootScratchDir, appName);
                        try {
                            block18: {
                                try {
                                    String resourceName = this.getTimerResource(target);
                                    if (resourceName != null) {
                                        params.origin = this.isDas() && !this.isUpgrade(resourceName, target, appScratchFile.exists()) & appScratchFile.createNewFile() ? OpsParams.Origin.deploy : OpsParams.Origin.load;
                                        params.target = this.env.getInstanceName();
                                        ExtendedDeploymentContext dc = deployment.getBuilder(this._logger, (OpsParams)params, report).source(app).build();
                                        dc.addTransientAppMetaData("org.glassfish.jta.datasource.jndi.name", (Object)resourceName);
                                        Properties appProps = dc.getAppProps();
                                        appProps.setProperty("object-type", "system-all");
                                        deployment.deploy(dc);
                                        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                                            this._logger.log(Level.WARNING, "Cannot deploy or load EJBTimerService: ", report.getFailureCause());
                                            break block18;
                                        } else {
                                            this._logger.log(Level.INFO, "ejb.timer_service_started", new Object[]{resourceName});
                                        }
                                        break block18;
                                    }
                                    this._logger.log(Level.WARNING, "Cannot start EJBTimerService: Timer resource for target " + target + " is not available");
                                }
                                catch (Exception e) {
                                    this._logger.log(Level.WARNING, "Cannot deploy or load EJBTimerService: ", e);
                                    Object var16_18 = null;
                                    if (this._ejbTimerService == null && params.origin.isDeploy() && appScratchFile.exists()) {
                                        appScratchFile.delete();
                                    }
                                    break block19;
                                }
                            }
                            Object var16_17 = null;
                            if (this._ejbTimerService != null) break block19;
                        }
                        catch (Throwable throwable) {
                            Object var16_19 = null;
                            if (this._ejbTimerService == null && params.origin.isDeploy() && appScratchFile.exists()) {
                                appScratchFile.delete();
                            }
                            throw throwable;
                        }
                        if (params.origin.isDeploy() && appScratchFile.exists()) {
                            appScratchFile.delete();
                        }
                    }
                }
            }
        }
        this._ejbTimerServiceVerified = true;
    }

    private boolean isUpgrade(String resource, String target, boolean upgrade_with_load) {
        List properties;
        boolean upgrade = false;
        Property prop = null;
        EjbTimerService ejbt = this.getEjbTimerService(target);
        if (ejbt != null && (properties = ejbt.getProperty()) != null) {
            for (Property p : properties) {
                String value;
                if (!p.getName().equals("ejb-timer-service-upgraded") || (value = p.getValue()) == null || !"false".equals(value)) continue;
                upgrade = true;
                prop = p;
                break;
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("===> Upgrade? <==");
        }
        if (upgrade) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("===> Upgrade! <==");
            }
            boolean success = false;
            try {
                File root = this.serverContext.getInstallRoot();
                File dir = new File(root, "lib/install/databases/upgrade");
                if (!dir.exists()) {
                    this._logger.log(Level.WARNING, "Cannot upgrade EJBTimerService: required directory is not available");
                } else {
                    Java2DBProcessorHelper h = new Java2DBProcessorHelper("ejb-timer-service-app");
                    success = h.executeDDLStatement(dir.getCanonicalPath() + "/ejbtimer_upgrade_", resource);
                    this._ejbTimersCleanup = !upgrade_with_load;
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Property>(){

                        public Object run(Property p) throws PropertyVetoException, TransactionFailure {
                            p.setValue("true");
                            return null;
                        }
                    }, (ConfigBeanProxy)prop);
                }
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "", e);
            }
            if (!success) {
                this._logger.log(Level.SEVERE, "Failed to upgrade load EJBTimerService: see log for details");
            }
        }
        return upgrade;
    }

    public String getTimerResource() {
        return this.getTimerResource(null);
    }

    private String getTimerResource(String target) {
        String resource = null;
        EjbTimerService ejbt = this.getEjbTimerService(target);
        if (ejbt != null) {
            if (ejbt.getTimerDatasource() != null) {
                resource = ejbt.getTimerDatasource();
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Found Timer Service resource name " + resource);
                }
            } else {
                resource = "jdbc/__TimerPool";
            }
        }
        return resource;
    }

    private EjbTimerService getEjbTimerService(String target) {
        EjbTimerService ejbt = null;
        if (target == null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Looking for current instance ejb-container config");
            }
            ejbt = this.getEjbContainer().getEjbTimerService();
        } else {
            ReferenceContainer rc;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Looking for " + target + " ejb-container config");
            }
            if ((rc = this.domain.getReferenceContainerNamed(target)) != null) {
                Config config = this.domain.getConfigNamed(rc.getReference());
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Found " + config);
                }
                if (config != null) {
                    ejbt = config.getEjbContainer().getEjbTimerService();
                }
            }
        }
        return ejbt;
    }

    public ProbeProviderFactory getProbeProviderFactory() {
        return this.probeProviderFactory;
    }

    public boolean isDas() {
        return this.env.isDas() || this.env.isEmbedded();
    }

    private ThreadPoolExecutor createThreadPoolExecutor(String poolName) {
        EjbThreadPoolExecutor result = null;
        String val = this.ejbContainer.getPropertyValue("thread-core-pool-size");
        int corePoolSize = val != null ? Integer.parseInt(val.trim()) : 16;
        val = this.ejbContainer.getPropertyValue("thread-max-pool-size");
        int maxPoolSize = val != null ? Integer.parseInt(val.trim()) : 32;
        val = this.ejbContainer.getPropertyValue("thread-keep-alive-seconds");
        long keepAliveSeconds = val != null ? Long.parseLong(val.trim()) : 60L;
        val = this.ejbContainer.getPropertyValue("thread-queue-capacity");
        int queueCapacity = val != null ? Integer.parseInt(val.trim()) : Integer.MAX_VALUE;
        val = this.ejbContainer.getPropertyValue("allow-core-thread-timeout");
        boolean allowCoreThreadTimeout = val != null ? Boolean.parseBoolean(val.trim()) : false;
        val = this.ejbContainer.getPropertyValue("prestart-all-core-threads");
        boolean preStartAllCoreThreads = val != null ? Boolean.parseBoolean(val.trim()) : false;
        LinkedBlockingQueue<Runnable> workQueue = queueCapacity > 0 ? new LinkedBlockingQueue(queueCapacity) : new SynchronousQueue(true);
        result = new EjbThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveSeconds, workQueue, poolName);
        if (allowCoreThreadTimeout) {
            result.allowCoreThreadTimeOut(true);
        }
        if (preStartAllCoreThreads) {
            result.prestartAllCoreThreads();
        }
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.info("Created " + ((Object)result).toString());
        }
        return result;
    }

    public ThreadPoolExecutor getThreadPoolExecutor(String poolName) {
        if (poolName == null) {
            return this.defaultThreadPoolExecutor;
        }
        return null;
    }

    private static class TxData {
        ContainerSynchronization sync;
        Vector beans;
        Object activeTxCache;

        private TxData() {
        }
    }
}

