/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.EjbAsyncTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EjbThreadPoolExecutor
extends ThreadPoolExecutor {
    public EjbThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQueue, String threadPoolName) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, workQueue, new ThreadFactoryImpl(threadPoolName));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof EjbAsyncTask) {
            return ((EjbAsyncTask)callable).getFutureTask();
        }
        return super.newTaskFor(callable);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("EjbThreadPoolExecutor with ");
        sb.append("thread-core-pool-size").append(" ").append(this.getCorePoolSize()).append(" ");
        sb.append("thread-max-pool-size").append(" ").append(this.getMaximumPoolSize()).append(" ");
        sb.append("thread-keep-alive-seconds").append(" ").append(this.getKeepAliveTime(TimeUnit.SECONDS)).append(" ");
        sb.append("thread-queue-capacity").append(" ").append(this.getQueue().remainingCapacity()).append(" ");
        sb.append("allow-core-thread-timeout").append(" ").append(this.allowsCoreThreadTimeOut()).append(" ");
        return sb.toString();
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        private AtomicInteger threadId = new AtomicInteger(0);
        private String threadPoolName;

        public ThreadFactoryImpl(String threadPoolName) {
            this.threadPoolName = threadPoolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.threadPoolName + this.threadId.incrementAndGet());
            th.setDaemon(true);
            th.setContextClassLoader(null);
            return th;
        }
    }
}

