/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import jakarta.ejb.EJBException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.ModuleExploder;
import org.glassfish.embeddable.archive.ScatteredArchive;

public class DeploymentElement {
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private File element;
    private boolean isEJBModule;
    private boolean isWebApp = false;
    private String mname = null;

    DeploymentElement(File element, boolean isEJBModule, String mname) {
        this.element = element;
        this.isEJBModule = isEJBModule;
        this.mname = mname;
        if (element.isFile()) {
            this.isWebApp = element.getName().endsWith(".war");
        } else {
            List<String> files = Arrays.asList(element.list());
            this.isWebApp = files.contains("WEB-INF");
        }
    }

    File getElement() {
        return this.element;
    }

    boolean isEJBModule() {
        return this.isEJBModule;
    }

    boolean isWebApp() {
        return this.isWebApp;
    }

    public static boolean hasEJBModule(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (!module.isEJBModule) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWar(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (!module.isWebApp) continue;
            return true;
        }
        return false;
    }

    public static DeploymentElement getWar(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (!module.isWebApp) continue;
            return module;
        }
        return null;
    }

    public static boolean hasLibrary(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (module.isEJBModule) continue;
            return true;
        }
        return false;
    }

    public static int countEJBModules(Set<DeploymentElement> modules) {
        int result = 0;
        for (DeploymentElement module : modules) {
            if (!module.isEJBModule) continue;
            ++result;
        }
        return result;
    }

    public static ResultApplication getOrCreateApplication(Set<DeploymentElement> modules, String appName) throws EJBException, IOException {
        File result = null;
        boolean deleteOnExit = false;
        if (modules == null || modules.size() == 0 || !DeploymentElement.hasEJBModule(modules)) {
            _logger.severe("[DeploymentElement] No modules found");
        } else if (appName == null && DeploymentElement.countEJBModules(modules) == 1) {
            if (modules.size() == 1) {
                result = modules.iterator().next().getElement();
            } else if (DeploymentElement.countEJBModules(modules) == 1 && DeploymentElement.hasWar(modules)) {
                result = DeploymentElement.getWar(modules).getElement();
            } else {
                ScatteredArchive sa = null;
                for (DeploymentElement m : modules) {
                    if (!m.isEJBModule) continue;
                    sa = new ScatteredArchive(m.mname, ScatteredArchive.Type.JAR);
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info("[DeploymentElement] adding EJB module to ScatteredArchive " + m.mname);
                    }
                    sa.addClassPath(m.element);
                    break;
                }
                if (sa != null) {
                    for (DeploymentElement m : modules) {
                        if (m.isEJBModule) continue;
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("[DeploymentElement] adding library to ScatteredArchive " + m.element.getName());
                        }
                        sa.addClassPath(m.element);
                    }
                    result = sa;
                }
            }
        } else {
            File resultFile = File.createTempFile("ejb-app", "");
            File lib = null;
            if (resultFile.delete() && resultFile.mkdirs()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[DeploymentElement] temp dir created at " + resultFile.getAbsolutePath());
                }
                if (DeploymentElement.hasLibrary(modules)) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("[DeploymentElement] lib dir added ... ");
                    }
                    lib = new File(resultFile, "lib");
                }
            } else {
                throw new EJBException("Not able to create temp dir " + resultFile.getAbsolutePath());
            }
            int duplicate_dir_counter = 0;
            for (DeploymentElement m : modules) {
                File out;
                File base;
                int lastpart;
                String filename;
                File f = m.element;
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.info("[DeploymentElement] adding " + f.getName() + " to exploded ear  isEJBModule? " + m.isEJBModule + " isWebApp? " + m.isWebApp);
                }
                if ((filename = f.toURI().getSchemeSpecificPart()).endsWith(File.separator) || filename.endsWith("/")) {
                    int length = filename.length();
                    filename = filename.substring(0, length - 1);
                }
                if ((lastpart = filename.lastIndexOf(File.separatorChar)) == -1) {
                    lastpart = filename.lastIndexOf(47);
                }
                String name = filename.substring(lastpart + 1);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[DeploymentElement] Converted file name: " + filename + " to " + name);
                }
                File file = base = m.isEJBModule ? resultFile : lib;
                if (!f.isDirectory() && m.isEJBModule) {
                    out = new File(base, FileUtils.makeFriendlyFilename((String)name));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("[DeploymentElement] Exploding jar to: " + out);
                    }
                    ModuleExploder.explodeJar((File)f, (File)out);
                    continue;
                }
                if (f.isDirectory()) {
                    name = name + (m.isWebApp ? "_war" : (m.isEJBModule ? "_jar" : ".jar"));
                }
                if ((out = new File(base, name)).exists()) {
                    out = new File(base, "d__" + ++duplicate_dir_counter + "__" + name);
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[DeploymentElement] Copying element to: " + out);
                }
                FileUtils.copy((File)f, (File)out);
            }
            boolean bl = deleteOnExit = !Boolean.getBoolean("org.glassfish.ejb.embedded.keep-temporary-files");
            if (appName == null) {
                appName = "ejb-app";
            }
            result = resultFile;
        }
        return new ResultApplication(result, appName, deleteOnExit);
    }

    protected static class ResultApplication {
        private boolean deleteOnExit = false;
        private Object app = null;
        private String appName = null;

        ResultApplication(Object app) {
            this.app = app;
        }

        ResultApplication(Object app, String appName, boolean deleteOnExit) {
            this.app = app;
            this.appName = appName;
            this.deleteOnExit = deleteOnExit;
        }

        Object getApplication() {
            return this.app;
        }

        String getAppName() {
            return this.appName;
        }

        boolean deleteOnExit() {
            return this.deleteOnExit;
        }
    }
}

