/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.security.EmbeddedSecurity;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.ejb.EJBException;
import jakarta.ejb.embeddable.EJBContainer;
import jakarta.ejb.spi.EJBContainerProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.ejb.deployment.io.EjbDeploymentDescriptorFile;
import org.glassfish.ejb.embedded.DeploymentElement;
import org.glassfish.ejb.embedded.DomainXmlTransformer;
import org.glassfish.ejb.embedded.EJBContainerImpl;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.hk2.api.ServiceLocator;

public class EJBContainerProviderImpl
implements EJBContainerProvider {
    private static final String GF_PROVIDER_NAME = EJBContainerProviderImpl.class.getName();
    private static final String GF_EJB_EMBEDDED_PROPERTY_START = "org.glassfish.ejb.embedded.";
    protected static final String KEEP_TEMPORARY_FILES = "org.glassfish.ejb.embedded.keep-temporary-files";
    private static final String SKIP_CLIENT_MODULES = "org.glassfish.ejb.embedded.skip-client-modules";
    private static final String GF_INSTALLATION_ROOT = "org.glassfish.ejb.embedded.glassfish.installation.root";
    private static final String GF_INSTANCE_ROOT = "org.glassfish.ejb.embedded.glassfish.instance.root";
    private static final String GF_DOMAIN_FILE = "org.glassfish.ejb.embedded.glassfish.configuration.file";
    private static final String GF_INSTANCE_REUSE = "org.glassfish.ejb.embedded.glassfish.instance.reuse";
    private static final String GF_WEB_HTTP_PORT = "org.glassfish.ejb.embedded.glassfish.web.http.port";
    private static final String WEAVING = "org.glassfish.persistence.embedded.weaving.enabled";
    private static final Attributes.Name ATTRIBUTE_NAME_SKIP = new Attributes.Name("Bundle-SymbolicName");
    private static final String[] KNOWN_PACKAGES = new String[]{"org.glassfish.", "com.sun.enterprise.", "org.eclipse.", "org.jboss.weld."};
    private static final String[] ATTRIBUTE_VALUES_OK = new String[]{"sample", "test"};
    private static final Logger _logger = LogDomains.getLogger(EJBContainerProviderImpl.class, (String)"javax.enterprise.system.container.ejb");
    private static final StringManager localStrings = StringManager.getManager(EJBContainerProviderImpl.class);
    private static final Object lock = new Object();
    private static EJBContainerImpl container;
    private static GlassFishRuntime runtime;
    private static ArchiveFactory archiveFactory;
    private static Class[] ejbAnnotations;

    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        if (properties == null || properties.get("jakarta.ejb.embeddable.provider") == null || properties.get("jakarta.ejb.embeddable.provider").equals(GF_PROVIDER_NAME)) {
            if (container != null && container.isOpen()) {
                throw new EJBException(localStrings.getString("ejb.embedded.exception_exists_container"));
            }
            boolean ok = false;
            Locations l = this.getLocations(properties);
            try {
                this.createContainer(properties, l);
                Set<DeploymentElement> modules = this.addModules(properties, l);
                if (!DeploymentElement.hasEJBModule(modules)) {
                    _logger.log(Level.SEVERE, "ejb.embedded.no_modules_found");
                } else {
                    container.deploy(properties, modules);
                }
                ok = true;
                EJBContainerImpl eJBContainerImpl = container;
                return eJBContainerImpl;
            }
            catch (EJBException e) {
                throw e;
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "ejb.embedded.exception_instantiating", t);
                throw new EJBException(t.getMessage());
            }
            finally {
                if (!ok && container != null) {
                    try {
                        _logger.info("[EJBContainerProviderImpl] Cleaning up on failure ...");
                        container.close();
                    }
                    catch (Throwable t1) {
                        _logger.info("[EJBContainerProviderImpl] Error cleaning up..." + t1);
                    }
                    container = null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Locations createContainer(Map<?, ?> properties, Locations l) throws EJBException {
        Object object = lock;
        synchronized (object) {
            try {
                if (runtime != null) {
                    runtime.shutdown();
                }
                BootstrapProperties bootstrapProperties = new BootstrapProperties();
                Properties newProps = new Properties();
                if (properties != null) {
                    this.copyUserProperties(properties, newProps);
                }
                if (newProps.getProperty(WEAVING) == null) {
                    newProps.setProperty(WEAVING, "false");
                }
                GlassFishProperties glassFishProperties = new GlassFishProperties(newProps);
                if (Boolean.getBoolean(KEEP_TEMPORARY_FILES)) {
                    glassFishProperties.setProperty("org.glassfish.embeddable.autoDelete", "false");
                    glassFishProperties.setConfigFileReadOnly(false);
                }
                if (l.installed_root != null && l.instance_root != null) {
                    _logger.info("[EJBContainerProviderImpl] Using installation location " + l.installed_root.getCanonicalPath());
                    bootstrapProperties.setInstallRoot(l.installed_root.getCanonicalPath());
                }
                if (l.instance_root != null && l.reuse_instance_location) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("[EJBContainerProviderImpl] Reusing instance location at: " + l.instance_root);
                    }
                    _logger.info("[EJBContainerProviderImpl] Using instance location: " + l.instance_root.getCanonicalPath());
                    glassFishProperties.setInstanceRoot(l.instance_root.getCanonicalPath());
                } else if (l.domain_file != null) {
                    _logger.info("[EJBContainerProviderImpl] Using config file location: " + l.domain_file.toURI().toString());
                    glassFishProperties.setConfigFileURI(l.domain_file.toURI().toString());
                }
                this.addWebContainerIfRequested(properties, glassFishProperties);
                runtime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapProperties);
                _logger.info("[EJBContainerProviderImpl] Using runtime class: " + runtime.getClass());
                GlassFish server = runtime.newGlassFish(glassFishProperties);
                if (l.instance_root != null && !l.reuse_instance_location) {
                    server.start();
                    EmbeddedSecurity es = (EmbeddedSecurity)server.getService(EmbeddedSecurity.class);
                    ServiceLocator habitat = (ServiceLocator)server.getService(ServiceLocator.class);
                    server.stop();
                    if (es != null) {
                        es.copyConfigFiles(habitat, l.instance_root, l.domain_file);
                    }
                }
                container = new EJBContainerImpl(server);
                this.validateInstanceDirectory();
                archiveFactory = (ArchiveFactory)server.getService(ArchiveFactory.class);
                Sniffer sniffer = (Sniffer)server.getService(Sniffer.class, "Ejb");
                ejbAnnotations = sniffer.getAnnotationTypes();
            }
            catch (Exception e) {
                try {
                    if (container != null) {
                        container.stop();
                    }
                }
                catch (Exception e0) {
                    _logger.log(Level.SEVERE, e0.getMessage(), e0);
                }
                container = null;
                throw new EJBException(e);
            }
        }
        return l;
    }

    private Set<DeploymentElement> addModules(Map<?, ?> properties, Locations l) {
        HashSet<DeploymentElement> modules = new HashSet<DeploymentElement>();
        Object obj = properties == null ? null : properties.get("jakarta.ejb.embeddable.modules");
        boolean skip_module_with_main_class = this.getBooleanProperty(properties, SKIP_CLIENT_MODULES);
        HashMap<String, Boolean> moduleNames = new HashMap<String, Boolean>();
        if (obj != null) {
            Object[] arr;
            if (obj instanceof String) {
                moduleNames.put(obj, false);
            } else if (obj instanceof String[]) {
                arr = obj;
                for (Object s : arr) {
                    moduleNames.put((String)s, false);
                }
            } else if (obj instanceof File) {
                this.addModule(l, modules, moduleNames, obj);
            } else if (obj instanceof File[]) {
                arr = obj;
                for (Object f : arr) {
                    this.addModule(l, modules, moduleNames, (File)f);
                }
            }
        }
        if (modules.isEmpty()) {
            String[] entries;
            String path = System.getProperty("java.class.path");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[EJBContainerProviderImpl] Looking for EJB modules in classpath: " + path);
            }
            for (String s0 : entries = path.split(File.pathSeparator)) {
                this.addModule(l, modules, moduleNames, new File(s0), skip_module_with_main_class);
            }
            if (!moduleNames.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (Map.Entry entry : moduleNames.entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue()) continue;
                    sb.append((String)entry.getKey()).append(", ");
                }
                int ln = sb.length();
                if (ln > 0) {
                    throw new EJBException("Modules: [" + sb.substring(0, ln - 2) + "] do not match an entry in the classpath");
                }
            }
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentElement getRequestedEJBModuleOrLibrary(File file, Map<String, Boolean> moduleNames) throws Exception {
        DeploymentElement result = null;
        String fileName = file.getName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("... Testing ... " + fileName);
        }
        ReadableArchive archive = null;
        InputStream is = null;
        try {
            boolean isEJBModule = false;
            String moduleName = DeploymentUtils.getDefaultEEName((String)fileName);
            archive = archiveFactory.openArchive(file);
            is = this.getDeploymentDescriptor(archive);
            if (is != null) {
                isEJBModule = true;
                EjbDeploymentDescriptorFile eddf = new EjbDeploymentDescriptorFile();
                eddf.setXMLValidation(false);
                EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)eddf.read(is);
                ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
                moduleDesc.setArchiveUri(fileName);
                moduleName = moduleDesc.getModuleName();
            } else {
                GenericAnnotationDetector detector = new GenericAnnotationDetector(ejbAnnotations);
                isEJBModule = detector.hasAnnotationInArchive(archive);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("... is EJB module: " + isEJBModule);
                if (isEJBModule) {
                    _logger.fine("... is Requested EJB module [" + moduleName + "]: " + (moduleNames.isEmpty() || moduleNames.containsKey(moduleName)));
                }
            }
            if (!isEJBModule || moduleNames.isEmpty()) {
                result = new DeploymentElement(file, isEJBModule, moduleName);
            } else if (moduleNames.containsKey(moduleName) && !moduleNames.get(moduleName).booleanValue()) {
                result = new DeploymentElement(file, isEJBModule, moduleName);
                moduleNames.put(moduleName, true);
            }
            DeploymentElement deploymentElement = result;
            return deploymentElement;
        }
        finally {
            if (archive != null) {
                archive.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private void addModule(Locations l, Set<DeploymentElement> modules, Map<String, Boolean> moduleNames, File f) {
        this.addModule(l, modules, moduleNames, f, false);
    }

    private void addModule(Locations l, Set<DeploymentElement> modules, Map<String, Boolean> moduleNames, File f, boolean skip_module_with_main_class) {
        try {
            DeploymentElement de;
            if (f.exists() && !this.skipJar(f, l, skip_module_with_main_class) && (de = this.getRequestedEJBModuleOrLibrary(f, moduleNames)) != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("... Added " + (de.isEJBModule() ? "EJB Module" : "library") + " .... " + de.getElement().getName());
                }
                modules.add(de);
            }
        }
        catch (Exception ioe) {
            _logger.log(Level.FINE, "ejb.embedded.io_exception", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean skipJar(File file, Locations l, boolean skip_module_with_main_class) throws Exception {
        if (file.isDirectory()) {
            if (!skip_module_with_main_class) {
                return false;
            }
            File m_file = new File(file, "META-INF/MANIFEST.MF");
            if (!m_file.exists()) {
                return false;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(m_file);
                if (this.containsMainClass(new Manifest(is))) {
                    _logger.info("... skipping entry with a Manifest file with a Main-Class attribute: " + file.getName());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ex) {
                        _logger.log(Level.FINE, "Exception while closing Manifest file under " + file + ": ", ex);
                    }
                }
            }
        }
        if (l.modules_dir != null && l.modules_dir.equals(file.getAbsoluteFile().getParentFile().getAbsolutePath())) {
            _logger.info("... skipping module: " + file.getName());
            return true;
        }
        JarFile jf = null;
        try {
            jf = new JarFile(file);
            Manifest m = jf.getManifest();
            if (m != null) {
                if (skip_module_with_main_class && this.containsMainClass(m)) {
                    _logger.info("... skipping entry with a Manifest file with a Main-Class attribute: " + file.getName());
                    boolean bl = true;
                    return bl;
                }
                Attributes attributes = m.getMainAttributes();
                String value = attributes.getValue(ATTRIBUTE_NAME_SKIP);
                if (value != null) {
                    for (String skipValue : KNOWN_PACKAGES) {
                        if (!value.startsWith(skipValue)) continue;
                        for (String okValue : ATTRIBUTE_VALUES_OK) {
                            if (value.indexOf(okValue) <= 0) continue;
                            boolean bl = false;
                            return bl;
                        }
                        _logger.info("... skipping entry with a Manifest file with a special attribute: " + file.getName());
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException ex) {
                    _logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
                }
            }
        }
        return false;
    }

    private File getValidFile(String location, String msg_key) {
        File f = new File(location);
        if (!f.exists()) {
            _logger.log(Level.WARNING, msg_key, location);
            f = null;
        }
        return f;
    }

    private boolean containsMainClass(Manifest m) {
        if (m != null) {
            Attributes attributes = m.getMainAttributes();
            String value = attributes.getValue(Attributes.Name.MAIN_CLASS);
            return value != null && value.length() > 0;
        }
        return false;
    }

    private Locations getLocations(Map<?, ?> properties) throws EJBException {
        String installed_root_location = null;
        String instance_root_location = null;
        String domain_file_location = null;
        File installed_root = null;
        File instance_root = null;
        File domain_file = null;
        boolean reuse_instance_location = false;
        if (properties != null) {
            installed_root_location = (String)properties.get(GF_INSTALLATION_ROOT);
            instance_root_location = (String)properties.get(GF_INSTANCE_ROOT);
            domain_file_location = (String)properties.get(GF_DOMAIN_FILE);
            reuse_instance_location = this.getBooleanProperty(properties, GF_INSTANCE_REUSE);
        }
        if (installed_root_location == null) {
            try {
                installed_root_location = Which.jarFile(this.getClass()).getParentFile().getParentFile().getAbsolutePath();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "ejb.embedded.cannot_determine_installation_location");
                _logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[EJBContainerProviderImpl] installed_root_location : " + installed_root_location);
        }
        if (installed_root_location != null && (installed_root = this.getValidFile(installed_root_location, "ejb.embedded.installation_location_not_exists")) != null) {
            if (instance_root_location == null) {
                instance_root_location = installed_root_location + File.separatorChar + "domains" + File.separatorChar + "domain1";
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[EJBContainerProviderImpl] instance_root_location: " + instance_root_location);
            }
            instance_root = this.getValidFile(instance_root_location, "ejb.embedded.instance_location_not_exists");
        }
        if (instance_root != null && domain_file_location == null) {
            domain_file_location = instance_root_location + File.separatorChar + "config" + File.separatorChar + "domain.xml";
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[EJBContainerProviderImpl] domain_file_location : " + domain_file_location);
        }
        if (domain_file_location != null && (domain_file = this.getValidFile(domain_file_location, "ejb.embedded.configuration_file_location_not_exists")) != null && !reuse_instance_location) {
            File temp_domain_file = null;
            try {
                DomainXmlTransformer dxf = new DomainXmlTransformer(domain_file, _logger);
                boolean keep_ports = properties == null ? false : properties.get(GF_WEB_HTTP_PORT) != null;
                temp_domain_file = dxf.transform(keep_ports);
            }
            catch (Exception e) {
                throw new EJBException(localStrings.getString("ejb.embedded.exception_creating_temporary_domain_xml_file"), e);
            }
            if (temp_domain_file != null) {
                domain_file = temp_domain_file;
            } else {
                throw new EJBException(localStrings.getString("ejb.embedded.failed_create_temporary_domain_xml_file"));
            }
        }
        return new Locations(installed_root, instance_root, domain_file, reuse_instance_location);
    }

    private InputStream getDeploymentDescriptor(ReadableArchive archive) throws IOException {
        InputStream dd = archive.getEntry("META-INF/ejb-jar.xml");
        if (dd == null) {
            dd = archive.getEntry("WEB-INF/ejb-jar.xml");
        }
        return dd;
    }

    private void addWebContainerIfRequested(Map<?, ?> properties, GlassFishProperties props) throws EJBException {
        String http_port;
        String string = http_port = properties == null ? null : (String)properties.get(GF_WEB_HTTP_PORT);
        if (http_port != null) {
            int port = 8080;
            try {
                port = Integer.parseInt(http_port);
            }
            catch (NumberFormatException e) {
                System.err.println("Using port 8080");
            }
            props.setPort("http-listener-1", port);
        }
    }

    private void copyUserProperties(Map<?, ?> properties, Properties props) {
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            String sk;
            Object key = entry.getKey();
            if (!(key instanceof String) || (sk = (String)key).startsWith(GF_EJB_EMBEDDED_PROPERTY_START)) continue;
            for (String prefix : KNOWN_PACKAGES) {
                if (!sk.startsWith(prefix)) continue;
                Object value = entry.getValue();
                if (value instanceof String) {
                    props.setProperty(sk, (String)value);
                    continue;
                }
                props.setProperty(sk, value.toString());
            }
        }
    }

    private boolean getBooleanProperty(Map<?, ?> properties, String key) {
        Object value;
        boolean result = false;
        if (properties != null && (value = properties.get(key)) != null) {
            if (value instanceof String) {
                result = Boolean.valueOf((String)value);
            } else {
                try {
                    result = (Boolean)value;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private void validateInstanceDirectory() {
        File instance_directory = new File(System.getProperty("com.sun.aas.instanceRoot"));
        if (!instance_directory.exists()) {
            throw new IllegalStateException("Unexpected ERROR: Instance directory " + instance_directory + " does not exist");
        }
        if (!instance_directory.isDirectory()) {
            throw new IllegalStateException("Unexpected ERROR: Instance directory " + instance_directory + " is not a directory");
        }
        File[] files = instance_directory.listFiles();
        if (files == null || files.length == 0) {
            throw new IllegalStateException("Unexpected ERROR: Instance directory " + instance_directory + " is empty");
        }
    }

    static {
        ejbAnnotations = null;
    }

    private static class Locations {
        final File installed_root;
        final File instance_root;
        final File domain_file;
        final String modules_dir;
        final boolean reuse_instance_location;

        Locations(File installed_root, File instance_root, File domain_file, boolean reuse_instance_location) {
            this.installed_root = installed_root;
            this.instance_root = instance_root;
            this.domain_file = domain_file;
            this.modules_dir = installed_root != null ? new File(installed_root, "modules").getAbsolutePath() : null;
            this.reuse_instance_location = reuse_instance_location;
        }
    }
}

