/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.container.util;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.BeanCacheDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
public class CacheProperties
implements PostConstruct {
    protected static final Logger _logger = LogDomains.getLogger(CacheProperties.class, (String)"javax.enterprise.system.container.ejb");
    private int maxCacheSize;
    private int numberOfVictimsToSelect;
    private int cacheIdleTimeoutInSeconds;
    private int removalTimeoutInSeconds;
    private String victimSelectionPolicy;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    EjbContainer ejbContainer;

    public void postConstruct() {
        this.ejbContainer = (EjbContainer)this.serverConfig.getExtensionByType(EjbContainer.class);
    }

    public void init(EjbDescriptor desc) {
        BeanCacheDescriptor beanCacheDes = null;
        IASEjbExtraDescriptors iased = desc.getIASEjbExtraDescriptors();
        if (iased != null) {
            beanCacheDes = iased.getBeanCache();
        }
        this.loadProperties(this.ejbContainer, desc, beanCacheDes);
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getNumberOfVictimsToSelect() {
        return this.numberOfVictimsToSelect;
    }

    public int getCacheIdleTimeoutInSeconds() {
        return this.cacheIdleTimeoutInSeconds;
    }

    public int getRemovalTimeoutInSeconds() {
        return this.removalTimeoutInSeconds;
    }

    public String getVictimSelectionPolicy() {
        return this.victimSelectionPolicy;
    }

    public String getPassivationStorePath() {
        return this.ejbContainer.getSessionStore();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("maxSize: ").append(this.maxCacheSize).append("; victims: ").append(this.numberOfVictimsToSelect).append("; idleTimeout: ").append(this.cacheIdleTimeoutInSeconds).append("; removalTimeout: ").append(this.removalTimeoutInSeconds).append("; policy: ").append(this.victimSelectionPolicy);
        return sbuf.toString();
    }

    private void loadProperties(EjbContainer ejbContainer, EjbDescriptor ejbDesc, BeanCacheDescriptor beanCacheDes) {
        this.numberOfVictimsToSelect = Integer.parseInt(ejbContainer.getCacheResizeQuantity());
        this.maxCacheSize = Integer.parseInt(ejbContainer.getMaxCacheSize());
        this.cacheIdleTimeoutInSeconds = Integer.parseInt(ejbContainer.getCacheIdleTimeoutInSeconds());
        this.removalTimeoutInSeconds = Integer.parseInt(ejbContainer.getRemovalTimeoutInSeconds());
        this.victimSelectionPolicy = ejbContainer.getVictimSelectionPolicy();
        if (ejbDesc instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejbDesc;
            if (sessionDesc.hasStatefulTimeout()) {
                long value = sessionDesc.getStatefulTimeoutValue();
                TimeUnit unit = sessionDesc.getStatefulTimeoutUnit();
                if ((value = TimeUnit.SECONDS.convert(value, unit)) < 0L) {
                    this.removalTimeoutInSeconds = -1;
                    this.cacheIdleTimeoutInSeconds = -1;
                } else if (value == 0L) {
                    this.removalTimeoutInSeconds = 1;
                    this.cacheIdleTimeoutInSeconds = 2;
                } else {
                    this.removalTimeoutInSeconds = (int)value;
                    this.cacheIdleTimeoutInSeconds = (int)(value + 1L);
                }
            }
            if (sessionDesc.isStateful() && !sessionDesc.isPassivationCapable()) {
                this.cacheIdleTimeoutInSeconds += this.removalTimeoutInSeconds;
                this.maxCacheSize = -1;
            }
        }
        if (beanCacheDes != null) {
            int temp = 0;
            temp = beanCacheDes.getResizeQuantity();
            if (temp != -1) {
                this.numberOfVictimsToSelect = temp;
            }
            if ((temp = beanCacheDes.getMaxCacheSize()) != -1) {
                this.maxCacheSize = temp;
            }
            if ((temp = beanCacheDes.getCacheIdleTimeoutInSeconds()) != -1) {
                this.cacheIdleTimeoutInSeconds = temp;
            }
            if ((temp = beanCacheDes.getRemovalTimeoutInSeconds()) != -1) {
                this.removalTimeoutInSeconds = temp;
            }
            if (beanCacheDes.getVictimSelectionPolicy() != null) {
                this.victimSelectionPolicy = beanCacheDes.getVictimSelectionPolicy();
            }
        }
    }
}

