/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.codegen.StaticRmiStubGenerator;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.application.EjbSecurityProbeProvider;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.spi.CMPDeployer;
import org.glassfish.ejb.spi.CMPService;
import org.glassfish.ejb.startup.EjbApplication;
import org.glassfish.ejb.startup.EjbContainerStarter;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.jvnet.hk2.annotations.Service;

@Service
public class EjbDeployer
extends JavaEEDeployer<EjbContainerStarter, EjbApplication>
implements PostConstruct,
EventListener {
    @Inject
    protected ServerContext sc;
    @Inject
    protected Domain domain;
    @Inject
    protected PolicyLoader policyLoader;
    @Inject
    protected EJBSecurityManagerFactory ejbSecManagerFactory;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private Events events;
    @Inject
    StartupContext startupContext;
    private Object lock = new Object();
    private volatile CMPDeployer cmpDeployer = null;
    private static SecureRandom random = new SecureRandom();
    static final String APP_UNIQUE_ID_PROP = "org.glassfish.ejb.container.application_unique_id";
    static final String IS_TIMEOUT_APP_PROP = "org.glassfish.ejb.container.is_timeout_application";
    private AtomicLong uniqueIdCounter;
    private static final Logger _logger = LogDomains.getLogger(EjbDeployer.class, (String)"javax.enterprise.system.container.ejb");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbDeployer.class);
    private final EjbSecurityProbeProvider probeProvider = new EjbSecurityProbeProvider();
    @Inject
    Provider<RegisteredComponentInvocationHandler> registeredComponentInvocationHandlerProvider;
    @Inject
    Provider<CMPService> cmpServiceProvider;
    @Inject
    Provider<CMPDeployer> cmpDeployerProvider;

    public EjbDeployer() {
        this.uniqueIdCounter = new AtomicLong(System.currentTimeMillis());
    }

    public void postConstruct() {
        boolean isUpgrade;
        Properties arguments = this.startupContext.getArguments();
        if (arguments != null && (isUpgrade = Boolean.valueOf(arguments.getProperty("-upgrade")).booleanValue())) {
            return;
        }
        this.events.register((EventListener)this);
    }

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{EjbBundleDescriptorImpl.class}, new Class[]{Application.class});
    }

    public boolean prepare(DeploymentContext dc) {
        Application app;
        String keepStateVal;
        long uniqueAppId;
        EjbBundleDescriptorImpl ejbBundle = (EjbBundleDescriptorImpl)((Object)dc.getModuleMetaData(EjbBundleDescriptorImpl.class));
        if (ejbBundle == null) {
            String errMsg = localStrings.getLocalString("context.contains.no.ejb", "DeploymentContext does not contain any EJB", new Object[]{dc.getSourceDir()});
            throw new RuntimeException(errMsg);
        }
        Properties appProps = dc.getAppProps();
        if (!appProps.containsKey(APP_UNIQUE_ID_PROP)) {
            uniqueAppId = this.getNextEjbAppUniqueId();
            appProps.setProperty(APP_UNIQUE_ID_PROP, "" + uniqueAppId);
        } else {
            uniqueAppId = Long.parseLong(appProps.getProperty(APP_UNIQUE_ID_PROP));
        }
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin.isDeploy() && (keepStateVal = (String)dc.getAppProps().get("org.glassfish.ejb.startup.keepstate")) != null) {
            ejbBundle.getApplication().setKeepStateResolved(keepStateVal);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EjbDeployer.prepare set keepstate to {0} for application.", ejbBundle.getApplication().getKeepStateResolved());
            }
        }
        if (!(app = ejbBundle.getApplication()).isUniqueIdSet()) {
            app.setUniqueId(uniqueAppId);
        }
        return super.prepare(dc);
    }

    public EjbApplication load(EjbContainerStarter containerStarter, DeploymentContext dc) {
        super.load((Container)containerStarter, dc);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "EjbDeployer Loading app from: " + dc.getSourceDir());
        }
        RegisteredComponentInvocationHandler handler = (RegisteredComponentInvocationHandler)this.habitat.getService(RegisteredComponentInvocationHandler.class, "ejbSecurityCIH", new Annotation[0]);
        handler.register();
        EjbBundleDescriptorImpl ejbBundle = (EjbBundleDescriptorImpl)((Object)dc.getModuleMetaData(EjbBundleDescriptorImpl.class));
        if (ejbBundle == null) {
            throw new RuntimeException("Unable to load EJB module.  DeploymentContext does not contain any EJB  Check archive to ensure correct packaging for " + dc.getSourceDir());
        }
        ejbBundle.setClassLoader(dc.getClassLoader());
        ejbBundle.setupDataStructuresForRuntime();
        if (ejbBundle.containsCMPEntity()) {
            CMPService cmpService = (CMPService)this.cmpServiceProvider.get();
            if (cmpService == null) {
                throw new RuntimeException("CMP HK2Module is not available");
            }
            if (!cmpService.isReady()) {
                throw new RuntimeException("CMP HK2Module is not initialized");
            }
        }
        EjbApplication ejbApp = new EjbApplication(ejbBundle, dc, dc.getClassLoader(), this.habitat);
        try {
            this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)ejbBundle);
            RootDeploymentDescriptor rootDesc = ejbBundle.getModuleDescriptor().getDescriptor();
            if (rootDesc != ejbBundle && rootDesc instanceof WebBundleDescriptor) {
                WebBundleDescriptor webBundle = (WebBundleDescriptor)rootDesc;
                this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)webBundle);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception registering ejb bundle level resources", e);
        }
        ejbApp.loadContainers((ApplicationContext)dc);
        return ejbApp;
    }

    public void unload(EjbApplication ejbApplication, DeploymentContext dc) {
        EjbBundleDescriptorImpl ejbBundle = ejbApplication.getEjbBundleDescriptor();
        try {
            this.compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)ejbBundle);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Error unbinding ejb bundle " + ejbBundle.getModuleName() + " dependency namespace", e);
        }
        if (ejbBundle.containsCMPEntity()) {
            this.initCMPDeployer();
            if (this.cmpDeployer != null) {
                this.cmpDeployer.unload(ejbBundle.getClassLoader());
            }
        }
    }

    public void clean(DeploymentContext dc) {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if ((params.origin.isUndeploy() || params.origin.isDeploy()) && this.isDas()) {
            if (this.cmpDeployer != null) {
                this.cmpDeployer.clean(dc);
            }
            Properties appProps = dc.getAppProps();
            String uniqueAppId = appProps.getProperty(APP_UNIQUE_ID_PROP);
            try {
                if (this.getTimeoutStatusFromApplicationInfo(params.name()) && uniqueAppId != null) {
                    String target;
                    String string = target = params.origin.isDeploy() ? ((DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)).target : ((UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class)).target;
                    if (DeploymentUtils.isDomainTarget((String)target)) {
                        List targets = (List)dc.getTransientAppMetaData("previousTargets", List.class);
                        if (targets == null) {
                            targets = this.domain.getAllReferencedTargetsForApplication(params.name());
                        }
                        if (targets != null && targets.size() > 0) {
                            target = (String)targets.get(0);
                        }
                    }
                    EJBTimerService timerService = EJBTimerService.getEJBTimerService(target, false);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "EjbDeployer APP ID of a Timeout App? " + uniqueAppId);
                        _logger.log(Level.FINE, "EjbDeployer TimerService: " + timerService);
                    }
                    if (timerService == null) {
                        _logger.log(Level.WARNING, "EJB Timer Service is not available. Timers for application with id " + uniqueAppId + " will not be deleted");
                    } else if (this.getKeepStateFromApplicationInfo(params.name())) {
                        _logger.log(Level.INFO, "Timers will not be destroyed since keepstate is true for application {0}", params.name());
                    } else {
                        timerService.destroyAllTimers(Long.parseLong(uniqueAppId));
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Failed to delete timers for application with id " + uniqueAppId, e);
            }
        }
        if (params.origin.isUndeploy() || params.origin.isDeploy() || params.origin.isLoad()) {
            String appName = params.name();
            String[] contextIds = this.ejbSecManagerFactory.getContextsForApp(appName, false);
            if (contextIds != null) {
                for (String contextId : contextIds) {
                    try {
                        this.probeProvider.policyDestructionStartedEvent(contextId);
                        SecurityUtil.removePolicy((String)contextId);
                        this.probeProvider.policyDestructionEndedEvent(contextId);
                        this.probeProvider.policyDestructionEvent(contextId);
                    }
                    catch (IASSecurityException ex) {
                        _logger.log(Level.WARNING, "Error removing the policy file for application " + appName + " " + ex);
                    }
                    ArrayList<EJBSecurityManager> managers = this.ejbSecManagerFactory.getManagers(contextId, false);
                    if (managers == null) continue;
                    for (EJBSecurityManager m : managers) {
                        m.destroy();
                    }
                }
            }
            SecurityUtil.removeRoleMapper((DeploymentContext)dc);
        }
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (!params.origin.isDeploy() || !this.isDas()) {
            return;
        }
        EjbBundleDescriptorImpl bundle = (EjbBundleDescriptorImpl)((Object)dc.getModuleMetaData(EjbBundleDescriptorImpl.class));
        DeployCommandParameters dcp = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        boolean generateRmicStubs = dcp.generatermistubs;
        dc.addTransientAppMetaData("org.glassfish.ejb.spi.module.classpath", (Object)this.getModuleClassPath(dc));
        if (generateRmicStubs) {
            StaticRmiStubGenerator staticStubGenerator = new StaticRmiStubGenerator(this.habitat);
            try {
                staticStubGenerator.ejbc(dc);
            }
            catch (Exception e) {
                throw new DeploymentException("Static RMI-IIOP Stub Generation exception for " + dc.getSourceDir(), (Throwable)e);
            }
        }
        if (bundle == null || !bundle.containsCMPEntity()) {
            return;
        }
        this.initCMPDeployer();
        if (this.cmpDeployer == null) {
            throw new DeploymentException("No CMP Deployer is available to deploy this module");
        }
        this.cmpDeployer.deploy(dc);
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_PREPARED) && this.isDas()) {
            ExtendedDeploymentContext context = (ExtendedDeploymentContext)event.hook();
            OpsParams opsparams = context.getCommandParameters(OpsParams.class);
            DeployCommandParameters dcp = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
            ApplicationInfo appInfo = this.appRegistry.get(opsparams.name());
            Application app = (Application)appInfo.getMetaData(Application.class);
            if (app == null) {
                return;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EjbDeployer in APPLICATION_PREPARED for origin: " + opsparams.origin + ", target: " + dcp.target + ", name: " + opsparams.name());
            }
            boolean createTimers = true;
            if (!opsparams.origin.isDeploy() && !opsparams.origin.isCreateAppRef() || this.env.getInstanceName().equals(dcp.target)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "EjbDeployer ... will only set the timeout application flag if any");
                }
                createTimers = false;
            }
            String target = dcp.target;
            if (createTimers && dcp.isredeploy != null && dcp.isredeploy.booleanValue() && DeploymentUtils.isDomainTarget((String)target)) {
                String ref;
                List targets = (List)context.getTransientAppMetaData("previousTargets", List.class);
                Iterator iterator = targets.iterator();
                while (iterator.hasNext() && this.domain.getClusterNamed(target = (ref = (String)iterator.next())) == null) {
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EjbDeployer using target for event as " + target);
            }
            boolean isTimedApp = false;
            for (EjbBundleDescriptorImpl ejbBundle : app.getBundleDescriptors(EjbBundleDescriptorImpl.class)) {
                if (!this.checkEjbBundleForTimers(ejbBundle, createTimers, target)) continue;
                isTimedApp = true;
            }
            if (isTimedApp && (opsparams.origin.isDeploy() || opsparams.origin.isLoad())) {
                appInfo.addTransientAppMetaData(IS_TIMEOUT_APP_PROP, (Object)Boolean.TRUE);
            }
        }
    }

    private boolean checkEjbBundleForTimers(EjbBundleDescriptorImpl ejbBundle, boolean createTimers, String target) {
        boolean result = false;
        if (ejbBundle != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EjbDeployer.checkEjbBundleForTimers in BUNDLE: " + ejbBundle.getName());
            }
            for (EjbDescriptor ejbDescriptor : ejbBundle.getEjbs()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "EjbDeployer.checkEjbBundleForTimers in EJB: " + ejbDescriptor.getName());
                }
                if (!ejbDescriptor.isTimedObject()) continue;
                result = true;
                if (!createTimers || DeploymentUtils.isDomainTarget((String)target)) continue;
                this.createAutomaticPersistentTimersForEJB(ejbDescriptor, target);
            }
        }
        return result;
    }

    private void createAutomaticPersistentTimersForEJB(EjbDescriptor ejbDescriptor, String target) {
        block6: {
            try {
                EJBTimerService timerService = EJBTimerService.getEJBTimerService(target);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "EjbDeployer BEAN ID? " + ejbDescriptor.getUniqueId());
                    _logger.log(Level.FINE, "EjbDeployer TimerService: " + timerService);
                }
                if (timerService != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "EjbDeployer - calling timerService.createSchedules for " + ejbDescriptor.getUniqueId());
                    }
                    timerService.createSchedulesOnServer(ejbDescriptor, this.getOwnerId(target));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "EjbDeployer Done With BEAN ID: " + ejbDescriptor.getUniqueId());
                    }
                    break block6;
                }
                throw new RuntimeException("EJB Timer Service is not available");
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to create automatic timers for " + ejbDescriptor.getName(), (Throwable)e);
            }
        }
    }

    private String getOwnerId(String target) {
        ReferenceContainer ref = this.domain.getReferenceContainerNamed(target);
        if (ref != null && ref.isCluster()) {
            int useInstance;
            Cluster cluster = (Cluster)ref;
            List instances = cluster.getInstances();
            Server s0 = (Server)instances.get(useInstance = random.nextInt(instances.size()));
            if (s0.isRunning()) {
                return s0.getName();
            }
            for (Server s : instances) {
                if (!s.isRunning()) continue;
                return s.getName();
            }
            return s0.getName();
        }
        return target;
    }

    private long getNextEjbAppUniqueId() {
        long next = this.uniqueIdCounter.incrementAndGet();
        return next << 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCMPDeployer() {
        if (this.cmpDeployer == null) {
            Object object = this.lock;
            synchronized (object) {
                this.cmpDeployer = (CMPDeployer)this.cmpDeployerProvider.get();
            }
        }
    }

    private boolean isDas() {
        return EjbContainerUtilImpl.getInstance().isDas();
    }

    private boolean getKeepStateFromApplicationInfo(String appName) {
        return this.getBooleanStateFromApplicationInfo("org.glassfish.ejb.startup.keepstate", appName);
    }

    private boolean getBooleanStateFromApplicationInfo(String flag, String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            return false;
        }
        Boolean rc = (Boolean)appInfo.getTransientAppMetaData(flag, Boolean.class);
        return rc == null ? false : rc;
    }

    private boolean getTimeoutStatusFromApplicationInfo(String appName) {
        return this.getBooleanStateFromApplicationInfo(IS_TIMEOUT_APP_PROP, appName);
    }
}

