/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.codegen.AsmSerializableBeanGenerator;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GenericHomeGenerator;
import com.sun.ejb.codegen.Remote30WrapperGenerator;
import com.sun.ejb.codegen.RemoteGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.GenericEJBLocalHome;
import com.sun.ejb.containers.RemoteBusinessWrapperBase;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;

public class EJBUtils {
    private static final Logger _logger = LogDomains.getLogger(EJBUtils.class, (String)"javax.enterprise.system.container.ejb");
    private static final String EJB_USE_STATIC_CODEGEN_PROP = "com.sun.ejb.UseStaticCodegen";
    private static final String REMOTE30_HOME_JNDI_SUFFIX = "__3_x_Internal_RemoteBusinessHome__";
    private static Boolean ejbUseStaticCodegen_ = null;
    private static final String CORBA_INS_PREFIX = "corbaname:";
    private static final String JAVA_GLOBAL_PREFIX = "java:global/";
    private static final String PORTABLE_JNDI_NAME_SEP = "!";
    private static final String GLASSFISH_JNDI_NAME_SEP = "#";

    public static final byte[] serializeObject(Object obj, boolean replaceObject) throws IOException {
        return EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().serializeObject(obj, replaceObject);
    }

    public static final byte[] serializeObject(Object obj) throws IOException {
        return EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().serializeObject(obj, true);
    }

    public static final Object deserializeObject(byte[] data, ClassLoader loader, boolean resolveObject) throws Exception {
        return EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().deserializeObject(data, resolveObject, loader);
    }

    public static final Object deserializeObject(byte[] data, ClassLoader loader) throws Exception {
        return EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().deserializeObject(data, true, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean useStaticCodegen() {
        Class<EJBUtils> clazz = EJBUtils.class;
        synchronized (EJBUtils.class) {
            if (ejbUseStaticCodegen_ == null) {
                String ejbStaticCodegenProp = null;
                ejbStaticCodegenProp = System.getSecurityManager() == null ? System.getProperty(EJB_USE_STATIC_CODEGEN_PROP) : (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(EJBUtils.EJB_USE_STATIC_CODEGEN_PROP);
                    }
                });
                boolean useStaticCodegen = ejbStaticCodegenProp != null && ejbStaticCodegenProp.equalsIgnoreCase("true");
                ejbUseStaticCodegen_ = useStaticCodegen;
                _logger.log(Level.FINE, "EJB Static codegen is " + (useStaticCodegen ? "ENABLED" : "DISABLED") + " ejbUseStaticCodegenProp = " + ejbStaticCodegenProp);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ejbUseStaticCodegen_;
        }
    }

    public static String getGeneratedOptionalInterfaceName(String ejbClassName) {
        String packageName = Generator.getPackageName(ejbClassName);
        String simpleName = Generator.getBaseName(ejbClassName);
        String optionalIntfName = "__EJB31_Generated__" + simpleName + "__Intf__";
        return packageName == null ? optionalIntfName : packageName + "." + optionalIntfName;
    }

    public static String getRemoteEjbJndiName(EjbReferenceDescriptor refDesc) {
        String intf = refDesc.isEJB30ClientView() ? refDesc.getEjbInterface() : refDesc.getHomeClassName();
        return EJBUtils.getRemoteEjbJndiName(refDesc.isEJB30ClientView(), intf, refDesc.getJndiName());
    }

    public static String getRemote30HomeJndiName(String jndiName) {
        return jndiName + REMOTE30_HOME_JNDI_SUFFIX;
    }

    public static String getRemoteEjbJndiName(boolean businessView, String interfaceName, String jndiName) {
        String returnValue = jndiName;
        String portableFullyQualifiedPortion = PORTABLE_JNDI_NAME_SEP + interfaceName;
        String glassfishFullyQualifiedPortion = GLASSFISH_JNDI_NAME_SEP + interfaceName;
        if (businessView) {
            if (jndiName.startsWith(CORBA_INS_PREFIX)) {
                int indexOfCorbaNameSep = jndiName.indexOf(GLASSFISH_JNDI_NAME_SEP);
                String jndiNameMinusCorbaNamePortion = jndiName.substring(indexOfCorbaNameSep + 1);
                String newJndiName = jndiName;
                if (jndiNameMinusCorbaNamePortion.startsWith(JAVA_GLOBAL_PREFIX)) {
                    newJndiName = EJBUtils.stripFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
                } else if (jndiNameMinusCorbaNamePortion.endsWith(glassfishFullyQualifiedPortion)) {
                    newJndiName = EJBUtils.stripFullyQualifiedJndiName(jndiName, glassfishFullyQualifiedPortion);
                }
                returnValue = EJBUtils.getRemote30HomeJndiName(newJndiName);
            } else {
                returnValue = jndiName.startsWith(JAVA_GLOBAL_PREFIX) ? EJBUtils.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion) : EJBUtils.checkFullyQualifiedJndiName(jndiName, glassfishFullyQualifiedPortion);
            }
        } else if (jndiName.startsWith(JAVA_GLOBAL_PREFIX)) {
            returnValue = EJBUtils.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
        }
        return returnValue;
    }

    private static String checkFullyQualifiedJndiName(String origJndiName, String fullyQualifiedPortion) {
        Object returnValue = origJndiName;
        if (!origJndiName.endsWith(fullyQualifiedPortion)) {
            returnValue = origJndiName + fullyQualifiedPortion;
        }
        return returnValue;
    }

    private static String stripFullyQualifiedJndiName(String origJndiName, String fullyQualifiedPortion) {
        String returnValue = origJndiName;
        if (origJndiName.endsWith(fullyQualifiedPortion)) {
            int portionLength = fullyQualifiedPortion.length();
            returnValue = origJndiName.substring(0, origJndiName.length() - portionLength);
        }
        return returnValue;
    }

    public static Object resolveEjbRefObject(EjbReferenceDescriptor refDesc, Object jndiObj) throws NamingException {
        if (refDesc.isLocal()) {
            EjbDescriptor target = refDesc.getEjbDescriptor();
            BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(target.getUniqueId());
            if (refDesc.isEJB30ClientView()) {
                GenericEJBLocalHome genericLocalHome = container.getEJBLocalBusinessHome(refDesc.getEjbInterface());
                return genericLocalHome.create(refDesc.getEjbInterface());
            }
            return container.getEJBLocalHome();
        }
        if (refDesc.isEJB30ClientView() && !(jndiObj instanceof RemoteBusinessWrapperBase)) {
            return EJBUtils.lookupRemote30BusinessObject(jndiObj, refDesc.getEjbInterface());
        }
        return jndiObj;
    }

    public static Object lookupRemote30BusinessObject(Object jndiObj, String businessInterface) throws NamingException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> genericEJBHome = EJBUtils.loadGeneratedGenericEJBHomeClass(loader);
            Object genericHomeObj = PortableRemoteObject.narrow((Object)jndiObj, genericEJBHome);
            EJBUtils.loadGeneratedRemoteBusinessClasses(businessInterface);
            String generatedRemoteIntfName = RemoteGenerator.getGeneratedRemoteIntfName(businessInterface);
            Method createMethod = genericEJBHome.getMethod("create", String.class);
            Remote delegate = (Remote)createMethod.invoke(genericHomeObj, generatedRemoteIntfName);
            return EJBUtils.createRemoteBusinessObject(loader, businessInterface, delegate);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("ejb ref resolution error for remote business interface" + businessInterface);
            ne.initCause(e instanceof InvocationTargetException ? e.getCause() : e);
            throw ne;
        }
    }

    public static Class loadGeneratedSerializableClass(ClassLoader loader, String className) throws Exception {
        String generatedSerializableClassName = AsmSerializableBeanGenerator.getGeneratedSerializableClassName(className);
        Class<?> developerClass = loader.loadClass(className);
        AsmSerializableBeanGenerator gen = new AsmSerializableBeanGenerator(loader, developerClass, generatedSerializableClassName);
        return gen.generateSerializableSubclass();
    }

    public static void loadGeneratedRemoteBusinessClasses(String businessInterfaceName) throws Exception {
        ClassLoader appClassLoader = EJBUtils.getBusinessIntfClassLoader(businessInterfaceName);
        EJBUtils.loadGeneratedRemoteBusinessClasses(appClassLoader, businessInterfaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGeneratedRemoteBusinessClasses(ClassLoader appClassLoader, String businessInterfaceName) throws Exception {
        String generatedRemoteIntfName = RemoteGenerator.getGeneratedRemoteIntfName(businessInterfaceName);
        String wrapperClassName = Remote30WrapperGenerator.getGeneratedRemoteWrapperName(businessInterfaceName);
        Class<?> generatedRemoteIntf = EJBUtils.loadClassIgnoringExceptions(appClassLoader, generatedRemoteIntfName);
        Class<?> generatedRemoteWrapper = EJBUtils.loadClassIgnoringExceptions(appClassLoader, wrapperClassName);
        if (generatedRemoteIntf != null && generatedRemoteWrapper != null) {
            return generatedRemoteIntfName;
        }
        Wrapper._setClassLoader((ClassLoader)appClassLoader);
        try {
            Generator generator;
            if (generatedRemoteIntf == null) {
                generator = new RemoteGenerator(appClassLoader, businessInterfaceName);
                EJBUtils.generateAndLoad(generator, appClassLoader);
            }
            if (generatedRemoteWrapper == null) {
                generator = new Remote30WrapperGenerator(appClassLoader, businessInterfaceName, generatedRemoteIntfName);
                EJBUtils.generateAndLoad(generator, appClassLoader);
            }
        }
        finally {
            Wrapper._setClassLoader(null);
        }
        return generatedRemoteIntfName;
    }

    public static Class<?> loadGeneratedGenericEJBHomeClass(ClassLoader appClassLoader) throws Exception {
        Class<?> generatedGenericEJBHomeClass = EJBUtils.loadClassIgnoringExceptions(appClassLoader, GenericHomeGenerator.GENERIC_HOME_CLASSNAME);
        if (generatedGenericEJBHomeClass != null) {
            return generatedGenericEJBHomeClass;
        }
        GenericHomeGenerator generator = new GenericHomeGenerator();
        return EJBUtils.generateAndLoad(generator, appClassLoader);
    }

    public static Class<?> generateSEI(ClassGeneratorFactory cgf, ClassLoader loader) {
        Class<?> clazz = EJBUtils.loadClassIgnoringExceptions(loader, cgf.getGeneratedClassName());
        if (clazz != null) {
            return clazz;
        }
        return EJBUtils.generateAndLoad(cgf, loader);
    }

    static synchronized Class<?> generateAndLoad(ClassGeneratorFactory generator, ClassLoader loader) {
        Class<?> clazz = EJBUtils.loadClassIgnoringExceptions(loader, generator.getGeneratedClassName());
        if (clazz != null) {
            return clazz;
        }
        generator.evaluate();
        Properties props = new Properties();
        if (_logger.isLoggable(Level.FINEST)) {
            props.put("org.glassfish.dynamic.codegen.debug.dumpAfterSetupVisitor", "true");
            props.put("org.glassfish.dynamic.codegen.debug.traceByteCodeGeneration", "true");
            props.put("org.glassfish.dynamic.codegen.debug.useAsmVerifier", "true");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                Wrapper._sourceCode((PrintStream)ps, (Properties)props);
                _logger.fine(baos.toString());
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Exception generating src for logs", e);
            }
        }
        if (System.getSecurityManager() == null) {
            return Wrapper._generate((ClassLoader)loader, (ProtectionDomain)generator.getAnchorClass().getProtectionDomain(), (Properties)props);
        }
        PrivilegedAction<Class> action = () -> Wrapper._generate((ClassLoader)loader, (ProtectionDomain)generator.getAnchorClass().getProtectionDomain(), (Properties)props);
        return AccessController.doPrivileged(action);
    }

    private static Class<?> loadClassIgnoringExceptions(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            _logger.log(Level.FINE, "Could not load class: " + className + " by classloader " + classLoader, e);
            return null;
        }
    }

    public static RemoteBusinessWrapperBase createRemoteBusinessObject(String businessInterface, Remote delegate) throws Exception {
        ClassLoader appClassLoader = EJBUtils.getBusinessIntfClassLoader(businessInterface);
        return EJBUtils.createRemoteBusinessObject(appClassLoader, businessInterface, delegate);
    }

    public static RemoteBusinessWrapperBase createRemoteBusinessObject(ClassLoader loader, String businessInterface, Remote delegate) throws Exception {
        String wrapperClassName = Remote30WrapperGenerator.getGeneratedRemoteWrapperName(businessInterface);
        Class<?> clientWrapperClass = loader.loadClass(wrapperClassName);
        Constructor<?>[] ctors = clientWrapperClass.getConstructors();
        Constructor<?> ctor = null;
        for (Constructor<?> next : ctors) {
            if (next.getParameterTypes().length <= 0) continue;
            ctor = next;
            break;
        }
        Object obj = null;
        if (ctor != null) {
            obj = ctor.newInstance(delegate, businessInterface);
        }
        return obj;
    }

    private static ClassLoader getBusinessIntfClassLoader(String businessInterface) throws Exception {
        ClassLoader cl;
        ClassLoader contextLoader = null;
        contextLoader = System.getSecurityManager() == null ? ((cl = Thread.currentThread().getContextClassLoader()) != null ? cl : ClassLoader.getSystemClassLoader()) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl : ClassLoader.getSystemClassLoader();
            }
        });
        final Class<?> businessInterfaceClass = contextLoader.loadClass(businessInterface);
        ClassLoader appClassLoader = null;
        appClassLoader = System.getSecurityManager() == null ? businessInterfaceClass.getClassLoader() : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return businessInterfaceClass.getClassLoader();
            }
        });
        return appClassLoader;
    }

    public static void serializeObjectFields(Object instance, ObjectOutputStream oos) throws IOException {
        EJBUtils.serializeObjectFields(instance, oos, true);
    }

    public static void serializeObjectFields(Object instance, ObjectOutputStream oos, boolean usesSuperClass) throws IOException {
        Class<?> clazz = usesSuperClass ? instance.getClass().getSuperclass() : instance.getClass();
        ObjectOutputStream objOutStream = oos;
        Iterator<Field> iterator = EJBUtils.getSerializationFields(clazz).iterator();
        while (iterator.hasNext()) {
            Field next;
            final Field nextField = next = iterator.next();
            final Object theInstance = instance;
            Object value = null;
            try {
                if (System.getSecurityManager() == null) {
                    if (!nextField.isAccessible()) {
                        nextField.setAccessible(true);
                    }
                    value = nextField.get(theInstance);
                } else {
                    value = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (!nextField.isAccessible()) {
                                nextField.setAccessible(true);
                            }
                            return nextField.get(theInstance);
                        }
                    });
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "=====> Serializing field: " + nextField);
                }
                objOutStream.writeObject(value);
            }
            catch (Throwable t) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "=====> failed serializing field: " + nextField + " =====> of class: " + clazz + " =====> using: " + oos.getClass() + " =====> serializing value of type: " + (value == null ? null : value.getClass().getName()) + " ===> Error: " + t);
                    _logger.log(Level.FINE, "", t);
                }
                IOException ioe = new IOException();
                Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
                ioe.initCause(cause);
                throw ioe;
            }
        }
    }

    public static void deserializeObjectFields(Object instance, ObjectInputStream ois) throws IOException {
        EJBUtils.deserializeObjectFields(instance, ois, null, true);
    }

    public static void deserializeObjectFields(Object instance, ObjectInputStream ois, Object replaceValue, boolean usesSuperClass) throws IOException {
        Class<?> clazz;
        Class<?> clazz2 = clazz = usesSuperClass ? instance.getClass().getSuperclass() : instance.getClass();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "=====> Deserializing class: " + clazz);
            if (replaceValue != null) {
                _logger.log(Level.FINE, "=====> Replace requested for value: " + replaceValue.getClass());
            }
        }
        for (Field next : EJBUtils.getSerializationFields(clazz)) {
            try {
                final Field nextField = next;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "=====> Deserializing field: " + nextField);
                }
                Object value = ois.readObject();
                if (replaceValue != null && nextField.getType().isAssignableFrom(replaceValue.getClass())) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "=====> Replacing field: " + nextField);
                    }
                    value = replaceValue;
                }
                final Object newValue = value;
                final Object theInstance = instance;
                if (System.getSecurityManager() == null) {
                    if (!nextField.isAccessible()) {
                        nextField.setAccessible(true);
                    }
                    nextField.set(theInstance, newValue);
                    continue;
                }
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!nextField.isAccessible()) {
                            nextField.setAccessible(true);
                        }
                        nextField.set(theInstance, newValue);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                IOException ioe = new IOException();
                Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
                ioe.initCause(cause);
                throw ioe;
            }
        }
    }

    private static Collection<Field> getSerializationFields(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        TreeMap<String, Field> sortedMap = new TreeMap<String, Field>();
        for (Field next : fields) {
            int modifiers = next.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            sortedMap.put(next.getName(), next);
        }
        return sortedMap.values();
    }
}

