/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistentFieldInfo;
import org.glassfish.ejb.deployment.descriptor.QueryParser;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbCMPFinder;
import org.glassfish.ejb.deployment.descriptor.runtime.PrefetchDisabledDescriptor;

public class IASEjbCMPEntityDescriptor
extends EjbCMPEntityDescriptor {
    private static final long serialVersionUID = 1L;
    private transient Class<?> ejbClass;
    private String pcImplClassName;
    private String concreteImplClassName;
    private String ejbImplClassName;
    private String mappingProperties;
    private transient ClassLoader jcl;
    private String uniqueName;
    private String moduleDir;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(IASEjbCMPEntityDescriptor.class);
    private static final Logger _logger = DOLUtils.getDefaultLogger();
    private static final char DOT = '.';
    private static final char LIST_START = '(';
    private static final char LIST_END = ')';
    private static final char LIST_SEPARATOR = ',';
    private static final char NAME_PART_SEPARATOR = '_';
    private static final char NAME_CONCATENATOR = ' ';
    private static final String FIND = "find";
    private static final String EJB_SELECT = "ejbSelect";
    private static final String JDOSTATE = "_JDOState";
    private static final String CONCRETE_IMPL = "_ConcreteImpl";
    private static final String MAPPINGEXT = ".mapping";
    private transient Collection<Method> finders;
    private transient Collection<Method> selectors;
    private transient QueryParser queryParser;
    private PrefetchDisabledDescriptor prefetchDisabledDescriptor;
    private static final Map<String, String> conversionTable = IASEjbCMPEntityDescriptor.createConversionTable();
    private final Map<String, IASEjbCMPFinder> oneOneFinders = new HashMap<String, IASEjbCMPFinder>();
    private final List<IASEjbCMPFinder> arrOneOneFinders = new ArrayList<IASEjbCMPFinder>();

    private void addAllInterfaceMethodsIn(Collection<Method> methodDescriptors, Class<?> c) {
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            methodDescriptors.add(method);
        }
    }

    private void addAllUniqueInterfaceMethodsIn(Collection<Method> methodDescriptors, Class<?> c) {
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            if (this.findEquivalentMethod(methodDescriptors, method) != null) continue;
            methodDescriptors.add(method);
        }
    }

    public Collection<Method> getAllUniqueMethods() {
        HashSet<Method> methods = new HashSet<Method>();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllUniqueInterfaceMethodsIn(methods, this.jcl.loadClass(this.getHomeClassName()));
                this.addAllUniqueInterfaceMethodsIn(methods, this.jcl.loadClass(this.getRemoteClassName()));
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllUniqueInterfaceMethodsIn(methods, this.jcl.loadClass(this.getLocalHomeClassName()));
                this.addAllUniqueInterfaceMethodsIn(methods, this.jcl.loadClass(this.getLocalClassName()));
            }
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "enterprise.deployment_error_loading_class_excp", t);
            throw new RuntimeException(t.getMessage());
        }
        return methods;
    }

    public Collection<Method> getAllMethods() {
        HashSet<Method> methods = new HashSet<Method>();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, this.jcl.loadClass(this.getHomeClassName()));
                this.addAllInterfaceMethodsIn(methods, this.jcl.loadClass(this.getRemoteClassName()));
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, this.jcl.loadClass(this.getLocalHomeClassName()));
                this.addAllInterfaceMethodsIn(methods, this.jcl.loadClass(this.getLocalClassName()));
            }
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "enterprise.deployment_error_loading_class_excp", t);
            throw new RuntimeException(t.getMessage());
        }
        return methods;
    }

    private Method findEquivalentMethod(Collection<Method> methods, Method methodToMatch) {
        if (methods == null) {
            return null;
        }
        for (Method method : methods) {
            if (!this.methodsEqual(method, methodToMatch, false)) continue;
            return method;
        }
        return null;
    }

    private boolean methodsEqual(Method m1, Method m2, boolean compareDeclaringClass) {
        String m2Name;
        boolean equal = false;
        String m1Name = m1.getName();
        if (m1Name.equals(m2Name = m2.getName())) {
            Class<?>[] m2ParamTypes;
            Class<?>[] m1ParamTypes;
            String m1DeclaringClass = m1.getDeclaringClass().getName();
            String m2DeclaringClass = m2.getDeclaringClass().getName();
            if ((!compareDeclaringClass || m1DeclaringClass.equals(m2DeclaringClass)) && (m1ParamTypes = m1.getParameterTypes()).length == (m2ParamTypes = m2.getParameterTypes()).length) {
                equal = true;
                for (int pIndex = 0; pIndex < m1ParamTypes.length; ++pIndex) {
                    String m2ParamClass;
                    String m1ParamClass = m1ParamTypes[pIndex].getName();
                    if (m1ParamClass.equals(m2ParamClass = m2ParamTypes[pIndex].getName())) continue;
                    equal = false;
                    break;
                }
            }
        }
        return equal;
    }

    private Class<?> getEjbClass() {
        if (this.ejbClass == null) {
            String ejbClassName = this.getEjbClassName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("@@@@@@ Ejb name is  " + ejbClassName);
            }
            if (this.jcl == null) {
                String msg = localStrings.getLocalString("enterprise.deployment.error_missing_classloader", "IASEjbCMPEntityDescriptor.getEjbClass");
                _logger.log(Level.WARNING, msg);
                throw new RuntimeException(msg);
            }
            try {
                this.ejbClass = Class.forName(ejbClassName, true, this.jcl);
            }
            catch (ClassNotFoundException e) {
                String msg = localStrings.getLocalString("enterprise.deployment.error_cannot_find_ejbclass", ejbClassName);
                _logger.log(Level.WARNING, msg);
                throw new RuntimeException(msg);
            }
        }
        return this.ejbClass;
    }

    public Collection<Method> getFinders() {
        if (this.finders == null) {
            String ejbClassName = this.getEjbClassName();
            Class<?> ejbClass = this.getEjbClass();
            if (super.isRemoteInterfacesSupported()) {
                Class<?> remoteHomeIntf = null;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("@@@@@@ " + ejbClassName + " : Remote Interface is supported ");
                }
                try {
                    remoteHomeIntf = ejbClass.getClassLoader().loadClass(super.getHomeClassName());
                }
                catch (ClassNotFoundException ex) {
                    _logger.log(Level.WARNING, "enterprise.deployment_class_not_found", ex);
                    return null;
                }
                this.finders = this.getFinders(remoteHomeIntf);
                if (_logger.isLoggable(Level.FINE)) {
                    Iterator<Method> ex = this.finders.iterator();
                    while (ex.hasNext()) {
                        Method finder;
                        Method remoteHomeMethod = finder = ex.next();
                        _logger.fine("@@@@ adding Remote interface method " + remoteHomeMethod.getName());
                    }
                }
            }
            if (super.isLocalInterfacesSupported()) {
                Class<?> localHomeIntf = null;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("@@@@@@ " + ejbClassName + ":  Local Interface is supported ");
                }
                try {
                    localHomeIntf = ejbClass.getClassLoader().loadClass(super.getLocalHomeClassName());
                }
                catch (ClassNotFoundException ex) {
                    _logger.log(Level.WARNING, "enterprise.deployment_class_not_found", ex);
                    return null;
                }
                Collection<Method> localFinders = this.getFinders(localHomeIntf);
                if (this.finders == null) {
                    this.finders = localFinders;
                } else if (localFinders != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("@@@@@@ Trying to remove the Common Elements from HashSet....... ");
                    }
                    for (Method localFinder : localFinders) {
                        Method localHomeMethod = localFinder;
                        if (this.findEquivalentMethod(this.finders, localHomeMethod) != null) continue;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("@@@@ adding local interface method " + localHomeMethod.getName());
                        }
                        this.finders.add(localHomeMethod);
                    }
                }
            }
            if (this.finders == null) {
                this.finders = new HashSet<Method>();
            }
        }
        return this.finders;
    }

    public Collection<Method> getFinders(Class<?> homeIntf) {
        Method[] methods = homeIntf.getMethods();
        HashSet<Method> finders = new HashSet<Method>();
        for (Method method : methods) {
            if (!method.getName().startsWith(FIND)) continue;
            finders.add(method);
        }
        return finders;
    }

    public void setClassLoader(ClassLoader jcl) {
        this.jcl = jcl;
    }

    public ClassLoader getClassLoader() {
        return this.jcl;
    }

    public Collection<PersistentFieldInfo> getAllPersistentFields() {
        PersistenceDescriptor pers = this.getPersistenceDescriptor();
        PersistentFieldInfo[] persFields = pers.getPersistentFieldInfo();
        PersistentFieldInfo[] pkeyFields = pers.getPkeyFieldInfo();
        HashMap<String, PersistentFieldInfo> fields = new HashMap<String, PersistentFieldInfo>();
        for (PersistentFieldInfo persField : persFields) {
            fields.put(persField.name, persField);
        }
        for (PersistentFieldInfo pkeyField : pkeyFields) {
            fields.put(pkeyField.name, pkeyField);
        }
        return fields.values();
    }

    public Collection<PersistentFieldInfo> getPersistentFields() {
        PersistenceDescriptor pers = this.getPersistenceDescriptor();
        PersistentFieldInfo[] persFields = pers.getPersistentFieldInfo();
        HashMap<String, PersistentFieldInfo> fields = new HashMap<String, PersistentFieldInfo>();
        for (PersistentFieldInfo persField : persFields) {
            fields.put(persField.name, persField);
        }
        return fields.values();
    }

    public Collection<PersistentFieldInfo> getPrimaryKeyFields() {
        PersistenceDescriptor pers = this.getPersistenceDescriptor();
        PersistentFieldInfo[] pkeyFields = pers.getPkeyFieldInfo();
        HashMap<String, PersistentFieldInfo> pkey = new HashMap<String, PersistentFieldInfo>();
        for (PersistentFieldInfo pkeyField : pkeyFields) {
            pkey.put(pkeyField.name, pkeyField);
        }
        return pkey.values();
    }

    public Collection<Method> getSelectors() {
        if (this.selectors == null) {
            Method[] methods;
            this.selectors = new HashSet<Method>();
            Class<?> ejbClass = this.getEjbClass();
            for (Method method : methods = ejbClass.getMethods()) {
                if (!method.getName().startsWith(EJB_SELECT)) continue;
                this.selectors.add(method);
            }
        }
        return this.selectors;
    }

    public String getBaseName(String className) {
        if (className == null) {
            return null;
        }
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return className.substring(dot + 1);
    }

    public IASEjbCMPEntityDescriptor() {
    }

    public IASEjbCMPEntityDescriptor(EjbDescriptor other) {
        super(other);
        this.setPersistenceType("Container");
    }

    public void setPcImplClassName(String name) {
        this.pcImplClassName = name;
    }

    public String getUniqueName() {
        if (this.uniqueName == null) {
            EjbBundleDescriptorImpl bundle = this.getEjbBundleDescriptor();
            Application application = bundle.getApplication();
            StringBuilder rc = new StringBuilder().append(this.getName()).append(' ').append(application.getRegistrationName());
            if (!application.isVirtual()) {
                rc.append(' ').append(bundle.getModuleDescriptor().getArchiveUri());
            }
            this.uniqueName = this.getBaseName(this.getEjbClassName()) + this.getUniqueNumber(rc.toString());
        }
        return this.uniqueName;
    }

    public String getUniqueNumber(String num) {
        Object newNum = "" + num.hashCode();
        newNum = ((String)newNum).replace('-', '_');
        return newNum;
    }

    public String getPcImplClassName() {
        if (this.pcImplClassName == null) {
            this.pcImplClassName = this.getUniqueName() + JDOSTATE;
            String packageName = this.getPackageName(this.getEjbClassName());
            if (packageName != null) {
                this.pcImplClassName = packageName + "." + this.pcImplClassName;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("##### PCImplClass Name is " + this.pcImplClassName);
            }
        }
        return this.pcImplClassName;
    }

    public void setConcreteImplClassName(String name) {
        this.concreteImplClassName = name;
    }

    public String getPackageName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return className.substring(0, dot);
    }

    @Override
    public String getEjbImplClassName() {
        if (this.ejbImplClassName == null) {
            String packageName = this.getPackageName(this.getEjbClassName());
            this.ejbImplClassName = this.getConcreteImplClassName();
            if (packageName != null) {
                this.ejbImplClassName = packageName + "." + this.ejbImplClassName;
            }
        }
        return this.ejbImplClassName;
    }

    public String getConcreteImplClassName() {
        if (this.concreteImplClassName == null) {
            this.concreteImplClassName = this.getUniqueName() + CONCRETE_IMPL;
        }
        return this.concreteImplClassName;
    }

    public void setModuleDir(String moduleRootDir) {
        this.moduleDir = moduleRootDir;
    }

    public String getModuleDir() {
        if (this.moduleDir == null) {
            return null;
        }
        return this.moduleDir;
    }

    public void setMappingProperties(String mappingProperties) {
        this.mappingProperties = mappingProperties;
    }

    public String getMappingProperties() {
        return this.mappingProperties;
    }

    public void setQueryParser(QueryParser inParser) {
        this.queryParser = inParser;
    }

    public QueryParser getQueryParser() {
        return this.queryParser;
    }

    private static Map<String, String> createConversionTable() {
        HashMap<String, String> conversionTable = new HashMap<String, String>();
        conversionTable.put("Boolean", "java.lang.Boolean");
        conversionTable.put("Byte", "java.lang.Byte");
        conversionTable.put("Character", "java.lang.Character");
        conversionTable.put("Double", "java.lang.Double");
        conversionTable.put("Float", "java.lang.Float");
        conversionTable.put("Integer", "java.lang.Integer");
        conversionTable.put("Long", "java.lang.Long");
        conversionTable.put("Number", "java.lang.Number");
        conversionTable.put("Short", "java.lang.Short");
        conversionTable.put("String", "java.lang.String");
        conversionTable.put("Object", "java.lang.Object");
        return conversionTable;
    }

    private String getFullyQualifiedType(String type) {
        String knownType = conversionTable.get(type);
        return knownType == null ? type : knownType;
    }

    public PrefetchDisabledDescriptor getPrefetchDisabledDescriptor() {
        return this.prefetchDisabledDescriptor;
    }

    public void setPrefetchDisabledDescriptor(PrefetchDisabledDescriptor prefetchDisabledDescriptor) {
        this.prefetchDisabledDescriptor = prefetchDisabledDescriptor;
    }

    public void addOneOneFinder(IASEjbCMPFinder finder) {
        this.arrOneOneFinders.add(finder);
    }

    public Map<String, IASEjbCMPFinder> getOneOneFinders() {
        if (!this.arrOneOneFinders.isEmpty()) {
            if (this.queryParser == null) {
                String msg = localStrings.getLocalString("enterprise.deployment.error_missing_queryparser", "IASEjbCMPEntityDescriptor.getOneOneFinders");
                _logger.log(Level.WARNING, msg);
                throw new RuntimeException(msg);
            }
            Iterator<IASEjbCMPFinder> iterator = this.arrOneOneFinders.iterator();
            while (iterator.hasNext()) {
                IASEjbCMPFinder arrOneOneFinder;
                IASEjbCMPFinder finder = arrOneOneFinder = iterator.next();
                String key = this.generateKey(finder, this.queryParser);
                this.oneOneFinders.put(key, finder);
            }
            this.arrOneOneFinders.clear();
        }
        return this.oneOneFinders;
    }

    private String generateKey(IASEjbCMPFinder finder, QueryParser parser) {
        StringBuilder key = new StringBuilder();
        key.append(finder.getMethodName()).append('(');
        String queryParams = finder.getQueryParameterDeclaration();
        Iterator<String> iter = parser.parameterTypeIterator(queryParams);
        while (iter.hasNext()) {
            String type = iter.next();
            key.append(this.getFullyQualifiedType(type));
            if (!iter.hasNext()) continue;
            key.append(',');
        }
        key.append(')');
        return key.toString().intern();
    }

    public IASEjbCMPFinder getIASEjbCMPFinder(Method method) {
        if (this.findEquivalentMethod(this.getFinders(), method) == null) {
            return null;
        }
        String methodName = method.getName();
        StringBuffer key = new StringBuffer();
        key.append(methodName);
        key.append('(');
        Class<?>[] paramList = method.getParameterTypes();
        for (int index = 0; index < paramList.length; ++index) {
            if (index > 0) {
                key.append(',');
            }
            key.append(paramList[index].getName());
        }
        key.append(')');
        return this.getOneOneFinders().get(key.toString());
    }
}

