/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchEntityException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.TransactionRequiredLocalException;
import jakarta.ejb.TransactionRolledbackLocalException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;

public class EJBContainerTransactionManager {
    private static final Logger _logger = EjbContainerUtilImpl.getLogger();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBContainerTransactionManager.class);
    private static final String USER_TX = "java:comp/UserTransaction";
    private final EjbContainerUtil ejbContainerUtilImpl = EjbContainerUtilImpl.getInstance();
    private final JavaEETransactionManager transactionManager;
    private final BaseContainer container;
    private final EjbDescriptor ejbDescriptor;
    private int cmtTimeoutInSeconds = 0;

    EJBContainerTransactionManager(Container c, EjbDescriptor ejbDesc) {
        IASEjbExtraDescriptors iased;
        this.container = (BaseContainer)c;
        this.ejbDescriptor = ejbDesc;
        this.transactionManager = this.ejbContainerUtilImpl.getTransactionManager();
        TransactionService txnService = (TransactionService)this.ejbContainerUtilImpl.getServices().getService(TransactionService.class, "default-instance-name", new Annotation[0]);
        int transactionTimeout = Integer.parseInt(txnService.getTimeoutInSeconds());
        if (transactionTimeout >= 0) {
            this.cmtTimeoutInSeconds = transactionTimeout;
        }
        if ((iased = ejbDesc.getIASEjbExtraDescriptors()).getCmtTimeoutInSeconds() != 0) {
            this.cmtTimeoutInSeconds = iased.getCmtTimeoutInSeconds();
        }
    }

    int findTxAttr(MethodDescriptor md) {
        int txAttr = -1;
        if (this.container.isBeanManagedTran) {
            return 2;
        }
        ContainerTransaction ct = this.ejbDescriptor.getContainerTransactionFor(md);
        if (ct != null) {
            String attr = ct.getTransactionAttribute();
            if (attr.equals("NotSupported")) {
                txAttr = 1;
            } else if (attr.equals("Supports")) {
                txAttr = 4;
            } else if (attr.equals("Required")) {
                txAttr = 3;
            } else if (attr.equals("RequiresNew")) {
                txAttr = 5;
            } else if (attr.equals("Mandatory")) {
                txAttr = 6;
            } else if (attr.equals("Never")) {
                txAttr = 7;
            }
        }
        if (txAttr == -1) {
            throw new EJBException("Transaction Attribute not found for method " + md);
        }
        this.container.validateTxAttr(md, txAttr);
        return txAttr;
    }

    final void preInvokeTx(EjbInvocation inv) throws Exception {
        int status;
        Integer preInvokeTxStatus = inv.getPreInvokeTxStatus();
        int n = status = preInvokeTxStatus != null ? preInvokeTxStatus.intValue() : this.transactionManager.getStatus();
        if (this.container.suspendTransaction(inv)) {
            if (status != 6) {
                try {
                    inv.clientTx = this.transactionManager.suspend();
                }
                catch (SystemException ex) {
                    throw new EJBException((Exception)((Object)ex));
                }
            }
            return;
        }
        boolean isNullTx = false;
        if (inv.isRemote) {
            isNullTx = this.transactionManager.isNullTransaction();
        }
        int txAttr = this.container.getTxAttr(inv);
        EJBContextImpl context = (EJBContextImpl)inv.context;
        Transaction prevTx = context.getTransaction();
        switch (txAttr) {
            case 2: {
                if (status != 6) {
                    inv.clientTx = this.transactionManager.suspend();
                }
                if (!this.container.isStatefulSession || prevTx == null || prevTx.getStatus() == 6) break;
                this.transactionManager.resume(prevTx);
                this.transactionManager.enlistComponentResources();
                break;
            }
            case 1: {
                if (status != 6) {
                    inv.clientTx = this.transactionManager.suspend();
                }
                this.container.checkUnfinishedTx(prevTx, inv);
                this.container.preInvokeNoTx(inv);
                break;
            }
            case 6: {
                if (isNullTx || status == 6) {
                    throw new TransactionRequiredLocalException();
                }
                this.useClientTx(prevTx, inv);
                break;
            }
            case 3: {
                if (isNullTx) {
                    throw new TransactionRequiredLocalException();
                }
                if (status == 6) {
                    inv.clientTx = null;
                    this.startNewTx(prevTx, inv);
                    break;
                }
                inv.clientTx = this.transactionManager.getTransaction();
                this.useClientTx(prevTx, inv);
                break;
            }
            case 5: {
                if (status != 6) {
                    inv.clientTx = this.transactionManager.suspend();
                }
                this.startNewTx(prevTx, inv);
                break;
            }
            case 4: {
                if (isNullTx) {
                    throw new TransactionRequiredLocalException();
                }
                if (status != 6) {
                    this.useClientTx(prevTx, inv);
                    break;
                }
                this.container.checkUnfinishedTx(prevTx, inv);
                this.container.preInvokeNoTx(inv);
                break;
            }
            case 7: {
                if (isNullTx || status != 6) {
                    throw new EJBException("EJB cannot be invoked in global transaction");
                }
                this.container.checkUnfinishedTx(prevTx, inv);
                this.container.preInvokeNoTx(inv);
                break;
            }
            default: {
                throw new EJBException("Bad transaction attribute");
            }
        }
    }

    private void startNewTx(Transaction prevTx, EjbInvocation inv) throws Exception {
        this.container.checkUnfinishedTx(prevTx, inv);
        if (this.cmtTimeoutInSeconds > 0) {
            this.transactionManager.begin(this.cmtTimeoutInSeconds);
        } else {
            this.transactionManager.begin();
        }
        EJBContextImpl context = (EJBContextImpl)inv.context;
        Transaction tx = this.transactionManager.getTransaction();
        if (!this.container.isSingleton) {
            context.setTransaction(tx);
        }
        this.transactionManager.enlistComponentResources();
        if (!inv.invocationInfo.isHomeFinder) {
            this.ejbContainerUtilImpl.getContainerSync(tx).addBean(context);
        }
        this.container.afterBegin(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void useClientTx(Transaction prevTx, EjbInvocation inv) {
        Transaction clientTx;
        int status = -1;
        int prevStatus = -1;
        try {
            clientTx = this.transactionManager.getTransaction();
            status = clientTx.getStatus();
            if (prevTx != null) {
                prevStatus = prevTx.getStatus();
            }
        }
        catch (Exception ex) {
            try {
                this.transactionManager.setRollbackOnly();
                throw new TransactionRolledbackLocalException("", ex);
            }
            catch (Exception e) {
                _logger.log(Level.FINEST, "", e);
            }
            throw new TransactionRolledbackLocalException("", ex);
        }
        if (status == 1 || status == 4 || status == 9) {
            throw new TransactionRolledbackLocalException("Client's transaction aborted");
        }
        this.container.validateEMForClientTx(inv, (JavaEETransaction)clientTx);
        if (prevTx == null || prevStatus == 6) {
            EJBContextImpl context = (EJBContextImpl)inv.context;
            if (!this.container.isSingleton) {
                context.setTransaction(clientTx);
            }
            try {
                this.transactionManager.enlistComponentResources();
                if (this.container.isStatelessSession || this.container.isMessageDriven || this.container.isSingleton) return;
                if (!inv.invocationInfo.isHomeFinder) {
                    this.ejbContainerUtilImpl.getContainerSync(clientTx).addBean(context);
                }
                this.container.afterBegin(context);
                return;
            }
            catch (Exception ex) {
                try {
                    this.transactionManager.setRollbackOnly();
                    throw new TransactionRolledbackLocalException("", ex);
                }
                catch (Exception e) {
                    _logger.log(Level.FINEST, "", e);
                }
                throw new TransactionRolledbackLocalException("", ex);
            }
        }
        if (!prevTx.equals(clientTx)) {
            if (!this.container.isSession) return;
            throw new IllegalStateException("EJB is already associated with an incomplete transaction");
        }
        try {
            this.transactionManager.enlistComponentResources();
            return;
        }
        catch (Exception ex) {
            try {
                this.transactionManager.setRollbackOnly();
                throw new TransactionRolledbackLocalException("", ex);
            }
            catch (Exception e) {
                _logger.log(Level.FINEST, "", e);
            }
            throw new TransactionRolledbackLocalException("", ex);
        }
    }

    protected void postInvokeTx(EjbInvocation inv) throws Exception {
        Throwable exception = inv.exception;
        if (this.container.resumeTransaction(inv)) {
            if (inv.clientTx != null) {
                this.transactionManager.resume(inv.clientTx);
            }
            if (inv.exception != null && inv.exception instanceof BaseContainer.PreInvokeException) {
                inv.exception = ((BaseContainer.PreInvokeException)((Object)exception)).exception;
            }
            return;
        }
        EJBContextImpl context = (EJBContextImpl)inv.context;
        int status = this.transactionManager.getStatus();
        int txAttr = inv.invocationInfo.txAttr;
        Throwable newException = exception;
        switch (txAttr) {
            case 2: {
                newException = this.checkExceptionBeanMgTx(context, exception, status);
                if (inv.clientTx == null) break;
                this.transactionManager.resume(inv.clientTx);
                break;
            }
            case 1: 
            case 7: {
                if (exception != null) {
                    newException = this.checkExceptionNoTx(context, exception);
                }
                this.container.postInvokeNoTx(inv);
                if (inv.clientTx == null) break;
                this.transactionManager.resume(inv.clientTx);
                break;
            }
            case 6: {
                if (exception == null) break;
                newException = this.checkExceptionClientTx(context, exception);
                break;
            }
            case 3: {
                if (inv.clientTx == null) {
                    newException = this.completeNewTx(context, exception, status);
                    break;
                }
                if (exception == null) break;
                newException = this.checkExceptionClientTx(context, exception);
                break;
            }
            case 5: {
                newException = this.completeNewTx(context, exception, status);
                if (inv.clientTx == null) break;
                this.transactionManager.resume(inv.clientTx);
                break;
            }
            case 4: {
                if (status != 6) {
                    if (exception == null) break;
                    newException = this.checkExceptionClientTx(context, exception);
                    break;
                }
                if (exception != null) {
                    newException = this.checkExceptionNoTx(context, exception);
                }
                this.container.postInvokeNoTx(inv);
                break;
            }
        }
        inv.exception = newException;
    }

    final UserTransaction getUserTransaction() {
        if ((this.container.isSession || this.container.isMessageDriven) && this.container.isBeanManagedTran) {
            try {
                UserTransaction utx = (UserTransaction)this.container.namingManager.getInitialContext().lookup(USER_TX);
                return utx;
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "ejb.user_transaction_exception", ex);
                throw new EJBException(_logger.getResourceBundle().getString("ejb.user_transaction_exception"), ex);
            }
        }
        throw new IllegalStateException(localStrings.getLocalString("ejb.ut_only_for_bmt", "Only session beans with bean-managed transactions can obtain UserTransaction"));
    }

    private EJBException destroyBeanAndRollback(EJBContextImpl context, String type) throws Exception {
        try {
            this.container.forceDestroyBean(context);
        }
        finally {
            this.transactionManager.rollback();
        }
        EJBException ex = null;
        if (type != null) {
            ex = new EJBException(type + " method returned without completing transaction");
            _logger.log(Level.FINE, "ejb.incomplete_sessionbean_txn_exception");
            _logger.log(Level.FINE, "", ex);
        }
        return ex;
    }

    private Throwable checkExceptionBeanMgTx(EJBContextImpl context, Throwable exception, int status) throws Exception {
        Throwable newException = exception;
        if (exception != null && exception instanceof BaseContainer.PreInvokeException) {
            newException = ((BaseContainer.PreInvokeException)((Object)exception)).exception;
        } else if (status == 6) {
            if (exception != null) {
                newException = this.checkExceptionNoTx(context, exception);
            }
        } else if (this.container.isStatefulSession) {
            if (!this.container.isSystemUncheckedException(exception)) {
                if (this.isAppExceptionRequiringRollback(exception)) {
                    this.transactionManager.rollback();
                } else {
                    this.transactionManager.suspend();
                }
            } else {
                this.destroyBeanAndRollback(context, null);
                newException = this.processSystemException(exception);
            }
        } else {
            newException = this.container.isStatelessSession ? this.destroyBeanAndRollback(context, "Stateless SessionBean") : (this.container.isSingleton ? this.destroyBeanAndRollback(context, "Singleton SessionBean") : this.destroyBeanAndRollback(context, "MessageDrivenBean"));
        }
        return newException;
    }

    private Throwable checkExceptionNoTx(EJBContextImpl context, Throwable exception) throws Exception {
        if (exception instanceof BaseContainer.PreInvokeException) {
            return ((BaseContainer.PreInvokeException)((Object)exception)).exception;
        }
        Throwable newException = exception;
        if (this.container.isSystemUncheckedException(exception)) {
            newException = this.processSystemException(exception);
            this.container.forceDestroyBean(context);
        }
        return newException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Throwable checkExceptionClientTx(EJBContextImpl context, Throwable exception) throws Exception {
        if (exception instanceof BaseContainer.PreInvokeException) {
            return ((BaseContainer.PreInvokeException)((Object)exception)).exception;
        }
        Throwable newException = exception;
        if (this.container.isSystemUncheckedException(exception)) {
            try {
                this.container.forceDestroyBean(context);
            }
            finally {
                this.transactionManager.setRollbackOnly();
            }
            if (exception instanceof Exception) {
                newException = new TransactionRolledbackLocalException("Exception thrown from bean", (Exception)exception);
            } else {
                newException = new TransactionRolledbackLocalException("Exception thrown from bean: " + exception.toString());
                newException.initCause(exception);
            }
        } else if (this.isAppExceptionRequiringRollback(exception)) {
            this.transactionManager.setRollbackOnly();
        }
        return newException;
    }

    private Throwable completeNewTx(EJBContextImpl context, Throwable exception, int status) throws Exception {
        Throwable newException = exception;
        if (exception instanceof BaseContainer.PreInvokeException) {
            newException = ((BaseContainer.PreInvokeException)((Object)exception)).exception;
        }
        if (status == 6) {
            return newException;
        }
        if (this.container.isStatefulSession && context instanceof SessionContextImpl) {
            ((SessionContextImpl)context).setTxCompleting(true);
        }
        if (newException != null && this.container.isSystemUncheckedException(newException)) {
            this.destroyBeanAndRollback(context, null);
            return this.processSystemException(newException);
        }
        try {
            if (status == 1) {
                if (this.transactionManager.isTimedOut()) {
                    _logger.log(Level.WARNING, "ejb.tx_timeout", new Object[]{this.transactionManager.getTransaction(), this.ejbDescriptor.getName()});
                }
                this.transactionManager.rollback();
            } else if (newException != null && this.isAppExceptionRequiringRollback(newException)) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.commit();
            }
            return newException;
        }
        catch (RollbackException ex) {
            _logger.log(Level.FINE, "ejb.transaction_abort_exception", ex);
            return new EJBException("Transaction aborted", (Exception)((Object)ex));
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "ejb.cmt_exception", ex);
            return new EJBException("Unable to complete container-managed transaction.", ex);
        }
    }

    private Throwable processSystemException(Throwable sysEx) {
        EJBException newException;
        if (sysEx instanceof EJBException) {
            return sysEx;
        }
        if (sysEx instanceof NoSuchEntityException) {
            newException = new NoSuchObjectLocalException("NoSuchEntityException thrown by EJB method.");
            newException.initCause(sysEx);
        } else {
            newException = new EJBException();
            newException.initCause(sysEx);
        }
        return newException;
    }

    private boolean isAppExceptionRequiringRollback(Throwable exception) {
        Class<?> clazz;
        if (exception == null) {
            return false;
        }
        String exceptionClassName = clazz.getName();
        Map appExceptions = this.ejbDescriptor.getEjbBundleDescriptor().getApplicationExceptions();
        boolean appExceptionRequiringRollback = false;
        for (clazz = exception.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String eClassName = clazz.getName();
            if (!appExceptions.containsKey(eClassName)) continue;
            if (!exceptionClassName.equals(eClassName) && !((EjbApplicationExceptionInfo)appExceptions.get(eClassName)).getInherited()) break;
            appExceptionRequiringRollback = ((EjbApplicationExceptionInfo)appExceptions.get(eClassName)).getRollback();
            break;
        }
        return appExceptionRequiringRollback;
    }
}

