/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.node.AdministeredObjectDefinitionNode;
import com.sun.enterprise.deployment.node.ConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.ContextServiceDefinitionNode;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.JMSConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.JMSDestinationDefinitionNode;
import com.sun.enterprise.deployment.node.JndiEnvRefNode;
import com.sun.enterprise.deployment.node.MailSessionNode;
import com.sun.enterprise.deployment.node.ManagedExecutorDefinitionNode;
import com.sun.enterprise.deployment.node.ManagedScheduledExecutorDefinitionNode;
import com.sun.enterprise.deployment.node.ManagedThreadFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.SecurityRoleRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.node.AroundInvokeNode;
import org.glassfish.ejb.deployment.node.AroundTimeoutNode;
import org.glassfish.ejb.deployment.node.ScheduledTimerNode;
import org.glassfish.ejb.deployment.node.SecurityIdentityNode;
import org.w3c.dom.Node;

public abstract class EjbNode<S extends EjbDescriptor>
extends DisplayableComponentNode<S> {
    public EjbNode() {
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class, "addEnvironmentProperty");
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        JndiEnvRefNode serviceRefNode = (JndiEnvRefNode)this.serviceLocator.getService(JndiEnvRefNode.class, "service-ref", new Annotation[0]);
        if (serviceRefNode != null) {
            this.registerElementHandler(new XMLElement("service-ref"), serviceRefNode.getClass(), "addServiceReferenceDescriptor");
        }
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("data-source"), DataSourceDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("mail-session"), MailSessionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("connection-factory"), ConnectionFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("administered-object"), AdministeredObjectDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("jms-connection-factory"), JMSConnectionFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("jms-destination"), JMSDestinationDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("security-identity"), SecurityIdentityNode.class);
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addResourceEnvReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class);
        this.registerElementHandler(new XMLElement("persistence-context-ref"), EntityManagerReferenceNode.class, "addEntityManagerReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceNode.class, "addEntityManagerFactoryReferenceDescriptor");
        this.registerElementHandler(new XMLElement("timer"), ScheduledTimerNode.class, "addScheduledTimerDescriptorFromDD");
        this.registerElementHandler(new XMLElement("managed-executor"), ManagedExecutorDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("managed-thread-factory"), ManagedThreadFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("managed-scheduled-executor"), ManagedScheduledExecutorDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("context-service"), ContextServiceDefinitionNode.class, "addResourceDescriptor");
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbReference) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding ejb ref " + newDescriptor);
            }
            this.getEjbDescriptor().addEjbReferenceDescriptor((EjbReferenceDescriptor)newDescriptor);
        } else if (newDescriptor instanceof RunAsIdentityDescriptor) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding security-identity" + newDescriptor);
            }
            this.getEjbDescriptor().setUsesCallerIdentity(false);
            this.getEjbDescriptor().setRunAsIdentity((RunAsIdentityDescriptor)newDescriptor);
        } else if (newDescriptor instanceof MessageDestinationReferenceDescriptor) {
            MessageDestinationReferenceDescriptor msgDestRef = (MessageDestinationReferenceDescriptor)newDescriptor;
            EjbBundleDescriptorImpl ejbBundle = (EjbBundleDescriptorImpl)((Object)this.getParentNode().getDescriptor());
            msgDestRef.setReferringBundleDescriptor((BundleDescriptor)ejbBundle);
            this.getEjbDescriptor().addMessageDestinationReferenceDescriptor(msgDestRef);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public S getDescriptor() {
        return this.getEjbDescriptor();
    }

    public abstract S getEjbDescriptor();

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-name", "setName");
        table.put("ejb-class", "setEjbClassName");
        table.put("mapped-name", "setMappedName");
        return table;
    }

    protected void writeCommonHeaderEjbDescriptor(Node ejbNode, EjbDescriptor descriptor) {
        EjbNode.appendTextChild((Node)ejbNode, (String)"ejb-name", (String)descriptor.getName());
        EjbNode.appendTextChild((Node)ejbNode, (String)"mapped-name", (String)descriptor.getMappedName());
    }

    protected void writeSecurityIdentityDescriptor(Node parent, EjbDescriptor descriptor) {
        if (!descriptor.getUsesCallerIdentity().booleanValue() && descriptor.getRunAsIdentity() == null) {
            return;
        }
        SecurityIdentityNode.writeSecureIdentity(parent, "security-identity", descriptor);
    }

    protected void writeRoleReferenceDescriptors(Node parentNode, Iterator<RoleReference> refs) {
        SecurityRoleRefNode node = new SecurityRoleRefNode();
        while (refs.hasNext()) {
            RoleReference roleRef = refs.next();
            node.writeDescriptor(parentNode, "security-role-ref", roleRef);
        }
    }

    protected static void writeAroundInvokeDescriptors(Node parentNode, Iterator<LifecycleCallbackDescriptor> aroundInvokeDescs) {
        if (aroundInvokeDescs == null || !aroundInvokeDescs.hasNext()) {
            return;
        }
        AroundInvokeNode subNode = new AroundInvokeNode();
        while (aroundInvokeDescs.hasNext()) {
            LifecycleCallbackDescriptor next = aroundInvokeDescs.next();
            subNode.writeDescriptor(parentNode, "around-invoke", next);
        }
    }

    protected static void writeAroundTimeoutDescriptors(Node parentNode, Iterator<LifecycleCallbackDescriptor> aroundTimeoutDescs) {
        if (aroundTimeoutDescs == null || !aroundTimeoutDescs.hasNext()) {
            return;
        }
        AroundTimeoutNode subNode = new AroundTimeoutNode();
        while (aroundTimeoutDescs.hasNext()) {
            LifecycleCallbackDescriptor next = aroundTimeoutDescs.next();
            subNode.writeDescriptor(parentNode, "around-timeout", next);
        }
    }
}

