/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.ClassGenerator;
import com.sun.ejb.codegen.Generator;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.deployment.common.DeploymentException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AsmSerializableBeanGenerator {
    private static final int INTF_FLAGS = 3;
    private final ClassLoader loader;
    private final Class<?> baseClass;
    private final String subclassName;

    public static String getGeneratedSerializableClassName(String beanClass) {
        String packageName = Generator.getPackageName(beanClass);
        String simpleName = Generator.getBaseName(beanClass);
        String generatedSimpleName = "_" + simpleName + "_Serializable";
        return packageName == null ? generatedSimpleName : packageName + "." + generatedSimpleName;
    }

    public AsmSerializableBeanGenerator(ClassLoader loader, Class baseClass, String serializableSubclassName) {
        this.loader = loader;
        this.baseClass = baseClass;
        this.subclassName = serializableSubclassName;
    }

    public String getSerializableSubclassName() {
        return this.subclassName;
    }

    public Class generateSerializableSubclass() throws Exception {
        ClassWriter cw;
        ClassWriter tv = cw = new ClassWriter(3);
        String subclassInternalName = this.subclassName.replace('.', '/');
        String[] interfaces = new String[]{Type.getType(Serializable.class).getInternalName()};
        tv.visit(55, 1, subclassInternalName, null, Type.getType(this.baseClass).getInternalName(), interfaces);
        Constructor<?>[] ctors = this.baseClass.getConstructors();
        Constructor<?> parentCtor = null;
        for (Constructor<?> ctor : ctors) {
            if (ctor.getParameterTypes().length == 0) {
                parentCtor = ctor;
                break;
            }
            if (!ctor.isAnnotationPresent(Inject.class)) continue;
            parentCtor = ctor;
        }
        if (parentCtor == null) {
            throw new DeploymentException("A class " + this.baseClass.getName() + " doesn't have any appropriate constructor");
        }
        String paramTypeString = Type.getConstructorDescriptor(parentCtor);
        int numArgsToPass = parentCtor.getParameterCount() + 1;
        MethodVisitor ctorv = tv.visitMethod(1, "<init>", paramTypeString, null, null);
        for (int i = 0; i < numArgsToPass; ++i) {
            ctorv.visitVarInsn(25, i);
        }
        ctorv.visitMethodInsn(183, Type.getType(this.baseClass).getInternalName(), "<init>", paramTypeString, false);
        ctorv.visitInsn(177);
        ctorv.visitMaxs(numArgsToPass, numArgsToPass);
        MethodVisitor cv = cw.visitMethod(2, "writeObject", "(Ljava/io/ObjectOutputStream;)V", null, new String[]{"java/io/IOException"});
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(184, "com/sun/ejb/EJBUtils", "serializeObjectFields", "(Ljava/lang/Object;Ljava/io/ObjectOutputStream;)V", false);
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        cv = cw.visitMethod(2, "readObject", "(Ljava/io/ObjectInputStream;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(184, "com/sun/ejb/EJBUtils", "deserializeObjectFields", "(Ljava/lang/Object;Ljava/io/ObjectInputStream;)V", false);
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        tv.visitEnd();
        byte[] classData = cw.toByteArray();
        PrivilegedAction<Class> action = () -> ClassGenerator.defineClass(this.loader, this.subclassName, classData, this.baseClass.getProtectionDomain());
        return AccessController.doPrivileged(action);
    }
}

