/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.InterceptorManager;
import jakarta.ejb.EJBException;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class AroundInvokeInterceptor {
    protected int index;
    protected Method method;

    AroundInvokeInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
        try {
            Method finalM = method;
            if (!finalM.trySetAccessible()) {
                throw new InaccessibleObjectException("Unable to make accessible: " + finalM);
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    Object intercept(InterceptorManager.AroundInvokeContext invCtx) throws Throwable {
        try {
            return this.method.invoke(invCtx.getInterceptorInstances()[this.index], invCtx);
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
    }

    public String toString() {
        return "[" + this.index + "]: " + this.method;
    }
}

