/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.CallbackInterceptor;
import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;

class BeanCallbackInterceptor
extends CallbackInterceptor {
    private static final Object[] NULL_ARGS = null;

    BeanCallbackInterceptor(Method method) {
        super(-1, method);
    }

    @Override
    Object intercept(CallbackInvocationContext invContext) throws Throwable {
        try {
            this.method.invoke(invContext.getTarget(), NULL_ARGS);
            return invContext.proceed();
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }

    @Override
    boolean isBeanCallback() {
        return true;
    }

    @Override
    public String toString() {
        return "beancallback[" + this.index + "]: " + this.method;
    }
}

